/*
 * Decompiled with CFR 0.152.
 */
package dvi.ctx;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviPaperSize;
import dvi.DviResolution;
import dvi.api.CharacterCodeMapper;
import dvi.api.DevicePainter;
import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.api.DviData;
import dvi.api.DviDocument;
import dvi.api.DviExecutor;
import dvi.api.DviExecutorHandler;
import dvi.api.DviFont;
import dvi.api.FullMetrics;
import dvi.api.SimpleMetrics;
import dvi.ctx.DviToolkit;
import dvi.ctx.FileLocationResolver;
import dvi.ctx.SimpleJisToUnicodeMapper;
import dvi.doc.DirectFileDviDocument;
import dvi.doc.StreamDviDocument;
import dvi.doc.URLDviDocument;
import dvi.font.DviFontResolver;
import dvi.font.FullMetricsResolver;
import dvi.font.GlyphCache;
import dvi.font.LogicalFont;
import dvi.render.BasicExecutor;
import dvi.render.DefaultDevicePainter;
import dvi.util.DviUtils;
import dvi.util.concurrent.CachedComputer;
import dvi.util.concurrent.ThreadedComputer;
import dvi.util.progress.ManagedProgressItem;
import dvi.util.progress.ProgressRecorder;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public class DefaultDviContext
implements DviContext {
    private static final Logger LOGGER = Logger.getLogger(DefaultDviContext.class.getName());
    private static final String DVICORE_INTERNAL_FILENAME_PREFIX = "dvicore-";
    private final GlyphCache glyphCache = new GlyphCache();
    private final CharacterCodeMapper characterCodeMapper = new SimpleJisToUnicodeMapper();
    private final ProgressRecorder recorder = new ProgressRecorder(this){

        protected boolean removeEldestElement(ManagedProgressItem item) {
            List<ManagedProgressItem> list = this.getProgressItems();
            return list.size() > 10;
        }
    };
    private final Properties prop;
    private static final CachedComputer<String, Collection<DviFont>> dviFontComputer = new CachedComputer(new ThreadedComputer(1));
    private static final CachedComputer<String, Collection<FullMetrics>> fullMetricsComputer = new CachedComputer(new ThreadedComputer(1));
    private static final Map<String, DviPaperSize> paperSizes = new TreeMap<String, DviPaperSize>();
    private static final DviResolution defaultResolution = new DviResolution(2400, 18);
    private static final CachedComputer<String, Collection<URL>> dviResourceComputer = new CachedComputer(new ThreadedComputer(1));
    private final DviToolkit dviToolkit = new DviToolkit(this);

    public DefaultDviContext() throws DviException {
        this(null);
    }

    public DefaultDviContext(Properties prop) throws DviException {
        if (prop == null) {
            prop = this.getDefaultProperties();
        }
        this.prop = prop;
        this.initializeFontMapper();
        this.populatePaperSizes();
        this.initializeDirs();
    }

    protected void initializeDirs() throws DviException {
        File tmpDir = this.getTemporaryDirectory();
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new DviException("Failed to create temporary directory: " + tmpDir);
        }
    }

    protected Properties getDefaultProperties() throws DviException {
        try {
            URL url = DefaultDviContext.class.getResource("default-context.properties");
            Properties prop = new Properties();
            prop.load(url.openStream());
            return prop;
        }
        catch (Exception e) {
            throw new DviException(e);
        }
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void execute(DviData data, DviExecutorHandler handler) throws DviException {
        this.newDviExecutor().execute(data, handler);
    }

    public DviFont findDviFont(LogicalFont logicalFont) throws DviException {
        DviFontResolver computation = new DviFontResolver((DviContextSupport)this, logicalFont);
        try {
            Collection<DviFont> fonts = dviFontComputer.compute(computation).get();
            Iterator<DviFont> i$ = fonts.iterator();
            if (i$.hasNext()) {
                DviFont font = i$.next();
                return font;
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new DviException(e);
        }
        catch (ExecutionException e) {
            throw new DviException(e);
        }
    }

    public SimpleMetrics findDviSimpleMetrics(DviFontSpec fs) throws DviException {
        return this.findDviFullMetrics(fs);
    }

    public FullMetrics findDviFullMetrics(DviFontSpec fs) throws DviException {
        FullMetricsResolver computation = new FullMetricsResolver((DviContextSupport)this, fs);
        try {
            Collection<FullMetrics> fonts = fullMetricsComputer.compute(computation).get();
            Iterator<FullMetrics> i$ = fonts.iterator();
            if (i$.hasNext()) {
                FullMetrics font = i$.next();
                return font;
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new DviException(e);
        }
        catch (ExecutionException e) {
            throw new DviException(e);
        }
    }

    public CharacterCodeMapper getCharacterCodeMapper(LogicalFont logicalFont) throws DviException {
        return this.characterCodeMapper;
    }

    public DviContext getDviContext() {
        return this;
    }

    public GlyphCache getGlyphCache() throws DviException {
        return this.glyphCache;
    }

    protected void initializeFontMapper() {
    }

    public DevicePainter newDevicePainter() throws DviException {
        return new DefaultDevicePainter(this);
    }

    public DviExecutor newDviExecutor() throws DviException {
        return new BasicExecutor(this);
    }

    public DviDocument openDviDocument(File file) throws DviException {
        return new DirectFileDviDocument(this, file);
    }

    public DviDocument openDviDocument(InputStream is) throws DviException {
        return new StreamDviDocument(this, is);
    }

    public DviDocument openDviDocument(URL url) throws DviException {
        return new URLDviDocument(this, url);
    }

    public ProgressRecorder getProgressRecorder() {
        return this.recorder;
    }

    protected void populatePaperSizes() {
        this.addPaperSize(new DviPaperSize(841.0, 1189.0, "A0"));
        this.addPaperSize(new DviPaperSize(594.0, 841.0, "A1"));
        this.addPaperSize(new DviPaperSize(420.0, 594.0, "A2"));
        this.addPaperSize(new DviPaperSize(297.0, 420.0, "A3"));
        this.addPaperSize(new DviPaperSize(210.0, 297.0, "A4"));
        this.addPaperSize(new DviPaperSize(148.0, 210.0, "A5"));
        this.addPaperSize(new DviPaperSize(105.0, 148.0, "A6"));
        this.addPaperSize(new DviPaperSize(74.0, 105.0, "A7"));
        this.addPaperSize(new DviPaperSize(52.0, 74.0, "A8"));
        this.addPaperSize(new DviPaperSize(37.0, 52.0, "A9"));
        this.addPaperSize(new DviPaperSize(26.0, 37.0, "A10"));
    }

    protected void addPaperSize(DviPaperSize dviPaperSize) {
        if (dviPaperSize == null) {
            return;
        }
        paperSizes.put(dviPaperSize.description().toLowerCase(), dviPaperSize);
    }

    public DviPaperSize findPaperSizeByName(String name) throws DviException {
        if (name == null) {
            return null;
        }
        return paperSizes.get(name.toLowerCase());
    }

    public DviPaperSize getDefaultPaperSize() throws DviException {
        return this.findPaperSizeByName("A4");
    }

    public DviPaperSize[] listPaperSizes() throws DviException {
        return paperSizes.values().toArray(new DviPaperSize[0]);
    }

    public DviResolution getDefaultResolution() throws DviException {
        return defaultResolution;
    }

    public URL getDviResource(String filename) throws DviException {
        if (filename.startsWith(DVICORE_INTERNAL_FILENAME_PREFIX)) {
            return null;
        }
        FileLocationResolver c = new FileLocationResolver(this, "dvi/builtin", filename);
        Future<Collection<URL>> future = dviResourceComputer.compute(c);
        try {
            Collection<URL> list = future.get();
            Iterator<URL> i$ = list.iterator();
            if (i$.hasNext()) {
                URL url = i$.next();
                LOGGER.finest("resolved resource: filename=" + filename + " url=" + url);
                return url;
            }
            return null;
        }
        catch (InterruptedException e) {
            LOGGER.warning(e.toString());
            throw new DviException(e);
        }
        catch (ExecutionException e) {
            LOGGER.warning(e.toString());
            throw new DviException(e);
        }
    }

    public LogicalFont mapLogicalFont(LogicalFont logicalFont) throws DviException {
        if (logicalFont == null) {
            return null;
        }
        String prefix = this.getClass().getName();
        String face = this.getProperties().getProperty(prefix + ".fontMap." + logicalFont.fontSpec().name());
        if (face == null) {
            return logicalFont;
        }
        LogicalFont newLogicalFont = logicalFont.renameTo(face);
        LOGGER.fine("Map logical font: " + logicalFont + " => " + newLogicalFont);
        return newLogicalFont;
    }

    public File getCacheDirectory() throws DviException {
        String userDir = System.getProperty("user.dir");
        File var = new File(userDir, "var");
        return new File(var, "cache");
    }

    public File getTemporaryDirectory() throws DviException {
        String tempDir = System.getProperty("java.io.tmpdir");
        return new File(tempDir, "dvicore");
    }

    public String getExecutableName(String name) throws DviException {
        if ("gs".equals(name) && DviUtils.isWindows()) {
            return "gswin32c";
        }
        return name;
    }

    public DviToolkit getDviToolkit() {
        return this.dviToolkit;
    }
}

