/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import java.io.Serializable;

public final class DviPoint
implements Serializable {
    private static final long serialVersionUID = 5621339308791022419L;
    public static final DviPoint ORIGIN = new DviPoint(0, 0);
    public final int x;
    public final int y;

    public DviPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public DviPoint(DviPoint orig) {
        this(orig.x, orig.y);
    }

    public DviPoint translate(DviPoint p) {
        return new DviPoint(this.x + p.x, this.y + p.y);
    }

    public DviPoint translate(int dx, int dy) {
        return new DviPoint(this.x + dx, this.y + dy);
    }

    public DviPoint shrink(int f) {
        if (f <= 0) {
            throw new IllegalArgumentException("shrink factor can't be <= 0.");
        }
        return new DviPoint(DviPoint.flooredDivision(this.x, f), DviPoint.flooredDivision(this.y, f));
    }

    public DviPoint magnify(int f) {
        return new DviPoint(this.x * f, this.y * f);
    }

    private static int flooredDivision(int a, int b) {
        return a < 0 ? (a - b + 1) / b : a / b;
    }

    public int hashCode() {
        return this.x + 33 * this.y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DviPoint) {
            DviPoint p = (DviPoint)obj;
            return p.x == this.x && p.y == this.y;
        }
        return false;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

