#include	"dv_repeater.h"

int	handler_init(void);
int     read_config(int argc, char **argv);
void	sig_init(void);

int	init(int argc, char **argv)
{
	int	err;

	sig_init();
	uname (&uname_buf);
	tzset();

        if (daemon (0, 0) < 0)
        {
                time (&cur_time);
                printf ("%24.24s Please run root privilage mode!\n", ctime(&cur_time));
                exit (0);
        }




	gateway_port = 0;
	sys_timeout.tv_sec = 60;
	sys_timeout.tv_usec = 0;
	node_NoRespReply_sw = FALSE;
	dvap_NoRespReply_sw = FALSE;
	recv_sw = FALSE;
	area1_recv_sw = FALSE;
	area2_recv_sw = FALSE;
	area3_recv_sw = FALSE;
	HeaderLength = 0;
	repeater = FALSE;
	VenderID = 0x4d8;
	ProductID = 0x300;
	
	node_sw = TRUE;
	dvap_sw = TRUE;
	dvap_freq = 0;
	dvap_tx_freq = 0;
	dvap_rx_freq = 0;
	dvap_squelch = 0;
	dvap_calibration = 0;
	dvap_auto_calibration = FALSE;
	dvap_auto_calibration_set = FALSE;
	dvap_squelch_status = 0x00;

        tv.tv_sec = 0;
        tv.tv_nsec = 2000000;   /* 2 m sec. */
        FD_ZERO (&save_rfds);
	
	memset (node_area_rep_callsign, 0x20, 8);
	memset (dvap_area_rep_callsign, 0x20, 8);

	memset (area1_rep_callsign, 0x20, 8);
	memset (area2_rep_callsign, 0x20, 8);
	memset (area3_rep_callsign, 0x20, 8);
	area1_port = 0;
	area2_port = 0;
	area3_port = 0;

	monitor_port = 0;
	memset (monitor_name, 0x00, 128);
	memset (area1_fqdn, 0x00, 128);
	memset (area2_fqdn, 0x00, 128);
	memset (area3_fqdn, 0x00, 128);

	echo_position_send_interval = 0;

	listen_port = 0;

/* LOG FILE open */
	log_file = fopen (LOG_FILE, "a");
	time (&cur_time);
	fprintf (log_file, "\n%24.24s dv_repeater start V%s (Compiled %s %s)\n", ctime(&cur_time), PACKAGE_VERSION, __DATE__, __TIME__);
	fflush(log_file);

/* make PID file */
        pid_file = fopen (PID_FILE, "r");
        if (pid_file)
        {
                time (&cur_time);
                fprintf (log_file, "%24.24s Already running dv_ap.\n",
                        ctime(&cur_time));
                fclose (pid_file);
                exit (0);
        }
	pid_file = fopen (PID_FILE, "w");
	if (pid_file == NULL)
	{
		fprintf (log_file, "%24.24s Already running dv_repeater.\n", 
			ctime(&cur_time));
		fflush (log_file);
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file);

	if (!handler_init()) return FALSE;

	if (!read_config(argc, (char **)argv)) return FALSE;

	if (listen_port == 0) listen_port = gateway_port;

	if (debug)
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s node area repeater : %8.8s\n", 
			ctime(&cur_time), node_area_rep_callsign);
		fprintf (log_file, "%24.24s dvap area repeater : %8.8s\n",
			ctime(&cur_time), dvap_area_rep_callsign);
		fprintf (log_file, "%24.24s gateway call  : %8.8s\n", 
			ctime (&cur_time), gateway_callsign);
		fprintf (log_file, "%24.24s system call   : %8.8s\n",
			ctime(&cur_time), sys_call);
		if (echo_server[0] != 0x20)
		{
			fprintf (log_file, "%24.24s echo_server   : %8.8s(%8.8s)\n",
			ctime (&cur_time), echo_server, echo_area_rep_callsign);
		}
		fprintf (log_file, "%24.24s gateway : %s:%d:%d\n",
			ctime (&cur_time), gateway_name, gateway_port, listen_port);
		if (monitor_port)
		{
			fprintf (log_file, "%24.24s monitor : %s:%d\n",
				ctime (&cur_time), monitor_name, monitor_port);
		}
		fflush (log_file);
	}


	voice_pnt = 0;
	seq = 0;
	m = 0;
	node_last_frame_sw = FALSE;
	dvap_last_frame_sw = FALSE;
	rep_position_send_sw = FALSE;
	time (&echo_position_send_time);
	send_null_sw = FALSE;
	sig_term = FALSE;

	node_usb_init();
	dvap_open();

        memset (&hints, 0x00, sizeof(hints));
        hints.ai_socktype = SOCK_DGRAM;
        hints.ai_family = PF_UNSPEC;
        hints.ai_flags = AI_PASSIVE;
        sprintf (PORT, "%d", listen_port);
        if ((err = getaddrinfo (NULL, PORT, &hints, &gateway_in)) != 0)
        {
                time (&cur_time);
                fprintf (log_file, "%24.24s getaddrinfo error(gateway in) %s\n",
                        ctime(&cur_time), gai_strerror(err));
                fprintf (log_file, "%24.24s gatewaay : %s\n", ctime(&cur_time), gateway_name);
                fflush (log_file);
        }
        if((in_sd = socket(gateway_in->ai_family, gateway_in->ai_socktype, gateway_in->ai_protocol)) < 0)
	{
		fprintf (log_file, "%24.24s socket error in gateway in %s\n",
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
                return FALSE;
        }
	FD_SET (in_sd, &save_rfds);

	if (monitor_port)
	{ 
		memset (&hints, 0x00, sizeof(hints));
		hints.ai_socktype = SOCK_DGRAM;
		hints.ai_family = PF_UNSPEC;
		sprintf (PORT, "%d", monitor_port);
		time (&cur_time);
		if ((err = getaddrinfo (monitor_name, PORT, &hints, &monitor_out)) != 0)
		{
			fprintf (log_file, "%24.24s getaddrinfo error(monitor out) %s\n",
				ctime(&cur_time), gai_strerror(err));
			fprintf (log_file, "%24.24s monitor : %s\n", ctime(&cur_time), monitor_name);
			fflush (log_file);
		}
		if((monitor_sd = socket(monitor_out->ai_family, monitor_out->ai_socktype, monitor_out->ai_protocol)) < 0) {
			fprintf (log_file, "%24.24s socket error in monitor port %s\n",
				ctime (&cur_time), strerror (errno));
			fflush (log_file);
			return FALSE;
		}
	}

        memset (&hints, 0x00, sizeof(hints));
        hints.ai_socktype = SOCK_DGRAM;
        hints.ai_family = PF_UNSPEC;
        sprintf (PORT, "%d", gateway_port);
	time (&cur_time);
        if ((err = getaddrinfo (gateway_name, PORT, &hints, &gateway_out)) != 0)
        {
                fprintf (log_file, "%24.24s getaddrinfo error(gateway out) %s\n",
                        ctime(&cur_time), gai_strerror(err));
                fprintf (log_file, "%24.24s gatewaay : %s\n", ctime(&cur_time), gateway_name);
                fflush (log_file);
        }
	if((out_sd = socket(gateway_out->ai_family, gateway_out->ai_socktype, gateway_out->ai_protocol)) < 0)
	{
		fprintf (log_file, "%24.24s socket error in gateway port %s\n",
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
		return FALSE;
	}

        if (area1_port)
        {
                memset (&hints, 0x00, sizeof(hints));
                hints.ai_socktype = SOCK_DGRAM;
                hints.ai_family = PF_UNSPEC;
                hints.ai_flags = AI_PASSIVE;
                sprintf (PORT, "%d", area1_port);
                if ((err = getaddrinfo (NULL, PORT, &hints, &area1_in)) != 0)
                {
                        time (&cur_time);
                        fprintf (log_file, "%24.24s getaddrinfo error(area1 in) %s\n",
                                ctime(&cur_time), gai_strerror(err));
                        fprintf (log_file, "%24.24s area3 : %s\n", ctime(&cur_time), area1_rep_callsign);
                        fflush (log_file);
                }
                if((area1_sd = socket(area1_in->ai_family, area1_in->ai_socktype, area1_in->ai_protocol)) < 0)
                {
                        fprintf (log_file, "%24.24s socket error in area1 repeater in %s\n",
                                ctime(&cur_time), strerror(errno));
                        fflush (log_file);
                        return FALSE;
                }
                FD_SET (area1_sd, &save_rfds);
                if(bind(area1_sd, area1_in->ai_addr, area1_in->ai_addrlen) < 0)
                {
                        fprintf (log_file, "%24.24s bind error in area1 port %s\n",
                                ctime(&cur_time), strerror(errno));
                        fflush (log_file);
                        return FALSE;
                }
        }


	if (area2_port)
	{
        	memset (&hints, 0x00, sizeof(hints));
        	hints.ai_socktype = SOCK_DGRAM;
        	hints.ai_family = PF_UNSPEC;
        	hints.ai_flags = AI_PASSIVE;
        	sprintf (PORT, "%d", area2_port);
        	if ((err = getaddrinfo (NULL, PORT, &hints, &area2_in)) != 0)
        	{
                	time (&cur_time);
                	fprintf (log_file, "%24.24s getaddrinfo error(area3 in) %s\n",
                        	ctime(&cur_time), gai_strerror(err));
                	fprintf (log_file, "%24.24s area2 : %s\n", ctime(&cur_time), area2_rep_callsign);
                	fflush (log_file);
        	}
        	if((area2_sd = socket(area2_in->ai_family, area2_in->ai_socktype, area2_in->ai_protocol)) < 0)
        	{
                	fprintf (log_file, "%24.24s socket error in area2 repeater in %s\n",
                        	ctime(&cur_time), strerror(errno));
                	fflush (log_file);
                	return FALSE;
        	}
        	FD_SET (area2_sd, &save_rfds);
                if(bind(area2_sd, area2_in->ai_addr, area2_in->ai_addrlen) < 0)
                {
                        fprintf (log_file, "%24.24s bind error in area2 port %s\n",
                                ctime(&cur_time), strerror(errno));
                        fflush (log_file);
                        return FALSE;
                }
	}

        if (area3_port)
        {
                memset (&hints, 0x00, sizeof(hints));
                hints.ai_socktype = SOCK_DGRAM;
                hints.ai_family = PF_UNSPEC;
                hints.ai_flags = AI_PASSIVE;
                sprintf (PORT, "%d", area3_port);
                if ((err = getaddrinfo (NULL, PORT, &hints, &area3_in)) != 0)
                {
                        time (&cur_time);
                        fprintf (log_file, "%24.24s getaddrinfo error(area3 in) %s\n",
                                ctime(&cur_time), gai_strerror(err));
                        fprintf (log_file, "%24.24s area3 : %s\n", ctime(&cur_time), area3_rep_callsign);
                        fflush (log_file);
                }
                if((area3_sd = socket(area3_in->ai_family, area3_in->ai_socktype, area3_in->ai_protocol)) < 0)
                {
                        fprintf (log_file, "%24.24s socket error in area3 repeater in %s\n",
                                ctime(&cur_time), strerror(errno));
                        fflush (log_file);
                        return FALSE;
                }
                FD_SET (area3_sd, &save_rfds);
        	if(bind(area3_sd, area3_in->ai_addr, area3_in->ai_addrlen) < 0)
        	{
                	fprintf (log_file, "%24.24s bind error in area3 port %s\n",
                        	ctime(&cur_time), strerror(errno));
                	fflush (log_file);
                	return FALSE;
        	}
       	}

	time(&cur_time); 
	if(bind(in_sd, gateway_in->ai_addr, gateway_in->ai_addrlen) < 0) 
	{
		fprintf (log_file, "%24.24s bind error in gateway port %s\n",
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
		return FALSE;
	}

	memset(buf_pkt.buf, 0, sizeof(buf_pkt.buf));
 
	gettimeofday (&tm0, NULL);
	srand(tm0.tv_sec);
	tm0.tv_sec -= sys_timeout.tv_sec;
	tm0.tv_usec = sys_timeout.tv_usec;

	memset (node_save_frame_id, 0x00, 2);
	memset (dvap_save_frame_id, 0x00, 2);
	InetInTime.tv_sec = 0;
	InetInTime.tv_usec = 0;

	if (sys_timeout.tv_sec == 0) send_null_sw = TRUE;

	echo_pnt = NULL;
	send_echo_skip = FALSE;

	Rp = malloc (sizeof (struct FifoPkt));
	Wp = Rp;
	Rp->next = NULL;

	RespRp = malloc (sizeof (struct RespFifoPkt));
	RespWp = RespRp;
	RespRp->next = NULL;

	if (area1_port)
	{
		Area1Rp = malloc (sizeof (struct FifoPkt));
		Area1Wp = Area1Rp;
		Area1Rp->next = NULL;
	}

	if (area2_port)
	{
		Area2Rp = malloc (sizeof (struct FifoPkt));
		Area2Wp = Area2Rp;
		Area2Rp->next = NULL;
	}

	if (area3_port)
	{
		Area3Rp = malloc (sizeof (struct FifoPkt));
		Area3Wp = Area3Rp;
		Area3Rp->next = NULL;
	}
	init_sw = FALSE;
	node_voice_send_sw = FALSE;
	dvap_voice_send_sw = FALSE;

	time (&re_check);

	resp_timer.tv_sec = 0;
	resp_timer.tv_usec = 0;

	return TRUE;
}

