#include	"dv_repeater.h"

int     init(int argc, char **argv);
void	reply_busy(struct dv_header dv_hdr);
void	send_resp(struct dv_header gw_resp);
void	NoRespReply(struct dv_header NoResp);
void	send_reply(char buf[]);
void	echo_server_header(char buf[]);
int	echo_server_voice(char buf[]);
int	echo_server_last(char buf[]);

extern	char	lastframe[];

void	other_area_send (int len, struct dv_packet pkt)
{
	if (area1_port) putArea1Fifo (len, pkt);
	if (area2_port) putArea2Fifo (len, pkt);
	if (area3_port) putArea3Fifo (len, pkt);
}

int	from_inet (void)
{
	int	len;
	char	*cc;

	struct	dv_header	dv_hdr;

	in_addr_len = sizeof(struct sockaddr_storage);

        if((len = recvfrom(in_sd, &buf_pkt, sizeof(buf_pkt), 0, 
                 (struct sockaddr *)&in_addr, &in_addr_len)) < 0) 
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s recvfrom error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
       		return FALSE;
	}

	if (memcmp (buf_pkt.buf, "DSTR", 4)) return TRUE;


	if ((len >= 10) && (buf_pkt.buf[6] == 's'))
	{
		if (memcmp (buf_pkt.buf, "DSTR", 4)) return FALSE;
		send_reply (buf_pkt.buf);
		if (buf_pkt.buf[7] == 0x11) return TRUE;

		if (len == 58) 
		{
			memcpy (&dv_hdr, &buf_pkt.buf[17], 41); /* rf header save */
			if (debug)
			{
				time (&cur_time);
				fprintf (log_file, "%24.24s from INET Flags: %2.2x %2.2x %2.2x\n", 
					ctime(&cur_time), dv_hdr.flags[0], dv_hdr.flags[1], dv_hdr.flags[2]);
				fprintf (log_file, "%24.24s from INET RPT2:%8.8s RPT1:%8.8s\n", 
					ctime(&cur_time), dv_hdr.RPT2Call, dv_hdr.RPT1Call);
				fprintf (log_file, "%24.24s from INET YourCall:%8.8s MyCall:%8.8s MyCall2:%4.4s\n", 
					ctime(&cur_time), dv_hdr.YourCall, dv_hdr.MyCall, dv_hdr.MyCall2);
				fflush (log_file);
				if (!memcmp (&buf_pkt.buf[36], echo_server, 8)) echo_pkt_cnt = 0;
				else if (!memcmp (&buf_pkt.buf[28], node_area_rep_callsign, 8)) node_inet_pkt_cnt = 0;
				else if (!memcmp (&buf_pkt.buf[28], dvap_area_rep_callsign, 8)) dvap_inet_pkt_cnt = 0;
			}
			if (buf_pkt.buf[13] == 0xff) 	/* response */
			{
				putRespFifo (len, buf_pkt.buf);
/*

				if (!memcmp (&buf_pkt.buf[20], node_area_rep_callsign, 8))
				{
					memcpy (&node_gw_resp, &buf_pkt.buf[17], 41);
					node_gw_resp_sw = TRUE;
					node_NoRespReply_sw = FALSE;
				}
				else if (!memcmp (&buf_pkt.buf[20], dvap_area_rep_callsign, 8))
				{
fprintf (log_file, "debug 1000\n");
					memcpy (&dvap_gw_resp, &buf_pkt.buf[17], 41);
					dvap_gw_resp_sw = TRUE;
					dvap_NoRespReply_sw = FALSE;
				}
*/
			}
			else
			{
				if (!memcmp (&buf_pkt.buf[20], echo_area_rep_callsign, 8)
					&& !memcmp(&buf_pkt.buf[36], echo_server, 8))
				{
					if (buf_pkt.buf[17] == 0x00)
						echo_server_header (buf_pkt.buf);
				}
				else if (node_sw)
				{
					if (!memcmp (&buf_pkt.buf[20], node_area_rep_callsign, 8))
					{
						if ((node_save_frame_id[0] == 0x00) && (node_save_frame_id[1] == 0x00))
						/* frame ID check */
						{
							node_gw_resp_sw = FALSE;
							gettimeofday(&InetInTime, NULL);
							memcpy (node_save_frame_id, &buf_pkt.buf[14], 2);
							if (buf_pkt.buf[35] == 'G')
							{
								memcpy (dv_hdr.RPT2Call, &buf_pkt.buf[28], 8);
								memcpy (dv_hdr.RPT1Call, &buf_pkt.buf[20], 8);
							}
							header_send(dv_hdr);
							node_NoRespReply_sw = FALSE;
						}
						else if (memcmp (node_save_frame_id, &buf_pkt.buf[14], 2))
						{
							reply_busy (dv_hdr);
						}
					}
					else
					{
						reply_busy (dv_hdr);
					}
				}
				else if (dvap_sw)
				{
					if (!memcmp (&buf_pkt.buf[20], dvap_area_rep_callsign, 8))
					{
						if ((dvap_save_frame_id[0] == 0x00) && (dvap_save_frame_id[1] == 0x00))
						/* frame ID check */
						{
							dvap_gw_resp_sw = FALSE;
							gettimeofday(&InetInTime, NULL);
							memcpy (dvap_save_frame_id, &buf_pkt.buf[14], 2);
							if (buf_pkt.buf[35] == 'G')
							{
								memcpy (dv_hdr.RPT2Call, &buf_pkt.buf[28], 8);
								memcpy (dv_hdr.RPT1Call, &buf_pkt.buf[20], 8);
							}
							header_send(dv_hdr);
							dvap_NoRespReply_sw = FALSE;
						}
						else if (memcmp (dvap_save_frame_id, &buf_pkt.buf[14], 2))
						{
							reply_busy (dv_hdr);
						}
					}
					else
					{
						reply_busy (dv_hdr);	
					}
				}
				else
				{
					other_area_send (len, buf_pkt.buff_pkt);
				}
			}
		}
		else if ((len == 29) || (len == 32))
		{
			if (debug)
			{
				time (&cur_time);
				if (!memcmp (node_save_frame_id, &buf_pkt.buf[14], 2)) 
				{
					node_inet_pkt_cnt++;
					if ((len == 32) || (buf_pkt.buf[16] & 0x40))
					{
						fprintf (log_file, "%24.24s from INET packets:%ld\n",
							ctime(&cur_time), node_inet_pkt_cnt);
						fflush (log_file);
						node_inet_pkt_cnt = 0;
					}
				}
				else if (!memcmp (dvap_save_frame_id, &buf_pkt.buf[14], 2))
				{
					dvap_inet_pkt_cnt++;
					if ((len == 32) || (buf_pkt.buf[16] & 0x40))
					{
						fprintf (log_file, "%24.24s from INET packets:%ld\n",
							ctime(&cur_time), dvap_inet_pkt_cnt);
						fflush (log_file);
						dvap_inet_pkt_cnt = 0;
					}
					
				}
				else 
				{
					echo_pkt_cnt++;
					//gettimeofday(&InetInTime, NULL);
					if ((len == 32) || (buf_pkt.buf[16] & 0x40))
					{
						fprintf (log_file, "%24.24s from ECHO packets:%ld\n", 
							ctime(&cur_time), echo_pkt_cnt);
						fflush (log_file);
					}
				}
			}

                        if (buf_pkt.buf[13] == 0xff)	/* response */
                        {
				putRespFifo (len, buf_pkt.buf);
			}
			else if (!memcmp (node_save_frame_id, &buf_pkt.buf[14], 2))
			{
				gettimeofday(&InetInTime, NULL);
				if (debug) node_inet_pkt_cnt++;
				if (len == 29)
				{
					if (buf_pkt.buf[16] & 0x40)
					{
						memcpy (&buf_pkt.buf[26], lastframe, 6);
						node_last_send (&buf_pkt.buf[17]);
						memset (node_save_frame_id, 0x00, 2);
					}
					else  node_voice_send (&buf_pkt.buf[17]);
				}
				else if (len == 32)
				{
					memcpy (&buf_pkt.buf[26], lastframe, 6);
					node_last_send(&buf_pkt.buf[17]);
					memset (node_save_frame_id, 0x00, 2);
				}
			}
                        else if (!memcmp (dvap_save_frame_id, &buf_pkt.buf[14], 2))
                        {
                                gettimeofday(&InetInTime, NULL);
                                if (debug) dvap_inet_pkt_cnt++;
                                if (len == 29)
                                {
                                        if (buf_pkt.buf[16] & 0x40)
                                        {
                                                memcpy (&buf_pkt.buf[26], lastframe, 6);
                                                dvap_last_send (&buf_pkt.buf[17]);
                                                memset (dvap_save_frame_id, 0x00, 2);
                                        }
                                        else  dvap_voice_send (&buf_pkt.buf[17]);
                                }
                                else if (len == 32)
                                {
                                        memcpy (&buf_pkt.buf[26], lastframe, 6);
                                        dvap_last_send(&buf_pkt.buf[17]);
                                        memset (dvap_save_frame_id, 0x00, 2);
                                }
                        }
			else
			{
				if (len == 29)
				{
					if (buf_pkt.buf[16] & 0x40)
					{
						if (!echo_server_last (buf_pkt.buf))
						{
							other_area_send (len, buf_pkt.buff_pkt);
						}
					}
					else
					{
						if (!echo_server_voice (buf_pkt.buf))
						{
							other_area_send (len, buf_pkt.buff_pkt);
						}
					}
				}
				else if (len == 32)
				{
					if (!echo_server_last (buf_pkt.buf))
					{
						other_area_send (len, buf_pkt.buff_pkt);
					}
				}
					
			}
		}
	}
	if ((len == 10) && (buf_pkt.buf[6] == 'r'))		/* reply(ack) packet */
	{
		recv_m = (buf_pkt.buf[4] << 8)  | (buf_pkt.buf[5] & 0xff);
		recv_m &= 0xffff;
		recv_sw = TRUE;
	}
	return TRUE;
}



int	area1_read (void)
{
	int	len;

	in_addr_len = sizeof(struct sockaddr_storage);

	if((len = recvfrom(area1_sd, buf_pkt.buf, sizeof(buf_pkt.buf), 0, 
		(struct sockaddr *)&in_addr, &in_addr_len)) < 0) 
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s recvfrom error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
       		return FALSE;
	}

	if (memcmp (buf_pkt.buf, "DSTR", 4)) return TRUE;


	if ((len >= 10) && (buf_pkt.buf[6] == 's'))
	{
		if (memcmp (buf_pkt.buf, "DSTR", 4)) return FALSE;
		area1_send_reply (buf_pkt.buf);
		if (buf_pkt.buf[7] == 0x11) return TRUE;
		
		putFifo (len, buf_pkt.buff_pkt);
	}
	if ((len == 10) && (buf_pkt.buf[6] == 'r'))		/* reply(ack) packet */
	{
		area1_recv_m = (buf_pkt.buf[4] << 8)  | (buf_pkt.buf[5] & 0xff);
		area1_recv_m &= 0xffff;
		area1_recv_sw = TRUE;
	}
	return TRUE;
}


int	area2_read (void)
{
	int	len;

	in_addr_len = sizeof(struct sockaddr_storage);

	if((len = recvfrom(area2_sd, buf_pkt.buf, sizeof(buf_pkt.buf), 0, 
		(struct sockaddr *)&in_addr, &in_addr_len)) < 0) 
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s recvfrom error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
       		return FALSE;
	}

	if (memcmp (buf_pkt.buf, "DSTR", 4)) return TRUE;


	if ((len >= 10) && (buf_pkt.buf[6] == 's'))
	{
		if (memcmp (buf_pkt.buf, "DSTR", 4)) return FALSE;
		area2_send_reply (buf_pkt.buf);
		if (buf_pkt.buf[7] == 0x11) return TRUE;

                putFifo (len, buf_pkt.buff_pkt);
        }
        if ((len == 10) && (buf_pkt.buf[6] == 'r'))             /* reply(ack) packet */
        {
                area2_recv_m = (buf_pkt.buf[4] << 8)  | (buf_pkt.buf[5] & 0xff);
		area2_recv_m &= 0xffff;
		area2_recv_sw = TRUE;
	}
	return TRUE;
}


int	area3_read (void)
{
	int	len;

	in_addr_len = sizeof(struct sockaddr_storage);

	if((len = recvfrom(area3_sd, buf_pkt.buf, sizeof(buf_pkt.buf), 0, 
		(struct sockaddr *)&in_addr, &in_addr_len)) < 0) 
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s recvfrom error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
       		return FALSE;
	}

	if (memcmp (buf_pkt.buf, "DSTR", 4)) return TRUE;


	if ((len >= 10) && (buf_pkt.buf[6] == 's'))
	{
		if (memcmp (buf_pkt.buf, "DSTR", 4)) return FALSE;
		area3_send_reply (buf_pkt.buf);
		if (buf_pkt.buf[7] == 0x11) return TRUE;
		
		putFifo (len, buf_pkt.buff_pkt);
	}
	if ((len == 10) && (buf_pkt.buf[6] == 'r'))		/* reply(ack) packet */
	{
		area3_recv_m = (buf_pkt.buf[4] << 8)  | (buf_pkt.buf[5] & 0xff);
		area3_recv_m &= 0xffff;
		area3_recv_sw = TRUE;
	}
	return TRUE;
}



