#include	"dv_repeater.h"

void    node_send_resp_voice(char msg[]);
int	cos_check(void);

char   NullVoice0[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16};
char   NullVoice1[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5};
extern	char	dvap_ptt[];

enum
{
        SKIP = 0,
	SEND_WAIT_SET,
	SEND_WAIT_CHECK,
	HEADER_SET,
	HEADER_SEND_CHECK,
	SEND_PTT_ON,
	VOICE_SEND_CHECK,
	VOICE_SEND,
	SEND_LAST_CHECK,
	SEND_LAST,
	SEND_PTT_OFF
} node_response_state = SKIP;

struct	timeval	node_send_wait;
char	msg[20];
unsigned char	frame_seq = 0;
extern	char	lastframe[];


void	node_send_response(void)
{
	struct timeval	tm;
	struct timeval	tm_tmp;
	struct timeval	wait_timer;
	unsigned char	len;
	int	ret;
	

	char	msg_buf[15];

	if (!node_sw) return;

	if (!(node_gw_resp_sw || node_NoRespReply_sw) || cos_check())
	{
		if (node_response_state >= VOICE_SEND_CHECK)
			usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, NULL, 0, 200);		
		node_response_state = SKIP;
		return;
	}

	wait_timer.tv_sec = 1;
	wait_timer.tv_usec = 0;

	switch (node_response_state)
	{
		case SKIP:
			break;
		case SEND_WAIT_SET:
			gettimeofday(&node_send_wait, NULL);
			node_response_state = SEND_WAIT_CHECK;
			frame_seq = 0;
			break;
		case SEND_WAIT_CHECK:
			gettimeofday(&tm, NULL);
                        timersub (&tm, &node_send_wait, &tm_tmp);
                        if (timercmp(&tm_tmp, &wait_timer,  >)) node_response_state = HEADER_SET;
			break;
		case HEADER_SET:
			/* Callsign set */
			if (node_gw_resp_sw)
			{
				usb_control_msg(udev, 0x40, SET_MyCALL, 0, 0, node_gw_resp.MyCall, 8, 200);
				usb_control_msg(udev, 0x40, SET_MyCALL2, 0, 0, node_gw_resp.MyCall2 , 4, 200);
				usb_control_msg(udev, 0x40, SET_YourCALL, 0, 0, node_gw_resp.YourCall, 8, 200);
				usb_control_msg(udev, 0x40, SET_RPT1CALL, 0, 0, node_gw_resp.RPT1Call, 8, 200);
				usb_control_msg(udev, 0x40, SET_RPT2CALL, 0, 0, node_gw_resp.RPT2Call, 8, 200);
				node_gw_resp.flags[0] &= 0x07;
				usb_control_msg(udev, 0x40, SET_FLAGS, 0, 0, node_gw_resp.flags, 3, 200);
			}
			else if (node_NoRespReply_sw)
			{
				usb_control_msg(udev, 0x40, SET_MyCALL, 0, 0, node_area_rep_callsign, 8, 200);
				usb_control_msg(udev, 0x40, SET_MyCALL2, 0, 0, "    " , 4, 200);
				usb_control_msg(udev, 0x40, SET_YourCALL, 0, 0, node_NoResp.YourCall, 8, 200);
				usb_control_msg(udev, 0x40, SET_RPT1CALL, 0, 0, node_NoResp.RPT1Call, 8, 200);
				usb_control_msg(udev, 0x40, SET_RPT2CALL, 0, 0, node_NoResp.RPT2Call, 8, 200);
				node_NoResp.flags[0] = 0x02;
				node_NoResp.flags[1] = 0x00;
				node_NoResp.flags[2] = 0x00;
				usb_control_msg(udev, 0x40, SET_FLAGS, 0, 0, node_NoResp.flags, 3, 200);
			}
			node_response_state = HEADER_SEND_CHECK;
			break;
		case HEADER_SEND_CHECK:
			usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len , 1, 200);
			if (len > 95) node_response_state = SEND_PTT_ON;
			break;
		case SEND_PTT_ON:
			usb_control_msg(udev, 0x40, SET_PTT, ON, 0, NULL, 0, 200);
			node_response_state = VOICE_SEND_CHECK;
			if (node_gw_resp_sw) memcpy (msg, "Dest. not found.    ", 20);
			else if (node_NoRespReply_sw) memcpy (msg, "No Response         ", 20);
			break;
		case VOICE_SEND_CHECK:
			usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len , 1, 200);
			if (len > 12)
			{
				node_response_state = VOICE_SEND;
			}
			break;
		case VOICE_SEND:
			if (frame_seq == 0) ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, NullVoice0, 12, 200);
			else
			{
				memcpy (msg_buf, NullVoice1, 12);
				switch (frame_seq)
				{
                                	case 1:
                                        	msg_buf[9] = 0x40 ^ 0x70;
                                        	msg_buf[10] = msg[0] ^ 0x4f;
                                        	msg_buf[11] = msg[1] ^ 0x93;
                                        	break;
                                	case 2:
                                       		msg_buf[9] = msg[2] ^ 0x70;
                                        	msg_buf[10] = msg[3] ^ 0x4f;
                                        	msg_buf[11] = msg[4] ^ 0x93;
                                        	break;
                                	case 3:
                                        	msg_buf[9] = 0x41 ^ 0x70;
                                        	msg_buf[10] = msg[5] ^ 0x4f;
                                        	msg_buf[11] = msg[6] ^ 0x93;
                                        	break;
                                	case 4:
                                        	msg_buf[9] = msg[7] ^ 0x70;
                                        	msg_buf[10] = msg[8] ^ 0x4f;
                                        	msg_buf[11] = msg[9] ^ 0x93;
                                        	break;
                                	case 5:
                                        	msg_buf[9] = 0x42 ^ 0x70;
                                        	msg_buf[10] = msg[10] ^ 0x4f;
                                        	msg_buf[11] = msg[11] ^ 0x93;
                                        	break;
                                	case 6:
                                        	msg_buf[9] = msg[12] ^ 0x70;
                                        	msg_buf[10] = msg[13] ^ 0x4f;
                                        	msg_buf[11] = msg[14] ^ 0x93;
                                        	break;
                                	case 7:
                                        	msg_buf[9] = 0x43 ^ 0x70;
                                        	msg_buf[10] = msg[15] ^ 0x4f;
                                        	msg_buf[11] = msg[16] ^ 0x93;
                                        	break;
                                	case 8:
                                        	msg_buf[9] = msg[17] ^ 0x70;
                                        	msg_buf[10] = msg[18] ^ 0x4f;
                                        	msg_buf[11] = msg[19] ^ 0x93;
                                        	break;
                        	}
				ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, msg_buf, 12, 200);
			}
			if (ret < 0) break;
			frame_seq++;
			if (frame_seq == 11) node_response_state = SEND_LAST_CHECK;
			else node_response_state = VOICE_SEND_CHECK;
			break;
		case SEND_LAST_CHECK:
			usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len , 1, 200);
			if (len > 15) node_response_state = SEND_LAST;
			break;	
		case SEND_LAST:
			memcpy (&msg_buf[9], lastframe, 6);
			ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, msg_buf, 15, 200);
			if (ret < 0) break;
			node_response_state = SEND_PTT_OFF;
			break;	
		case SEND_PTT_OFF:
			usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, NULL, 0, 200);
			node_response_state = SKIP;
			if (node_gw_resp_sw) node_gw_resp_sw = FALSE;
			if (node_NoRespReply_sw) node_NoRespReply_sw = FALSE;
			break;
	}
}

void	node_send_wait_set(void)
{
	node_response_state = SEND_WAIT_SET;
}

enum
{
        DVAP_SKIP = 0,
	DVAP_SEND_WAIT_SET,
	DVAP_SEND_WAIT_CHECK,
	DVAP_HEADER_SET,
	DVAP_HEADER_SEND_CHECK,
	DVAP_SEND_PTT_ON,
	DVAP_VOICE_SEND_CHECK,
	DVAP_VOICE_SEND,
	DVAP_SEND_LAST_CHECK,
	DVAP_SEND_LAST,
	DVAP_SEND_PTT_OFF
} dvap_response_state = DVAP_SKIP;

struct	timeval	dvap_send_wait;
char	dvap_msg[20];
unsigned char	dvap_resp_pkt[47];
unsigned char	dvap_frame_seq = 0;
extern	char	lastframe[];


void	dvap_send_response(void)
{
	struct timeval	tm;
	struct timeval	tm_tmp;
	struct timeval	wait_timer;
	unsigned short int tmp;

	if (!dvap_sw) return;

        if (!dvap_NoRespReply_sw)
        {
                dvap_response_state = SKIP;
                return;
        }	
	wait_timer.tv_sec = 1;
	wait_timer.tv_usec = 0;

	switch (dvap_response_state)
	{
		case DVAP_SKIP:
			break;
		case DVAP_SEND_WAIT_SET:
			if (dvap_squelch_status) break;
			gettimeofday(&dvap_send_wait, NULL);
			dvap_response_state = DVAP_SEND_WAIT_CHECK;
			dvap_frame_seq = 0;
			break;
		case DVAP_SEND_WAIT_CHECK:
			if (dvap_squelch_status) break;
			gettimeofday(&tm, NULL);
                        timersub (&tm, &dvap_send_wait, &tm_tmp);
                        if (timercmp(&tm_tmp, &wait_timer,  >)) dvap_response_state = DVAP_HEADER_SET;
			break;
		case DVAP_HEADER_SET:
			dvap_resp_pkt[0] = 0x2f;
			dvap_resp_pkt[1] = 0xa0;
			tmp = rand() & 0xffff;
			memcpy (&dvap_resp_pkt[2], &tmp, 2);
			dvap_resp_pkt[4] = 0x80;
			dvap_resp_pkt[5] = 0x00;
			/* Callsign set */
			if (dvap_gw_resp_sw)
			{
				memcpy (&dvap_resp_pkt[6], &dvap_gw_resp, 41);
				dvap_resp_pkt[6] &= 0x07;
			}
			else if (dvap_NoRespReply_sw)
			{
				memcpy (&dvap_resp_pkt[6], &dvap_NoResp, 41);
				dvap_resp_pkt[6] = 0x02;
				dvap_resp_pkt[7] = 0x00;
				dvap_resp_pkt[8] = 0x00;
			}
			dvap_response_state = DVAP_HEADER_SEND_CHECK;
			write (dvap_fd, dvap_resp_pkt, 47);
			break;
		case DVAP_HEADER_SEND_CHECK:
			dvap_response_state = DVAP_SEND_PTT_ON;
			break;
		case DVAP_SEND_PTT_ON:
			dvap_response_state = DVAP_VOICE_SEND_CHECK;
			if (dvap_gw_resp_sw) memcpy (dvap_msg, "Dest. not found.    ", 20);
			else if (dvap_NoRespReply_sw) memcpy (dvap_msg, "No Response         ", 20);
			break;
		case DVAP_VOICE_SEND_CHECK:
			dvap_resp_pkt[0] = 0x12;
			dvap_resp_pkt[1] = 0xc0;
			dvap_response_state = DVAP_VOICE_SEND;
			break;
		case DVAP_VOICE_SEND:
			dvap_resp_pkt[4] = dvap_frame_seq;
			dvap_resp_pkt[5]++;
			memcpy (&dvap_resp_pkt[6], NullVoice1, 12);
			switch (dvap_frame_seq)
			{
				case 0:
					memcpy (&dvap_resp_pkt[6], NullVoice0, 12);
					break;
                               	case 1:
                                       	dvap_resp_pkt[15] = 0x40 ^ 0x70;
                                       	dvap_resp_pkt[16] = dvap_msg[0] ^ 0x4f;
                                       	dvap_resp_pkt[17] = dvap_msg[1] ^ 0x93;
                                       	break;
                               	case 2:
                              		dvap_resp_pkt[15] = dvap_msg[2] ^ 0x70;
                                       	dvap_resp_pkt[16] = dvap_msg[3] ^ 0x4f;
                                       	dvap_resp_pkt[17] = dvap_msg[4] ^ 0x93;
                                       	break;
                               	case 3:
                                       	dvap_resp_pkt[15] = 0x41 ^ 0x70;
                                       	dvap_resp_pkt[16] = dvap_msg[5] ^ 0x4f;
                                       	dvap_resp_pkt[17] = dvap_msg[6] ^ 0x93;
                                       	break;
                               	case 4:
                                       	dvap_resp_pkt[15] = dvap_msg[7] ^ 0x70;
                                       	dvap_resp_pkt[16] = dvap_msg[8] ^ 0x4f;
                                       	dvap_resp_pkt[17] = dvap_msg[9] ^ 0x93;
                                       	break;
                               	case 5:
                                       	dvap_resp_pkt[15] = 0x42 ^ 0x70;
                                       	dvap_resp_pkt[16] = dvap_msg[10] ^ 0x4f;
                                       	dvap_resp_pkt[17] = dvap_msg[11] ^ 0x93;
                                       	break;
                               	case 6:
                                       	dvap_resp_pkt[15] = dvap_msg[12] ^ 0x70;
                                       	dvap_resp_pkt[16] = dvap_msg[13] ^ 0x4f;
                                       	dvap_resp_pkt[17] = dvap_msg[14] ^ 0x93;
                                       	break;
                               	case 7:
                                       	dvap_resp_pkt[15] = 0x43 ^ 0x70;
                                       	dvap_resp_pkt[16] = dvap_msg[15] ^ 0x4f;
                                       	dvap_resp_pkt[17] = dvap_msg[16] ^ 0x93;
                                       	break;
                               	case 8:
                                       	dvap_resp_pkt[15] = dvap_msg[17] ^ 0x70;
                                       	dvap_resp_pkt[16] = dvap_msg[18] ^ 0x4f;
                                       	dvap_resp_pkt[17] = dvap_msg[19] ^ 0x93;
                                       	break;
			}
			write (dvap_fd, dvap_resp_pkt, 18);
			dvap_frame_seq++;
			if (dvap_frame_seq >= 11) dvap_response_state = DVAP_SEND_LAST_CHECK;
			break;
		case DVAP_SEND_LAST_CHECK:
			dvap_response_state = DVAP_SEND_LAST;
			break;	
		case DVAP_SEND_LAST:
			dvap_resp_pkt[4] = dvap_frame_seq;
			dvap_resp_pkt[4] |= 0x40;
			dvap_resp_pkt[5]++;
			write (dvap_fd, dvap_resp_pkt, 18);
			dvap_response_state = DVAP_SEND_PTT_OFF;
			break;	
		case DVAP_SEND_PTT_OFF:
			dvap_response_state = DVAP_SKIP;
			if (dvap_gw_resp_sw) dvap_gw_resp_sw = FALSE;
			if (dvap_NoRespReply_sw) dvap_NoRespReply_sw = FALSE;
			break;
	}
}

void	dvap_send_wait_set(void)
{
	dvap_response_state = DVAP_SEND_WAIT_SET;
}

void	dvap_skip (void)
{
	dvap_response_state = DVAP_SKIP;
}
