#include	"dv_repeater.h"


int	read_config(int argc, char **argv)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	int	field_sw;
	int	port;

	FILE	*config_file;

	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			time(&cur_time);
			fprintf (log_file, "%24.24s config file not found (%s)\n", ctime(&cur_time), argv[1]);
			fflush (log_file);
			return FALSE;
		}
	} 
	else
	{
		config_file = fopen (CONFIG_FILE,"r");
		if (!config_file)
		{
			time(&cur_time);
			fprintf (log_file, "%24.24s config file not found (%s)\n", 
						ctime(&cur_time), CONFIG_FILE);
			fflush (log_file);
			return FALSE;
		}
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "GATEWAY_CALL", 12))
				{
                                        memset (gateway_callsign, 0x20, 8);
                                        while (*pnt)
                                        {
                                        	gateway_callsign[n++] = *pnt;
						if (n > 7) break;
                                                pnt++;
                                        }
					gateway_callsign[7] = 'G';
					memcpy (sys_call, gateway_callsign, 7);
					sys_call[7] = 'S';
				}
				else if (!memcmp (p, "DEBUG", 5))
				{
					debug = atoi (pnt);
				}
				else if (!memcmp (p, "MONITOR_FQDN", 12))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (monitor_name, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt == ':') field_sw++;
                                                else
                                                {
                                                        switch (field_sw)
                                                        {
                                                                case 1:
                                                                        if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                                        break;
                                                                case 0:
                                                                        if (*pnt != 0x20) monitor_name[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                        break;
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n && (port > 0))
                                        {
                                                monitor_name[n] = 0x00;
                                                monitor_port = port;
                                        }
                                        else
                                        {
                                                time (&cur_time);
                                                fprintf (log_file, "%24.24s Invalid Format of MONITORY\n",
                                                                                ctime(&cur_time));
                                                fflush (log_file);
                                                monitor_port = 0;
                                        }
                                }
				else if (!memcmp (p, "REPEATER", 8))
				{
					repeater = atoi (pnt);
				}
				else if (!memcmp (p, "INTERVAL", 8))
				{
					sys_timeout.tv_sec = atoi (pnt);
					sys_timeout.tv_usec = 0;
					if ((sys_timeout.tv_sec != 0) && (sys_timeout.tv_sec < 10)) sys_timeout.tv_sec = 10;
				}
                                else if (!memcmp (p, "GATEWAY_FQDN", 13))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (gateway_name, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt == ':') field_sw++;
                                                else
                                                {
                                                        switch (field_sw)
                                                        {
                                                                case 1:
                                                                        if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                                        break;
                                                                case 0:
                                                                        if (*pnt != 0x20) gateway_name[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                        break;
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n && (port > 0))
                                        {
                                                gateway_name[n] = 0x00;
                                                gateway_port = port;
                                        }
                                        else
                                        {
                                                time (&cur_time);
                                                fprintf (log_file, "%24.24s Invalid Format of GATEWAY\n",
                                                                                ctime(&cur_time));
                                                fflush (log_file);
                                                gateway_port = 0;
                                        }
                                }
				else if (!memcmp (p, "NODE_ADAPTER",12))
				{
					pnt = strtok(pnt, ":");
					VenderID = htoi (pnt);
					pnt = strtok(NULL, delmi);
					ProductID = htoi(pnt);
				}
				else if (!memcmp (p, "NODE_CALL", 9))
				{
					memset (node_area_rep_callsign, 0x20, 8);
					memcpy (node_area_rep_callsign, pnt, strlen(pnt));
				}
				else if (!memcmp (p, "DVAP_TX_FREQUENCY",  17))
				{
					dvap_tx_freq = atoi(pnt);
				}
				else if (!memcmp (p, "DVAP_RX_FREQUENCY",  17))
				{
					dvap_rx_freq = atoi (pnt);
				}
				else if (!memcmp (p, "DVAP_FREQUENCY", 14))
				{
					dvap_freq = atoi (pnt);
				}
				else if (!memcmp (p, "DVAP_SQUELCH", 12))
				{
					dvap_squelch = atoi (pnt);
					if ((dvap_squelch > -45) || (dvap_squelch < -128)) dvap_squelch = 0;
				}
				else if (!memcmp (p, "DVAP_CALIBRATION",  16))
				{
					dvap_calibration = atoi (pnt);
					if ((dvap_calibration < -2000) || (dvap_calibration > 2000)) dvap_calibration = 0;
				}	
				else if (!memcmp (p, "DVAP_CALL", 9))
				{
					memset (dvap_area_rep_callsign, 0x20, 8);
					memcpy (dvap_area_rep_callsign, pnt, strlen(pnt));	
				}
                                else if (!memcmp (p, "DVAP_AUTO_CALIBRATION", 21))
                                {
                                        dvap_auto_calibration = atoi (pnt);
                                }
				else if (!memcmp (p, "ECHO_SERVER", 11))
				{
                                        memset (echo_server, 0x20, 8);
					memset (echo_area_rep_callsign, 0x20, 8);
					pnt = strtok(pnt, ":");
					memcpy (echo_area_rep_callsign, pnt, 8);
					pnt = strtok(NULL, delmi);
					memcpy (echo_server, pnt, 8);
				}
				else if (!memcmp (p, "AREA1_CALL", 10))
				{
					memcpy (area1_rep_callsign, pnt, 8);
				}
				else if (!memcmp (p, "AREA1_FQDN", 10))
				{
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (area1_fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt == ':') field_sw++;
                                                else
                                                {
                                                        switch (field_sw)
                                                        {
                                                                case 1:
                                                                        if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                                        break;
                                                                case 0:
                                                                        if (*pnt != 0x20) area1_fqdn[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                        break;
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n && (port > 0))
                                        {
                                                area1_fqdn[n] = 0x00;
                                                area1_port = port;
                                        }
                                        else
                                        {
                                                time (&cur_time);
                                                fprintf (log_file, "%24.24s Invalid Format of AREA1_FQDN\n",
                                                                                ctime(&cur_time));
                                                fflush (log_file);
                                                area1_port = 0;
                                        }
				}
				else if (!memcmp (p, "AREA2_CALL", 10))
				{
					memcpy (area2_rep_callsign, pnt, 7);
				}
                                else if (!memcmp (p, "AREA2_FQDN", 10))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (area2_fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt == ':') field_sw++;
                                                else
                                                {
                                                        switch (field_sw)
                                                        {
                                                                case 1:
                                                                        if (isdigit (*pnt)) port = port
* 10 + *pnt - '0';
                                                                        break;
                                                                case 0:
									if (*pnt != 0x20) area2_fqdn[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                        break;
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n && (port > 0))
                                        {
                                                area2_fqdn[n] = 0x00;
                                                area2_port = port;
                                        }
                                        else
                                        {
                                                time (&cur_time);
                                                fprintf (log_file, "%24.24s Invalid Format of AREA2_FQDN\n",
                                                                                ctime(&cur_time));
                                                fflush (log_file);
                                                area2_port = 0;
                                        }
                                }
				else if (!memcmp (p, "AREA3_CALL", 10))
				{
					memcpy (area3_rep_callsign, pnt, 7);	
				}
                                else if (!memcmp (p, "AREA3_FQDN", 10))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (area3_fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt == ':') field_sw++;
                                                else
                                                {
                                                        switch (field_sw)
                                                        {
                                                                case 1:
                                                                        if (isdigit (*pnt)) port = port
* 10 + *pnt - '0';
                                                                        break;
                                                                case 0:
									if (*pnt != 0x20) area3_fqdn[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                        break;
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n && (port > 0))
                                        {
                                                area3_fqdn[n] = 0x00;
                                                area3_port = port;
                                        }
                                        else
                                        {
                                                time (&cur_time);
                                                fprintf (log_file, "%24.24s Invalid Format of AREA3_FQDN\n",
                                                                                ctime(&cur_time));
                                                fflush (log_file);
                                                area3_port = 0;
                                        }
                                }
				else
				{
					time (&cur_time);
					fprintf (log_file, "%24.24s Error on config file : %s\n",ctime(&cur_time), buff);
					fflush (log_file);
				}
			}
		}
	}

	fclose (config_file);

	return TRUE;
}

	
