#include	"dv_repeater.h"

void	dv_pkt_set(struct dv_packet *hdr);
void	putFifo (int len, struct dv_packet pkt);

char    lastframe[6] ={0x55, 0x55, 0x55, 0x55, 0xc8, 0x7a};

void    header_read_from_rig(void)         /* read from rig (DV packet) */
{
	int	ret;

        /***  from RIG  ***/

        ret = usb_control_msg(udev, 0xC0, GET_HEADER, 0, 0, usb.buffer, 32, 200);
        if (ret > 0)
        {
		if (usb_control_msg(udev, 0xC0, GET_HEADER, 
					0, 0, &usb.buffer[32], 9, 200) < 0)
		{
			
			return;
		}
                if (debug)
                {
                	time (&cur_time);
                        fprintf (log_file, "%24.24s from RIG Flags: %2.2x %2.2x %2.2x\n",
                        	ctime(&cur_time), usb.hdr.flags[0], usb.hdr.flags[1], usb.hdr.flags[2]);
                        fprintf (log_file, "%24.24s from RIG RPT2:%8.8s RPT1:%8.8s\n",
                                ctime(&cur_time), usb.hdr.RPT2Call, usb.hdr.RPT1Call);
                        fprintf (log_file, "%24.24s from RIG YourCall:%8.8s MyCall:%8.8s MyCall2:%4.4s\n",
                                ctime(&cur_time), usb.hdr.YourCall, usb.hdr.MyCall, usb.hdr.MyCall2);
                        fflush (log_file);
			node_rig_pkt_cnt = 0;
                }
		if (status & CRC_ERROR)
		{
			time(&cur_time);
			fprintf (log_file, "%24.24s CRC ERROR of RF header\n", ctime(&cur_time));
			fflush (log_file);
			return;
		}

		if (memcmp (usb.hdr.RPT1Call, node_area_rep_callsign, 8)) 
		{
			if (debug)
			{
				time (&cur_time);
				fprintf (log_file, "%24.24s RPT1 Call is not same as repeater call %8.8s:%8.8s\n",
					ctime(&cur_time), usb.hdr.RPT1Call, node_area_rep_callsign);
				fflush (log_file);
			}
			return;
		}
		if (!(usb.hdr.flags[0] & 0x40))
		{
			/* not dup set */
			//gw_resp_sw = TRUE;
			memcpy (node_gw_resp.MyCall, node_area_rep_callsign, 8);
			memcpy (node_gw_resp.YourCall, usb.hdr.MyCall, 8);
			memcpy (node_gw_resp.RPT1Call, node_area_rep_callsign, 8);
			memcpy (node_gw_resp.RPT2Call, node_area_rep_callsign, 8);
			node_gw_resp.flags[0] = 0x01;
			node_gw_resp.flags[1] = 0x00;
			node_gw_resp.flags[2] = 0x00;
			if (debug)
			{
				time (&cur_time);
				fprintf (log_file, "%24.24s dup flag not set.\n", ctime(&cur_time));
				fflush (log_file);
			}
			return;
		}
		else
		{
			if (!memcmp (usb.hdr.MyCall, "        ", 8)
			|| !memcmp (usb.hdr.YourCall, "        ", 8))
			{
				/* My call or your call is blank */
				//gw_resp_sw = TRUE;
				memset (node_gw_resp.RPT2Call, 0x20, 36);
				memcpy (node_gw_resp.MyCall, node_area_rep_callsign, 8);
				node_gw_resp.flags[0] = 0x02;
				node_gw_resp.flags[1] = 0x00;
				node_gw_resp.flags[2] = 0x00;
				if (debug)
				{
					time (&cur_time);
					fprintf (log_file, "%24.24s MyCall or Your Call is blank\n", ctime(&cur_time));
					fflush (log_file);
				}
				return;
			}
		}

		HeaderLength = 41;
		node_voice_send_sw = TRUE;

		memcpy (&node_pkt.dstar.b_bone.dstar_udp.rf_header, usb.buffer, 41);
		node_pkt.dstar.b_bone.dstar_udp.rf_header.flags[0] &= 0xbf;	/* clear repeater flag */

       		memcpy (posit.id, "DSTR", 4);
       		posit.sr = 's';
		posit.c = 0x21;	/* position */
		posit.length[0] = 0x00;
		posit.length[1] = 0x10;
		memcpy (posit.dstar.posit.call1, node_pkt.dstar.b_bone.dstar_udp.rf_header.MyCall, 8);
		memcpy (posit.dstar.posit.call2, node_pkt.dstar.b_bone.dstar_udp.rf_header.RPT1Call, 8);
		putFifo (26, posit);
		header_send_set_from_rig();
	}
	else if (ret < 0)
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s Node Adapter Down\n", ctime(&cur_time));
		fflush (log_file);
		node_close();
	}
}

void	header_send_set_from_rig(void)
{
	unsigned short int	tmp;

	dv_pkt_set(&node_pkt);
	node_pkt.length[0] = 0x00;
	node_pkt.length[1] = 0x30;
	node_pkt.dstar.b_bone.b_b.id = 0x20;	/* voice */
	tmp = rand() & 0xffff;
	memcpy (node_pkt.dstar.b_bone.b_b.frame_id, &tmp, 2);
	node_pkt.dstar.b_bone.b_b.seq = 0x80;

	if (memcmp (usb.hdr.RPT2Call, node_area_rep_callsign, 8))
	{
		putFifo (58, node_pkt);
		node_voice_send_sw = TRUE;
	}
	else
	{
		node_voice_send_sw = FALSE;
	}

	node_NoRespReply_sw = TRUE;
	memcpy (&node_NoResp, usb.buffer, 41);
	seq = 0;
	node_last_frame_sw = TRUE;

	if (monitor_port)
	{
		if (sendto (monitor_sd, &node_pkt, 58, 0,
			monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
		{
			time (&cur_time);
			fprintf (log_file, "%24.24s send error (monitor header) %s\n", ctime(&cur_time), strerror(errno));
			fflush (log_file);
		}
	}
	if (repeater) header_send (usb.hdr);
}

int	voice_read_from_rig()
{
	int	i;
	int	ret;

	int	read_len;

	read_len = 24 - voice_pnt;

	ret = usb_control_msg(udev, 0xC0, GET_DATA, 0, 0, usb.buffer, read_len, 200);
	if (ret > 0)
	{
		usb_read_cnt = 0;
		for (i = 0 ; i < ret; i++)
		{
			voice_save[voice_pnt] = usb.buffer[i];
			voice_pnt++;
			if (voice_pnt == 24)
			{
				voice_pnt = 12;
				memcpy (&node_pkt.dstar.b_bone.dstar_udp.voice_d, voice_save, 12);
				if (repeater) node_voice_send (voice_save);
				memcpy (voice_save, &voice_save[12], 12);
				dv_pkt_set(&node_pkt);
				node_pkt.dstar.b_bone.b_b.seq = seq;
				seq++;
				if (seq >= 21) seq = 0;
				node_pkt.length[0] = 0x00;
				node_pkt.length[1] = 19;  /* 29 - 10 */
				if (node_voice_send_sw ) putFifo (29, node_pkt);
				if (debug) node_rig_pkt_cnt++;
				if (monitor_sd)
				{
					if (sendto (monitor_sd, &node_pkt, 29, 0,
						monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
					{
						time (&cur_time);
						fprintf (log_file, "%24.24s send error (monitor voice) %s\n", ctime(&cur_time), strerror(errno));
						fflush (log_file);
					}
				}
			}
			else if (voice_pnt == 15)
			{
				if (!memcmp (&voice_save[9], lastframe, 6))
				{
					memcpy (&node_pkt.dstar.b_bone.dstar_udp.voice_d, voice_save, 15);
					if (repeater) node_last_send (voice_save);
					dv_pkt_set(&node_pkt);
					node_pkt.dstar.b_bone.b_b.seq = seq | 0x40;
					node_pkt.length[0] = 0x00;
					node_pkt.length[1] = 22;	/* 32 - 10 */
					if (node_voice_send_sw) putFifo (32, node_pkt);
					node_last_frame_sw = FALSE;
					if (monitor_sd)
					{
						sendto (monitor_sd, &node_pkt, 32, 0,
							monitor_out->ai_addr,	monitor_out->ai_addrlen);
					}
					if (debug)
					{
						time(&cur_time);
						fprintf (log_file, "%24.24s from RIG packets:%ld\n", ctime(&cur_time), node_rig_pkt_cnt);
						fflush (log_file);
					}
				}	
			}	
		}
		return ret;
	}
	else if (ret < 0)
	{
		node_close ();
	}
	return 0;
}

void	node_last_frame_send (void)
{
	memcpy (&node_pkt.dstar.b_bone.dstar_udp.voice_d.data_segment, lastframe, 6);
	dv_pkt_set(&node_pkt);
	node_pkt.dstar.b_bone.b_b.seq = seq;
	node_pkt.dstar.b_bone.b_b.seq |= 0x40;
        node_pkt.length[0] = 0x00;
        node_pkt.length[1] = 22;	/* 32 - 10 */
	if (node_voice_send_sw) putFifo (32, node_pkt);
	node_last_frame_sw = FALSE;

	if (monitor_port)
	{
		if (sendto (monitor_sd, &node_pkt, 32, 0,
			monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
		{
			time (&cur_time);
			fprintf (log_file, "%24.24s send error (monitor last) %s\n", ctime(&cur_time), strerror(errno));
			fflush (log_file);
		}
	}
}

