/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.widget;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridHelper;

public class ColumnModelWidget extends ConfigWidget {
	private ColumnModel data;

	private Grid grid;

	public ColumnModelWidget(ColumnModel data, Grid parent) {
		super();
		this.data = data;
		this.grid = parent;
	}

	public Component getParent() {
		return grid;
	}

	public int getColumnCount() {
		return data.getColumnCount();
	}

	public boolean getFiresEvents() {
		return data.getFiresEvents();
	}

	public int getTotalWidth() {
		return data.getTotalWidth();
	}

	public ColumnModel getWrapModel() {
		return data;
	}

	public void setParent(Grid grid) {
		this.grid = grid;
	}

	public List<ColumnConfig> getConfig() {
		return GridHelper.getConfig(data);
	}

	public void setConfig(List<ColumnConfig> config) {
		GridHelper.setConfig(data, config);
	}

	public void add(ColumnConfigWidget widget, int i) {
		getConfig().add(i, widget.getWrapConfig());
	}

	public void remove(ColumnConfigWidget widget) {
		getConfig().remove(widget.getWrapConfig());
	}

	public void setGrid(Grid grid) {
		this.grid = grid;
	}

	public void setColumnModel(ColumnModel data) {
		this.data = data;
	}

	public List<Component> getColumnConfigWidgets() {
		List<Component> l = new ArrayList<Component>();
		Iterator<ColumnConfig> it = GridHelper.getConfig(data).iterator();
		while (it.hasNext()) {
			ColumnConfig columnConfig = (ColumnConfig) it.next();
			l.add(new ColumnConfigWidget(columnConfig, this));
		}
		return l;
	}

}
