/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.comp;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetServiceBase;
import jp.co.kpscorp.gwt.client.design.delegate.Delegate;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.HeaderDelegate;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Header;

public class WsHeader extends WidgetServiceBase {

	private String fieldString = "Header ";

	private String instanceString = " = %1.getHeader();";

	private String tag = "gxHdr";

	public WsHeader(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new HeaderDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public Component getInstance() {
		Header ti = new Header();
		return ti;
	}

	public String getLabel() {
		return "Header";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	@Override
	public List<String>[] makeSource(List<String>[] lists,
			Map<Object, Object> map) {
		Header header = (Header) this.widget;
		// 空のButtonBarは無視
		if (header.getToolCount() > 0) {
			String fn = GxtUtil.getFieldName(lists[0], getFieldString(),
					getTag());
			lists[0].add(getFieldString() + fn + ";");
			lists[1].add(fn
					+ getInstanceString().replace("%1",
							(String) map.get(getParent())));
			Iterator it = getDelegates().iterator();
			while (it.hasNext()) {
				Delegate delegate = (Delegate) it.next();
				delegate.makeSetterCode(widget, lists, getFieldString(),
						getInstanceString(), getTag(), fn, map);
			}
			return GxtUtil.makeAddCode(widget, lists, map, fn);
		}
		return lists;
	}

}
