/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.model;

import java.util.Date;
import java.util.Set;

import jp.co.kpscorp.gwt.client.design.gxt.common.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.common.LabelModel;

import com.extjs.gxt.ui.client.data.BeanModelTag;
import com.google.gwt.user.client.rpc.IsSerializable;

public class Maintenance implements IsSerializable, BeanModelTag, LabelModel {

	private static final String[][] labels = { { "updTime", "UpdateTime" },
			{ "maintenancePk", "保守契約PK" }, { "maintenanceNo", "保守契約No." },
			{ "maintenanceContractDate", "保守契約日" },
			{ "maintenanceCompany", "保守契約会社" }, { "maintenanceType", "保守種類" },
			{ "maintenanceRate", "保守料金" },
			{ "maintenancePeriodStartday", "保守開始日" },
			{ "maintenancePeriodEndday", "保守終了日" } };

	public String label(String prop) {
		return GxtUtil.prop2Label(prop, labels);
	}

	/** identifier field */
	private Integer maintenancePk;

	/** persistent field */
	private String maintenanceNo;

	/** nullable persistent field */
	private Date maintenanceContractDate;

	/** nullable persistent field */
	private String maintenanceCompany;

	/** nullable persistent field */
	private String maintenanceType;

	/** nullable persistent field */
	private Integer maintenanceRate = 0;

	/** persistent field */
	private Date maintenancePeriodStartday;

	/** persistent field */
	private Date maintenancePeriodEndday;

	/** nullable persistent field */
	private Date updTime;

	/** persistent field */
	private Set machines;

	public Maintenance() {
	}

	public Maintenance(Maintenance maintenance) {
		super();
		this.maintenancePk = null;
		this.maintenanceNo = maintenance.getMaintenanceNo();
		this.maintenanceContractDate = maintenance.getMaintenanceContractDate();
		this.maintenanceCompany = maintenance.getMaintenanceCompany();
		this.maintenanceType = maintenance.getMaintenanceType();
		if (maintenance.getMaintenanceRate() == null) {
			this.maintenanceRate = 0;
		} else {
			this.maintenanceRate = maintenance.getMaintenanceRate();
		}
		this.maintenancePeriodStartday = maintenance
				.getMaintenancePeriodStartday();
		this.maintenancePeriodEndday = maintenance.getMaintenancePeriodEndday();
		this.updTime = maintenance.getUpdTime();
		this.machines = maintenance.getMachines();
	}

	public Integer getMaintenancePk() {
		return maintenancePk;
	}

	public void setMaintenancePk(Integer maintenancePk) {
		this.maintenancePk = maintenancePk;
	}

	public String getMaintenanceNo() {
		return maintenanceNo;
	}

	public void setMaintenanceNo(String maintenanceNo) {
		this.maintenanceNo = maintenanceNo;
	}

	public Date getMaintenanceContractDate() {
		return maintenanceContractDate;
	}

	public void setMaintenanceContractDate(Date maintenanceContractDate) {
		this.maintenanceContractDate = maintenanceContractDate;
	}

	public String getMaintenanceCompany() {
		return maintenanceCompany;
	}

	public void setMaintenanceCompany(String maintenanceCompany) {
		this.maintenanceCompany = maintenanceCompany;
	}

	public String getMaintenanceType() {
		return maintenanceType;
	}

	public void setMaintenanceType(String maintenanceType) {
		this.maintenanceType = maintenanceType;
	}

	public Integer getMaintenanceRate() {
		return maintenanceRate;
	}

	public void setMaintenanceRate(Integer maintenanceRate) {
		this.maintenanceRate = maintenanceRate;
	}

	public Date getMaintenancePeriodStartday() {
		return maintenancePeriodStartday;
	}

	public void setMaintenancePeriodStartday(Date maintenancePeriodStartday) {
		this.maintenancePeriodStartday = maintenancePeriodStartday;
	}

	public Date getMaintenancePeriodEndday() {
		return maintenancePeriodEndday;
	}

	public void setMaintenancePeriodEndday(Date maintenancePeriodEndday) {
		this.maintenancePeriodEndday = maintenancePeriodEndday;
	}

	public Date getUpdTime() {
		return updTime;
	}

	public void setUpdTime(Date updTime) {
		this.updTime = updTime;
	}

	public Set getMachines() {
		return machines;
	}

	public void setMachines(Set machines) {
		this.machines = machines;
	}

	public String getLabel() {
		return null;
	}

	public String getValue() {
		return null;
	}

	public int compareTo(Object o) {
		return 0;
	}

}
