/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FlowLayoutWidget;

import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.layout.FlowData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;

public class FlowLayoutDelegate extends LayoutDelegate {

	private FlowLayoutWidget comp;

	protected String[] props = { "margins", "removePositioning" };

	public FlowLayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (FlowLayoutWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getMargins".equals(mthodName)) {
			return comp.getMargins();
		} else if ("getRemovePositioning".equals(mthodName)) {
			return comp.getRemovePositioning();
		} else if ("setMargins".equals(mthodName)
				&& parms[0] instanceof Margins) {
			comp.setMargins((Margins) parms[0]);
			return comp;
		} else if ("setMargins".equals(mthodName) && parms[0] instanceof String) {
			comp.setMargins(GxtUtil.makeMargins((String) parms[0]));
			return comp;
		} else if ("setRemovePositioning".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setRemovePositioning((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public LayoutData getValidLayoutData() {
		return new FlowData(0);

	}

}
