/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.AccordionLayoutWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Container;

public class AccordionLayoutDelegate extends FitLayoutDelegate {

	private AccordionLayoutWidget comp;

	protected String[] props = { "activeOnTop", "titleCollapse", "fill",
			"autoWidth", "hideCollapseTool" };

	public AccordionLayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (AccordionLayoutWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getActiveOnTop".equals(mthodName)) {
			return comp.getActiveOnTop();
		} else if ("getAutoWidth".equals(mthodName)) {
			return comp.getAutoWidth();
		} else if ("getExtraStyle".equals(mthodName)) {
			return comp.getExtraStyle();
		} else if ("getFill".equals(mthodName)) {
			return comp.getFill();
		} else if ("getFiresEvents".equals(mthodName)) {
			return comp.getFiresEvents();
		} else if ("getHideCollapseTool".equals(mthodName)) {
			return comp.getHideCollapseTool();
		} else if ("getResizeDelay".equals(mthodName)) {
			return comp.getResizeDelay();
		} else if ("getTitleCollapse".equals(mthodName)) {
			return comp.getTitleCollapse();
		} else if ("isRenderHidden".equals(mthodName)) {
			return comp.isRenderHidden();
		} else if ("setActiveItem".equals(mthodName)
				&& parms[0] instanceof Component) {
			comp.setActiveItem((Component) parms[0]);
			return comp;
		} else if ("setActiveOnTop".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setActiveOnTop((Boolean) parms[0]);
			return comp;
		} else if ("setAutoWidth".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAutoWidth((Boolean) parms[0]);
			return comp;
		} else if ("setContainer".equals(mthodName)
				&& parms[0] instanceof Container) {
			comp.setContainer((Container) parms[0]);
			return comp;
		} else if ("setExtraStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setExtraStyle((String) parms[0]);
			return comp;
		} else if ("setFill".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setFill((Boolean) parms[0]);
			return comp;
		} else if ("setFiresEvents".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setFiresEvents((Boolean) parms[0]);
			return comp;
		} else if ("setHideCollapseTool".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setHideCollapseTool((Boolean) parms[0]);
			return comp;
		} else if ("setRenderHidden".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setRenderHidden((Boolean) parms[0]);
			return comp;
		} else if ("setResizeDelay".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setResizeDelay(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setTitleCollapse".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setTitleCollapse((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

}
