/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.layout.AbsoluteData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;

public class AbsoluteLayoutDelegate extends AnchorLayoutDelegate {

	protected String[] props = {};

	public AbsoluteLayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public LayoutData getValidLayoutData() {
		return new AbsoluteData();
	}

	@Override
	public void resetLayoutWhenAdd(Component addComp) {
		LayoutData data = ComponentHelper.getLayoutData(addComp);
		if (!(data instanceof AbsoluteData)) {
			ComponentHelper.setLayoutData(addComp, null);
		}
	}

}
