/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.TriggerField;

public class TriggerFieldDelegate extends TextFieldDelegate {

	private TriggerField comp;

	protected String[] props = { "hideTrigger", "triggerStyle" };

	protected String[] innerProps = { "hideTrigger", "triggerStyle" };

	public TriggerFieldDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TriggerField) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("isHideTrigger".equals(mthodName)) {
			return comp.isHideTrigger();
		} else if ("setHideTrigger".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setHideTrigger((Boolean) parms[0]);
			return comp;
		} else if ("getTriggerStyle".equals(mthodName)) {
			return comp.getTriggerStyle();
		} else if ("setTriggerStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTriggerStyle((String) parms[0]);
			return comp;
		} else if ("getElement".equals(mthodName)) {
			return comp.getElement();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public Component setInitStyle(Component widget) {
		TriggerField tf = (TriggerField) super.setInitStyle(widget);
		tf.setBorders(false);
		return tf;
	}

}
