/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.Validator;

public class TextFieldDelegate extends FieldDelegate {

	private TextField<Object> comp;

	// "cursorPos",はelが無いとnullpo
	protected String[] props = { "allowBlank", "maxLength", "minLength",
			"password", "regex", "selectOnFocus" };

	protected String[] innerProps = { "password", "validator", "maxLength",
			"selectOnFocus", "allowBlank", "minLength", "regex" };

	public TextFieldDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TextField<Object>) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("setValue".equals(mthodName) && parms[0] instanceof Object) {
			comp.setValue(parms[0]);
			return comp;
		} else if ("getAllowBlank".equals(mthodName)) {
			return comp.getAllowBlank();
		} else if ("getCursorPos".equals(mthodName)) {
			return comp.getCursorPos();
		} else if ("getMaxLength".equals(mthodName)) {
			return comp.getMaxLength();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMinLength".equals(mthodName)) {
			return comp.getMinLength();
		} else if ("getRegex".equals(mthodName)) {
			return comp.getRegex();
		} else if ("getSelectedText".equals(mthodName)) {
			return comp.getSelectedText();
		} else if ("getSelectionLength".equals(mthodName)) {
			return comp.getSelectionLength();
		} else if ("getSelectOnFocus".equals(mthodName)) {
			return comp.getSelectOnFocus();
		} else if ("getValidator".equals(mthodName)) {
			return comp.getValidator();
		} else if ("isPassword".equals(mthodName)) {
			return comp.isPassword();
		} else if ("setAllowBlank".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAllowBlank((Boolean) parms[0]);
			return comp;
		} else if ("setCursorPos".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setCursorPos(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setMaxLength".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMaxLength(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setMinLength".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMinLength(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setPassword".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setPassword((Boolean) parms[0]);
			return comp;
		} else if ("setRegex".equals(mthodName) && parms[0] instanceof String) {
			comp.setRegex((String) parms[0]);
			return comp;
		} else if ("setSelectOnFocus".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setSelectOnFocus((Boolean) parms[0]);
			return comp;
		} else if ("setValidator".equals(mthodName)
				&& parms[0] instanceof Validator) {
			comp.setValidator((Validator) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public boolean isClickResize() {
		// com.google.gwt.core.client.JavaScriptException: (Error):
		// 予期しないメソッドの呼び出し がでるため 回避
		return false;
	}

	@Override
	public Component setInitStyle(Component widget) {
		TextField tf = (TextField) widget;
		tf.setBorders(true);
		return super.setInitStyle(tf);
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-TF";
	}


}
