/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.google.gwt.http.client.RequestBuilder;


public class TabItemDelegate extends LayoutContainerDelegate  {

	private TabItem comp;

	protected String[] props = { "iconStyle", "text", "closable", "textStyle" };

	protected String[] innerProps = { "iconStyle", "text", "closable",
			"textStyle" };

	public TabItemDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TabItem) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getHeader".equals(mthodName)) {
			return comp.getHeader();
		} else if ("getIconStyle".equals(mthodName)) {
			return comp.getIconStyle();
		} else if ("getTabPanel".equals(mthodName)) {
			return comp.getTabPanel();
		} else if ("getTextStyle".equals(mthodName)) {
			return comp.getTextStyle();
		} else if ("setAutoLoad".equals(mthodName)
				&& parms[0] instanceof RequestBuilder) {
			comp.setAutoLoad((RequestBuilder) parms[0]);
			return comp;
		} else if ("setIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setIconStyle((String) parms[0]);
			return comp;
		} else if ("setTextStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTextStyle((String) parms[0]);
			return comp;
		} else if ("setUrl".equals(mthodName) && parms[0] instanceof String) {
			comp.setUrl((String) parms[0]);
			return comp;
		} else if ("getText".equals(mthodName)) {
			return comp.getText();
		} else if ("setText".equals(mthodName) && parms[0] instanceof String) {
			comp.setText((String) parms[0]);
			return comp;
		} else if ("isClosable".equals(mthodName)) {
			return comp.isClosable();
		} else if ("setClosable".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setClosable((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public Component setInitStyle(Component widget) {
		WidgetService ws = WidgetServiceFactory.getService(widget);
		String tag = GxtUtil.getNewTag(ws.getTag());
		widget.setTitle(tag);
		TabItem ti = (TabItem) widget;
		ti.setText(tag);
		ti.addStyleName("pad-text");
		return ti;
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		if (parent instanceof TabPanel) {
			return true;
		}
		return false;
	}


}
