/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.List;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Style.Orientation;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormHelper;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.extjs.gxt.ui.client.widget.form.Validator;

public class MultiFieldDelegate extends FieldDelegate {

	private MultiField comp;

	protected String[] props = { "orientation", "validator", "spacing" };

	protected String[] innerProps = { "orientation", "validator", "spacing" };

	protected String[] wprops;

	protected String[] winnerProps;

	public MultiFieldDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (MultiField) widget;
	}

	/**
	 * valueを除外
	 */
	private final String[] remove = { "value" };

	@Override
	public String[] getProps() {
		if (wprops == null) {
			wprops = GxtUtil.addAndRemove(super.getProps(), props, remove);
		}
		return wprops;
	}

	@Override
	public String[] getInnerProps() {
		if (winnerProps == null) {
			winnerProps = GxtUtil.addAndRemove(super.getInnerProps(),
					innerProps, remove);
		}
		return winnerProps;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getAll".equals(mthodName)) {
			return comp.getAll();
		} else if ("getSpacing".equals(mthodName)) {
			return comp.getSpacing();
		} else if ("getValidator".equals(mthodName)) {
			return comp.getValidator();
		} else if ("setSpacing".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setSpacing(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setValidator".equals(mthodName)
				&& parms[0] instanceof Validator) {
			comp.setValidator((Validator) parms[0]);
			return comp;
		} else if ("setReadOnly".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setReadOnly((Boolean) parms[0]);
			return comp;
		} else if ("getOrientation".equals(mthodName)) {
			return comp.getOrientation();
		} else if ("isValid".equals(mthodName)) {
			return comp.isValid();
		} else if ("setOrientation".equals(mthodName)
				&& parms[0] instanceof Orientation) {
			comp.setOrientation((Orientation) parms[0]);
			return comp;
		} else if ("add".equals(mthodName) && parms.length == 1
				&& parms[0] instanceof Field) {
			comp.add((Field) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof Field) {
			Field field = (Field) widget;
			if (!comp.isRendered()) {
				comp.add(field);
			} else {
				comp = (MultiField) GxtUtil.addAfterRender(comp, widget);
			}
			widget.setData("parent", comp);
		}
	}

	@Override
	public List<Component> getChildren() {
		List l = super.getChildren();
		l.addAll(comp.getAll());
		return l;
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget instanceof Field) {
			Field field = (Field) widget;
			FormHelper.removeField(comp, field);
			if (comp.isRendered()) {
				Component mf = service.getClone();
				GxtUtil.resetToParent2(comp, (Component) comp.getParent(), mf);
				comp = (MultiField) mf;
			}
		}
		widget.setData("parent", null);
		return comp;
	}

	@Override
	public boolean isAddable() {
		return true;
	}

}
