/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.List;
import java.util.Map;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;

public class MenuItemDelegate extends ItemDelegate {
	private MenuItem comp;

	// subMenu 不要
	protected String[] props = { "text", "iconStyle" };

	protected String[] innerProps = { "text", "iconStyle" };

	public MenuItemDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (MenuItem) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("setText".equals(mthodName) && parms[0] instanceof String) {
			comp.setText((String) parms[0]);
			return comp;
		} else if ("getIconStyle".equals(mthodName)) {
			return comp.getIconStyle();
		} else if ("getSubMenu".equals(mthodName)) {
			return comp.getSubMenu();
		} else if ("getText".equals(mthodName)) {
			return comp.getText();
		} else if ("setIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setIconStyle((String) parms[0]);
			return comp;
		} else if ("setSubMenu".equals(mthodName) && parms[0] instanceof Menu) {
			comp.setSubMenu((Menu) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof Menu) {
			Menu menu = (Menu) widget;
			comp.setSubMenu(menu);
		}
		super.addWidget(widget);
	}

	@Override
	public boolean isAddable() {
		return true;
	}

	@Override
	public String getAddCode(Component widget, List[] lists,
			String parentFiledName, String fieldName, Map map) {
		if (widget instanceof Menu) {
			return parentFiledName + ".setSubMenu(" + fieldName + ");";
		}
		return null;
	}

	@Override
	public Component setInitStyle(Component widget) {
		MenuItem mi = (MenuItem) widget;
		mi.setText(GxtUtil.getNewTag(service.getTag()));
		return mi;
	}

	@Override
	public Component getParent() {
		Menu menu = comp.getParentMenu();
		if (menu != null) {
			return menu;
		}
		return super.getParent();
	}

	@Override
	public List<Component> getChildren() {
		List l = super.getChildren();
		if (comp.getSubMenu() != null) {
			l.add(comp.getSubMenu());
		}
		return l;
	}

}
