/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.Date;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.DateField;

public class DateFieldDelegate extends TriggerFieldDelegate {

	private DateField comp;

	protected String[] props = { "minValue", "format", "formatValue",
			"maxValue" };

	protected String[] innerProps = { "minValue", "formatValue", "maxValue" };

	public DateFieldDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (DateField) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getDatePicker".equals(mthodName)) {
			return comp.getDatePicker();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getPropertyEditor".equals(mthodName)) {
			return comp.getPropertyEditor();
		} else if ("getFormat".equals(mthodName)) {
			return comp.getPropertyEditor().getFormat().getPattern();
		} else if ("isFormatValue".equals(mthodName)) {
			return comp.isFormatValue();
		} else if ("setFormatValue".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setFormatValue((Boolean) parms[0]);
			return comp;
		} else if ("setMaxValue".equals(mthodName) && parms[0] instanceof Date) {
			comp.setMaxValue((Date) parms[0]);
			return comp;
		} else if ("setMinValue".equals(mthodName) && parms[0] instanceof Date) {
			comp.setMinValue((Date) parms[0]);
			return comp;
		} else if ("setRawValue".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setRawValue((String) parms[0]);
			return comp;
		} else if ("setFormat".equals(mthodName) && parms[0] instanceof String) {
			comp.getPropertyEditor().setFormat(
					GxtUtil.makeDateTimeFormat((String) parms[0]));
			return comp;
		} else if ("getMaxValue".equals(mthodName)) {
			return comp.getMaxValue();
		} else if ("getMinValue".equals(mthodName)) {
			return comp.getMinValue();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	protected String makeSetterPart(String prop, String parm) {
		if ("format".equals(prop)) {
			return "getPropertyEditor().setFormat(DateTimeFormat.getFormat("
					+ parm + ");";
		}
		return super.makeSetterPart(prop, parm);
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-DF";
	}


}
