/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.core.XTemplate;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.ModelStringProvider;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ListView;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.PropertyEditor;
import com.extjs.gxt.ui.client.widget.form.ComboBox.TriggerAction;

public class ComboBoxDelegate extends TriggerFieldDelegate {

	private ComboBox comp;

	// store modelStringProvider propertyEditor template selection不要
	protected String[] props = { "allQuery", "loadingText", "forceSelection",
			"itemSelector", "displayField", "value", "triggerAction",
			"minChars", "queryDelay", "typeAheadDelay", "pageSize",
			"minListWidth", "expanded", "listStyle", "lazyRender",
			"selectedStyle", "maxHeight", "typeAhead", "listAlign" };

	protected String[] innerProps = { "allQuery", "modelStringProvider",
			"loadingText", "forceSelection", "itemSelector", "displayField",
			"value", "triggerAction", "minChars", "queryDelay",
			"typeAheadDelay", "pageSize", "minListWidth", "expanded",
			"listStyle", "selection", "lazyRender", "selectedStyle",
			"maxHeight", "typeAhead", "listAlign" };

	public ComboBoxDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (ComboBox) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@SuppressWarnings( { "deprecation" })
	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getAllQuery".equals(mthodName)) {
			return comp.getAllQuery();
		} else if ("getDisplayField".equals(mthodName)) {
			return comp.getDisplayField();
		} else if ("getForceSelection".equals(mthodName)) {
			return comp.getForceSelection();
		} else if ("getItemSelector".equals(mthodName)) {
			return comp.getItemSelector();
		} else if ("getListAlign".equals(mthodName)) {
			return comp.getListAlign();
		} else if ("getListStyle".equals(mthodName)) {
			return comp.getListStyle();
		} else if ("getListView".equals(mthodName)) {
			return comp.getListView();
		} else if ("getLoadingText".equals(mthodName)) {
			return comp.getLoadingText();
		} else if ("getMaxHeight".equals(mthodName)) {
			return comp.getMaxHeight();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMinChars".equals(mthodName)) {
			return comp.getMinChars();
		} else if ("getMinListWidth".equals(mthodName)) {
			return comp.getMinListWidth();
		} else if ("getModelStringProvider".equals(mthodName)) {
			return comp.getModelStringProvider();
		} else if ("getPageSize".equals(mthodName)) {
			return comp.getPageSize();
		} else if ("getPropertyEditor".equals(mthodName)) {
			return comp.getPropertyEditor();
		} else if ("getPropertyEditor".equals(mthodName)) {
			return comp.getPropertyEditor();
		} else if ("getQueryDelay".equals(mthodName)) {
			return comp.getQueryDelay();
		} else if ("getSelectedStyle".equals(mthodName)) {
			return comp.getSelectedStyle();
		} else if ("getStore".equals(mthodName)) {
			return comp.getStore();
		} else if ("getTemplate".equals(mthodName)) {
			return comp.getTemplate();
		} else if ("getTriggerAction".equals(mthodName)) {
			return comp.getTriggerAction();
		} else if ("getTypeAheadDelay".equals(mthodName)) {
			return comp.getTypeAheadDelay();
		} else if ("isLazyRender".equals(mthodName)) {
			return comp.isLazyRender();
		} else if ("isTypeAhead".equals(mthodName)) {
			return comp.isTypeAhead();
		} else if ("setAllQuery".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setAllQuery((String) parms[0]);
			return comp;
		} else if ("setDisplayField".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setDisplayField((String) parms[0]);
			return comp;
		} else if ("setExpanded".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setExpanded((Boolean) parms[0]);
			return comp;
		} else if ("setForceSelection".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setForceSelection((Boolean) parms[0]);
			return comp;
		} else if ("setItemSelector".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setItemSelector((String) parms[0]);
			return comp;
		} else if ("setLazyRender".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setLazyRender((Boolean) parms[0]);
			return comp;
		} else if ("setListAlign".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setListAlign((String) parms[0]);
			return comp;
		} else if ("setListStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setListStyle((String) parms[0]);
			return comp;
		} else if ("setLoadingText".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setLoadingText((String) parms[0]);
			return comp;
		} else if ("setMaxHeight".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMaxHeight(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setMinChars".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMinChars(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setMinListWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMinListWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setModelStringProvider".equals(mthodName)
				&& parms[0] instanceof ModelStringProvider) {
			comp.setModelStringProvider((ModelStringProvider) parms[0]);
			return comp;
		} else if ("setPageSize".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setPageSize(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setPropertyEditor".equals(mthodName)
				&& parms[0] instanceof PropertyEditor) {
			comp.setPropertyEditor((PropertyEditor) parms[0]);
			return comp;
		} else if ("setQueryDelay".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setQueryDelay(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setRawValue".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setRawValue((String) parms[0]);
			return comp;
		} else if ("setSelectedStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setSelectedStyle((String) parms[0]);
			return comp;
		} else if ("setSelection".equals(mthodName) && parms[0] instanceof List) {
			comp.setSelection((List) parms[0]);
			return comp;
		} else if ("setSimpleTemplate".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setSimpleTemplate((String) parms[0]);
			return comp;
		} else if ("setStore".equals(mthodName)
				&& parms[0] instanceof ListStore) {
			comp.setStore((ListStore) parms[0]);
			return comp;
		} else if ("setTemplate".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTemplate((String) parms[0]);
			return comp;
		} else if ("setTemplate".equals(mthodName)
				&& parms[0] instanceof XTemplate) {
			comp.setTemplate((XTemplate) parms[0]);
			return comp;
		} else if ("setTriggerAction".equals(mthodName)
				&& parms[0] instanceof TriggerAction) {
			comp.setTriggerAction((TriggerAction) parms[0]);
			return comp;
		} else if ("setTypeAhead".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setTypeAhead((Boolean) parms[0]);
			return comp;
		} else if ("setTypeAheadDelay".equals(mthodName)
				&& (parms[0] instanceof Integer || parms[0] instanceof String)) {
			comp.setTypeAheadDelay(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("getValue".equals(mthodName)) {
			return comp.getValue();
		} else if ("getValue".equals(mthodName)) {
			return comp.getValue();
		} else if ("setValue".equals(mthodName) && parms[0] instanceof Object) {
			comp.setValue((Object) parms[0]);
			return comp;
		} else if ("setValue".equals(mthodName)
				&& parms[0] instanceof ModelData) {
			comp.setValue((ModelData) parms[0]);
			return comp;
		} else if ("setEditable".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setEditable((Boolean) parms[0]);
			return comp;
		} else if ("getSelection".equals(mthodName)) {
			return comp.getSelection();
		} else if ("setView".equals(mthodName) && parms[0] instanceof ListView) {
			comp.setView((ListView) parms[0]);
			return comp;
		} else if ("isExpanded".equals(mthodName)) {
			return comp.isExpanded();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-Cb";
	}

}
