/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.ArrayList;
import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.MultiField;

public class CheckBoxDelegate extends FieldDelegate {

	private CheckBox comp;

	protected String[] props = { "boxLabel" };

	protected String[] innerProps = { "rowValue", "boxLabel" };

	public CheckBoxDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (CheckBox) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getBoxLabel".equals(mthodName)) {
			return comp.getBoxLabel();
		} else if ("getRawValue".equals(mthodName)) {
			if (!comp.isRendered()) {
				return null;
			}
			return comp.getRawValue();
		} else if ("setBoxLabel".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setBoxLabel((String) parms[0]);
			return comp;
		} else if ("setRawValue".equals(mthodName)) {
			if (!comp.isRendered()) {
				return null;
			}
			comp.setRawValue((String) parms[0]);
			return comp;
		}/*
			 * else if ("setValue".equals(mthodName) && parms[0] instanceof
			 * Object) { comp.setValue((Object) parms[0]); return comp; }
			 */else if ("setValue".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setValue((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public List<Component> getChildren() {
		// Groupが親の場合はLayoutDataは無意味
		if (comp.getParent() == null
				|| (comp.getParent() instanceof HorizontalPanel && comp
						.getParent().getParent() == null)
				|| WidgetServiceFactory.getService(comp).getParent() instanceof MultiField) {
			List<Component> l = new ArrayList<Component>();
			return l;
		}
		return super.getChildren();
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		return super.isAddableToParent(parent)
				|| parent instanceof CheckBoxGroup;
	}

	@Override
	public Component setInitStyle(Component widget) {
		CheckBox f = (CheckBox) widget;
		String lb = GxtUtil.getNewTag(service.getTag());
		f.setFieldLabel(lb);
		f.setBoxLabel(lb);
		f.setAutoWidth(true);
		return f;
	}

	@Override
	public Component getParent() {
		Component parent = comp.getData("parent");
		if (parent == null) {
			parent = GxtUtil.findParent(comp);
			comp.setData("parent", parent);
		}
		return parent;
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-Ck";
	}


}
