/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;


import java.util.ArrayList;
import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.menu.Menu;

public class ButtonDelegate extends ComponentDelegate {

	private Button comp;

	protected String[] props = { "iconStyle", "menuAlign", "minWidth",
			"mouseEvents", "tabIndex", "text", "type" };

	protected String[] innerProps = { "text", "type", "iconStyle",
			"mouseEvents", "menuAlign", "minWidth", "menu" };

	public ButtonDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (Button) widget;
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getType".equals(mthodName)) {
			return comp.getType();
		} else if ("getIconStyle".equals(mthodName)) {
			return comp.getIconStyle();
		} else if ("getMenu".equals(mthodName)) {
			return comp.getMenu();
		} else if ("getMenuAlign".equals(mthodName)) {
			return comp.getMenuAlign();
		} else if ("getMinWidth".equals(mthodName)) {
			return comp.getMinWidth();
		} else if ("getMouseEvents".equals(mthodName)) {
			return comp.getMouseEvents();
		} else if ("getText".equals(mthodName)) {
			return comp.getText();
		} else if ("setIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setIconStyle((String) parms[0]);
			return comp;
		} else if ("setMenu".equals(mthodName) && parms[0] instanceof Menu) {
			comp.setMenu((Menu) parms[0]);
			return comp;
		} else if ("setMenuAlign".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setMenuAlign((String) parms[0]);
			return comp;
		} else if ("setMinWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMinWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setMouseEvents".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setMouseEvents((Boolean) parms[0]);
			return comp;
		} else if ("setTabIndex".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setTabIndex(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setText".equals(mthodName) && parms[0] instanceof String) {
			comp.setText((String) parms[0]);
			return comp;
		} else if ("setType".equals(mthodName) && parms[0] instanceof String) {
			comp.setType((String) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	

	@Override
	public List<Component> getChildren() {
		if(comp.getParent() instanceof ButtonBar){
			//ButtonBarに付いている場合のLayoutDataは不要
			return new ArrayList<Component>();
		}
		return super.getChildren();
	}

	@Override
	public Component setInitStyle(Component widget) {
		Button bt = (Button) widget;
		bt.setText(GxtUtil.getNewTag(service.getTag()));
		return bt;
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		if (parent instanceof ButtonBar) {
			return true;
		}
		return super.isAddableToParent(parent);
	}
	
	@Override
	public String getIconStyle() {
		return "icon-menu-Btn";
	}


}
