/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.widget.WrapWidget;

import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;

public class BorderLayoutContainerDelegate extends
		AnchorLayoutContainerDelegate {
	private LayoutContainer comp;

	private List<LayoutRegion> regionList;

	public BorderLayoutContainerDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (LayoutContainer) widget;
		if (comp != null) {
			regionList = getRegionList();
		}
	}

	@Override
	public Component setInitStyle(Component widget) {
		LayoutContainer lc = (LayoutContainer) widget;
		lc.setLayout(new BorderLayout());
		lc.setBorders(true);
		lc.setHeight(400);
		lc.setWidth(700);

		return lc;
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof WrapWidget) {
			super.addWidget(widget);
			return;
		}
		LayoutRegion lr = findFreeRegion();
		if (!(ComponentHelper.getLayoutData(widget) instanceof BorderLayoutData)) {
			ComponentHelper.setLayoutData(widget, new BorderLayoutData(lr));
		} else {
			BorderLayoutData bd = (BorderLayoutData) ComponentHelper
					.getLayoutData(widget);
			if (regionList.contains(bd)) {
				bd.setRegion(lr);
			}
		}
		this.comp.add(widget);
		regionList = getRegionList();
	}

	@Override
	public Component removeWidget(Component widget) {
		Component res = super.removeWidget(widget);
		regionList = getRegionList();
		return res;
	}

	private LayoutRegion findFreeRegion() {
		List<LayoutRegion> l = regionList;
		if (!l.contains(LayoutRegion.CENTER)) {
			return LayoutRegion.CENTER;
		} else if (!l.contains(LayoutRegion.NORTH)) {
			return LayoutRegion.NORTH;
		} else if (!l.contains(LayoutRegion.WEST)) {
			return LayoutRegion.WEST;
		} else if (!l.contains(LayoutRegion.SOUTH)) {
			return LayoutRegion.SOUTH;
		} else if (!l.contains(LayoutRegion.EAST)) {
			return LayoutRegion.EAST;
		}
		return null;
	}

	private List<LayoutRegion> getRegionList() {
		List<LayoutRegion> l = new ArrayList<LayoutRegion>();
		Iterator it = comp.iterator();
		while (it.hasNext()) {
			Component el = (Component) it.next();
			BorderLayoutData bd = (BorderLayoutData) ComponentHelper
					.getLayoutData(el);
			l.add(bd.getRegion());
		}
		return l;
	}

	@Override
	public boolean isAddable() {
		return findFreeRegion() != null;
	}

}
