/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.FormHelper;

public class AdapterFieldDelegate extends FieldDelegate {

	private AdapterField comp;

	protected String[] props = { "resizeWidget" };

	protected String[] innerProps = { "resizeWidget" };

	protected String[] wprops;

	protected String[] winnerProps;

	public AdapterFieldDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (AdapterField) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("isValid".equals(mthodName)) {
			return comp.isValid();
		} else if ("getWidget".equals(mthodName)) {
			return comp.getWidget();
		} else if ("isResizeWidget".equals(mthodName)) {
			return comp.isResizeWidget();
		} else if ("setResizeWidget".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setResizeWidget((Boolean) parms[0]);
		}
		return super.exec(mthodName, parms);
	}

	/**
	 * valueを除外（nullpo対策)
	 */
	private final String[] remove = { "value" };

	@Override
	public String[] getProps() {
		if (wprops == null) {
			wprops = GxtUtil.addAndRemove(super.getProps(), props, remove);
		}
		return wprops;
	}

	@Override
	public String[] getInnerProps() {
		if (winnerProps == null) {
			winnerProps = GxtUtil.addAndRemove(super.getInnerProps(),
					innerProps, remove);
		}
		return winnerProps;
	}

	@Override
	public void addWidget(Component widget) {
		if (comp.isRendered()) {
			GxtUtil.addAfterRender(comp, widget);
		} else {
			FormHelper.setWidget(comp, widget);
		}
	}

	@Override
	public List<Component> getChildren() {
		List<Component> l = new ArrayList<Component>();
		// LayoutDataを含めない(super)
		if (comp.getWidget() != null) {
			l.add((Component) comp.getWidget());
		}
		return l;
	}

	public String getAddCode(Component widget, List<String>[] lists,
			String parentFiledName, String fieldName, Map<Object, Object> map) {
		return GxtUtil.getAddCode4Adapter(lists, parentFiledName, fieldName,
				map, service.getTag());
	}

	@Override
	public boolean isAddable() {
		return true;
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-AF";
	}


}
