/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.layout.AccordionLayout;
import com.extjs.gxt.ui.client.widget.tree.Tree;
import com.extjs.gxt.ui.client.widget.tree.TreeItem;

public class AccordionLayoutPanelDelegate extends LayoutContainerDelegate {

	public AccordionLayoutPanelDelegate(WidgetService service,
			Component widget) {
		super(service, widget);
	}

	@Override
	public Component setInitStyle(Component widget) {
		// AccordionLayout
		ContentPanel panel = new ContentPanel();
		panel.setHeading("AccordionLayout");
		panel.setBodyBorder(false);

		panel.setLayout(new AccordionLayout());
		panel.setIconStyle("icon-accordion");

		ContentPanel cp = new ContentPanel();
		cp.setHeading("Online Users");
		cp.setScrollMode(Scroll.AUTO);
		panel.add(cp);

		Tree tree = new Tree();
		TreeItem family = new TreeItem("Family");
		tree.getRootItem().add(family);
		family.add(newItem("Darrell", "user"));
		family.add(newItem("Maro", "user-girl"));
		family.add(newItem("Lia", "user-kid"));
		family.add(newItem("Alec", "user-kid"));
		family.setExpanded(true);

		TreeItem friends = new TreeItem("Friends");
		tree.getRootItem().add(friends);
		friends.add(newItem("Bob", "user"));
		friends.add(newItem("Mary", "user-girl"));
		friends.add(newItem("Sally", "user-girl"));
		friends.add(newItem("Jack", "user"));
		friends.setExpanded(true);

		cp.add(tree);

		cp = new ContentPanel();
		cp.setBodyStyleName("pad-text");
		cp.setHeading("Settings");
		// cp.addText(TestData.DUMMY_TEXT_SHORT);
		panel.add(cp);

		cp = new ContentPanel();
		cp.setBodyStyleName("pad-text");
		cp.setHeading("Stuff");
		// cp.addText(TestData.DUMMY_TEXT_SHORT);
		panel.add(cp);

		cp = new ContentPanel();
		cp.setBodyStyleName("pad-text");
		cp.setHeading("More Stuff");
		// cp.addText(TestData.DUMMY_TEXT_SHORT);
		panel.add(cp);
		panel.setSize(200, 325);

		return panel;
	}

	private TreeItem newItem(String text, String iconStyle) {
		TreeItem item = new TreeItem(text);
		item.setIconStyle(iconStyle);
		return item;
	}

	@Override
	public boolean isClickResize() {
		return false;
	}
	
	@Override
	public String getCategory() {
		return "Panel/Sample";
	}


}
