/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt;

import java.util.ArrayList;
import java.util.List;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.DataList;
import com.extjs.gxt.ui.client.widget.DataListItem;
import com.extjs.gxt.ui.client.widget.Header;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.button.IconButton;
import com.extjs.gxt.ui.client.widget.button.ToolButton;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DateField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.TimeField;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.AbsoluteLayout;
import com.extjs.gxt.ui.client.widget.layout.AccordionLayout;
import com.extjs.gxt.ui.client.widget.layout.AnchorLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.CardLayout;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.extjs.gxt.ui.client.widget.layout.TableRowLayout;
import com.extjs.gxt.ui.client.widget.menu.AdapterMenuItem;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.menu.SeparatorMenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.AdapterToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.TextToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.extjs.gxt.ui.client.widget.tree.Tree;
import com.extjs.gxt.ui.client.widget.tree.TreeItem;

import jp.co.kpscorp.gwt.client.design.DefaultFactoryImp;
import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceWrapper;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsAbsoluteLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsAccordionLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsAccordionLayoutPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsAdapterField;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsAdapterMenuItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsAdapterToolItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsBorderLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsBorderLayoutPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsButton;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsButtonBar;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsCardLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsCenterLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsCheckBox;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsCheckBoxGroup;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsColumnLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsComboBox;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsContentPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsDataList;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsDataListItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsDateField;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsFillLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsFillToolItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsFitLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsFormLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsFormPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsFlowLayoutFormPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsGrid;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsHeader;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsHorizontalPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsHtml;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsIconButton;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsMenu;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsMenuItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsRadio;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsRadioGroup;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsRowLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsRowLayoutPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsSeparatorMenuItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsSeparatorToolItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTabItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTabPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTableLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTableRowLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsText;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTextArea;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTextField;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTextToolItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTimeField;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsToolBar;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsToolButton;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTree;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTreeItem;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsTreeSample;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsVerticalPanel;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsAnchorLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.comp.WsFlowLayoutContainer;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsAbsoluteData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsAbsoluteLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsAccordionLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsAnchorData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsAnchorLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsArrayList;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsBorderLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsBorderLayoutData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsCardLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsCenterLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsColumnConfig;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsColumnLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsColumnData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsColumnModel;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsFillData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsFillLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsFitData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsFlowData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsFlowLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsFormData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsFormLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsFitLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsMarginData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsRowData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsRowLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsTableData;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsTableLayout;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsTableRowLayout;
import jp.co.kpscorp.gwt.client.design.gxt.widget.AbsoluteDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.AbsoluteLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.AccordionLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.AnchorDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.AnchorLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ArrayListWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.BorderLayoutDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.BorderLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.CardLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.CenterLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnConfigWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnModelWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FillDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FillLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FitDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FitLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FlowDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FlowLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FormDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FormLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.MarginDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.RowDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.RowLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.TableDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.TableLayoutWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.TableRowLayoutWidget;

public class GxtFactoryImp extends DefaultFactoryImp {

	public WidgetService getService(Component widget) {
		if (widget == null) {
			return null;
		}
		WidgetService ws = widget.getData(WidgetService.class.getName());
		if (ws == null) {
			ws = new WidgetServiceWrapper(getServiceSub(widget), widget);
			widget.setData(WidgetService.class.getName(), ws);
		}
		return ws;
	}

	public WidgetService getServiceSub(Component widget) {
		if (widget instanceof FormPanel) {
			return new WsFormPanel(widget);
		} else if (widget instanceof AdapterMenuItem) {
			return new WsAdapterMenuItem(widget);
		} else if (widget instanceof SeparatorMenuItem) {
			return new WsSeparatorMenuItem(widget);
		} else if (widget instanceof AdapterField) {
			return new WsAdapterField(widget);
		} else if (widget instanceof AdapterToolItem) {
			return new WsAdapterToolItem(widget);
		} else if (widget instanceof FillToolItem) {
			return new WsFillToolItem(widget);
		} else if (widget instanceof TextToolItem) {
			return new WsTextToolItem(widget);
		} else if (widget instanceof SeparatorToolItem) {
			return new WsSeparatorToolItem(widget);
		} else if (widget instanceof ToolBar) {
			return new WsToolBar(widget);
		} else if (widget instanceof Header) {
			return new WsHeader(widget);
		} else if (widget instanceof MenuItem) {
			return new WsMenuItem(widget);
		} else if (widget instanceof Menu) {
			return new WsMenu(widget);
		} else if (widget instanceof ContentPanel) {
			return new WsContentPanel(widget);
		} else if (widget instanceof Button) {
			return new WsButton(widget);
		} else if (widget instanceof ButtonBar) {
			return new WsButtonBar(widget);
		} else if (widget instanceof ToolButton) {
			return new WsToolButton(widget);
		} else if (widget instanceof IconButton) {
			return new WsIconButton(widget);
		} else if (widget instanceof TabPanel) {
			return new WsTabPanel(widget);
		} else if (widget instanceof Tree) {
			return new WsTree(widget);
		} else if (widget instanceof DataList) {
			return new WsDataList(widget);
		} else if (widget instanceof HorizontalPanel) {
			return new WsHorizontalPanel(widget);
		} else if (widget instanceof VerticalPanel) {
			return new WsVerticalPanel(widget);
		} else if (widget instanceof TabItem) {
			return new WsTabItem(widget);
		} else if (widget instanceof TreeItem) {
			return new WsTreeItem(widget);
		} else if (widget instanceof DataListItem) {
			return new WsDataListItem(widget);
		} else if (widget instanceof TimeField) {
			return new WsTimeField(widget);
		} else if (widget instanceof ComboBox) {
			return new WsComboBox(widget);
		} else if (widget instanceof DateField) {
			return new WsDateField(widget);
		} else if (widget instanceof TextArea) {
			return new WsTextArea(widget);
		} else if (widget instanceof TextField) {
			return new WsTextField(widget);
		} else if (widget instanceof Grid) {
			return new WsGrid(widget);
		} else if (widget instanceof Text) {
			return new WsText(widget);
		} else if (widget instanceof RadioGroup) {
			return new WsRadioGroup(widget);
		} else if (widget instanceof CheckBoxGroup) {
			return new WsCheckBoxGroup(widget);
		} else if (widget instanceof Radio) {
			return new WsRadio(widget);
		} else if (widget instanceof CheckBox) {
			return new WsCheckBox(widget);
		} else if (widget instanceof Html) {
			return new WsHtml(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof BorderLayout) {
			return new WsBorderLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof CenterLayout) {
			return new WsCenterLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof ColumnLayout) {
			return new WsColumnLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof AbsoluteLayout) {
			return new WsAbsoluteLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof FormLayout) {
			return new WsFormLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof FlowLayout) {
			return new WsFlowLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof AnchorLayout) {
			return new WsAnchorLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof AccordionLayout) {
			return new WsAccordionLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof CardLayout) {
			return new WsCardLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof FillLayout) {
			return new WsFillLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof RowLayout) {
			return new WsRowLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof FitLayout) {
			return new WsFitLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof TableRowLayout) {
			return new WsTableRowLayoutContainer(widget);
		} else if (widget instanceof LayoutContainer
				&& ((LayoutContainer) widget).getLayout() instanceof TableLayout) {
			return new WsTableLayoutContainer(widget);
		} else if (widget instanceof FormLayoutWidget) {
			return new WsFormLayout(widget);
		} else if (widget instanceof AbsoluteLayoutWidget) {
			return new WsAbsoluteLayout(widget);
		} else if (widget instanceof AccordionLayoutWidget) {
			return new WsAccordionLayout(widget);
		} else if (widget instanceof CardLayoutWidget) {
			return new WsCardLayout(widget);
		} else if (widget instanceof FillLayoutWidget) {
			return new WsFillLayout(widget);
		} else if (widget instanceof TableRowLayoutWidget) {
			return new WsTableRowLayout(widget);
		} else if (widget instanceof AnchorLayoutWidget) {
			return new WsAnchorLayout(widget);
		} else if (widget instanceof BorderLayoutWidget) {
			return new WsBorderLayout(widget);
		} else if (widget instanceof CenterLayoutWidget) {
			return new WsCenterLayout(widget);
		} else if (widget instanceof ColumnLayoutWidget) {
			return new WsColumnLayout(widget);
		} else if (widget instanceof FitLayoutWidget) {
			return new WsFitLayout(widget);
		} else if (widget instanceof FlowLayoutWidget) {
			return new WsFlowLayout(widget);
		} else if (widget instanceof RowLayoutWidget) {
			return new WsRowLayout(widget);
		} else if (widget instanceof TableLayoutWidget) {
			return new WsTableLayout(widget);
		} else if (widget instanceof AbsoluteDataWidget) {
			return new WsAbsoluteData(widget);
		} else if (widget instanceof FormDataWidget) {
			return new WsFormData(widget);
		}  else if (widget instanceof AnchorDataWidget) {
			return new WsAnchorData(widget);
		} else if (widget instanceof FillDataWidget) {
			return new WsFillData(widget);
		} else if (widget instanceof FitDataWidget) {
			return new WsFitData(widget);
		} else if (widget instanceof FlowDataWidget) {
			return new WsFlowData(widget);
		} else if (widget instanceof RowDataWidget) {
			return new WsRowData(widget);
		} else if (widget instanceof BorderLayoutDataWidget) {
			return new WsBorderLayoutData(widget);
		} else if (widget instanceof ColumnDataWidget) {
			return new WsColumnData(widget);
		} else if (widget instanceof MarginDataWidget) {
			return new WsMarginData(widget);
		} else if (widget instanceof TableDataWidget) {
			return new WsTableData(widget);
		} else if (widget instanceof ColumnModelWidget) {
			return new WsColumnModel(widget);
		} else if (widget instanceof ColumnConfigWidget) {
			return new WsColumnConfig(widget);
		} else if (widget instanceof ArrayListWidget) {
			return new WsArrayList(widget);
		}
		return null;
	}

	public List<WidgetService> makeServiceList(Component widget) {
		// System.out.println("list");
		List<WidgetService> l = new ArrayList<WidgetService>();
		// LayoutContainer
		l.add(w(new WsAbsoluteLayoutContainer(widget), widget));
		l.add(w(new WsBorderLayoutContainer(widget), widget));
		l.add(w(new WsCardLayoutContainer(widget), widget));
		l.add(w(new WsCenterLayoutContainer(widget), widget));
		l.add(w(new WsColumnLayoutContainer(widget), widget));
		l.add(w(new WsFillLayoutContainer(widget), widget));
		l.add(w(new WsFormLayoutContainer(widget), widget));
		l.add(w(new WsAccordionLayoutContainer(widget), widget));
		l.add(w(new WsRowLayoutContainer(widget), widget));
		l.add(w(new WsFitLayoutContainer(widget), widget));
		l.add(w(new WsTableLayoutContainer(widget), widget));
		l.add(w(new WsTableRowLayoutContainer(widget), widget));
		// Panel
		l.add(w(new WsAccordionLayoutPanel(widget), widget));
		l.add(w(new WsRowLayoutPanel(widget), widget));
		l.add(w(new WsBorderLayoutPanel(widget), widget));
		l.add(w(new WsContentPanel(widget), widget));
		l.add(w(new WsAnchorLayoutContainer(widget), widget));
		l.add(w(new WsFlowLayoutContainer(widget), widget));
		l.add(w(new WsFormPanel(widget), widget));
		l.add(w(new WsFlowLayoutFormPanel(widget), widget));
		l.add(w(new WsGrid(widget), widget));
		l.add(w(new WsHorizontalPanel(widget), widget));
		l.add(w(new WsVerticalPanel(widget), widget));
		l.add(w(new WsTabPanel(widget), widget));
		l.add(w(new WsTree(widget), widget));
		l.add(w(new WsDataList(widget), widget));
		// Button
		l.add(w(new WsButton(widget), widget));
		l.add(w(new WsButtonBar(widget), widget));
		l.add(w(new WsToolButton(widget), widget));
		l.add(w(new WsIconButton(widget), widget));
		// Field
		l.add(w(new WsComboBox(widget), widget));
		l.add(w(new WsDateField(widget), widget));
		l.add(w(new WsTextArea(widget), widget));
		l.add(w(new WsTextField(widget), widget));
		l.add(w(new WsTimeField(widget), widget));
		// Text
		l.add(w(new WsText(widget), widget));
		// CheckBox
		l.add(w(new WsCheckBox(widget), widget));
		l.add(w(new WsCheckBoxGroup(widget), widget));
		// Radio
		l.add(w(new WsRadio(widget), widget));
		l.add(w(new WsRadioGroup(widget), widget));
		// Html
		l.add(w(new WsHtml(widget), widget));
		// etc
		l.add(w(new WsAdapterMenuItem(widget), widget));
		l.add(w(new WsSeparatorMenuItem(widget), widget));
		l.add(w(new WsAdapterField(widget), widget));
		l.add(w(new WsAdapterToolItem(widget), widget));
		l.add(w(new WsFillToolItem(widget), widget));
		l.add(w(new WsSeparatorToolItem(widget), widget));
		l.add(w(new WsTextToolItem(widget), widget));
		l.add(w(new WsToolBar(widget), widget));
		l.add(w(new WsHeader(widget), widget));
		l.add(w(new WsMenu(widget), widget));
		l.add(w(new WsMenuItem(widget), widget));
		l.add(w(new WsAbsoluteLayout(widget), widget));
		l.add(w(new WsAccordionLayout(widget), widget));
		l.add(w(new WsAnchorLayout(widget), widget));
		l.add(w(new WsBorderLayout(widget), widget));
		l.add(w(new WsCardLayout(widget), widget));
		l.add(w(new WsCenterLayout(widget), widget));
		l.add(w(new WsColumnLayout(widget), widget));
		l.add(w(new WsFillLayout(widget), widget));
		l.add(w(new WsFitLayout(widget), widget));
		l.add(w(new WsFlowLayout(widget), widget));
		l.add(w(new WsFormLayout(widget), widget));
		l.add(w(new WsRowLayout(widget), widget));
		l.add(w(new WsTableLayout(widget), widget));
		l.add(w(new WsTableRowLayout(widget), widget));
		l.add(w(new WsAbsoluteData(widget), widget));
		l.add(w(new WsAnchorData(widget), widget));
		l.add(w(new WsBorderLayoutData(widget), widget));
		l.add(w(new WsColumnData(widget), widget));
		l.add(w(new WsFillData(widget), widget));
		l.add(w(new WsFitData(widget), widget));
		l.add(w(new WsFlowData(widget), widget));
		l.add(w(new WsFormData(widget), widget));
		l.add(w(new WsMarginData(widget), widget));
		l.add(w(new WsRowData(widget), widget));
		l.add(w(new WsTableData(widget), widget));
		l.add(w(new WsTabItem(widget), widget));
		l.add(w(new WsTreeItem(widget), widget));
		l.add(w(new WsDataListItem(widget), widget));
		l.add(w(new WsArrayList(widget), widget));
		l.add(w(new WsColumnModel(widget), widget));
		l.add(w(new WsColumnConfig(widget), widget));
		l.add(w(new WsTreeSample(widget), widget));
		// D-Rex
		l.addAll(super.makeServiceList(widget));
		return l;
	}

	private WidgetService w(WidgetService ws, Component widget) {
		return new WidgetServiceWrapper(ws, widget);
	}

}
