/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.extjs.gxt.ui.client.Events;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.WidgetHelper;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;

public class DesignStore extends ListStore<ModelData> implements Listener {
	private int height;

	private ColumnModel cm;

	private Grid grid;

	public DesignStore(ColumnModel cm, int height) {
		super();
		this.height = height;
		this.cm = cm;
		if (height > 0) {
			load();
		}
	}

	@SuppressWarnings("deprecation")
	private void load() {
		int row = height;
		row = row / 20;

		// Object[][] data = new Object[row][cm.getColumnCount()];
		List<ModelData> l = new ArrayList<ModelData>();
		for (int i = 0; i < row; i++) {
			Map<String, Object> map = new HashMap<String, Object>();
			for (int j = 0; j < cm.getColumnCount(); j++) {
				int c = cm.getColumnWidth(j);
				if (c == 0) {
					c = 100;
				}
				c = c / 7;
				StringBuffer sb = new StringBuffer();
				sb.append(i - i / 10 * 10);
				StringBuffer sb2 = new StringBuffer();
				sb2.append(Character.valueOf((char) (i + 64)));
				for (int k = 1; k < c; k++) {
					sb.append(k - k / 10 * 10);
					sb2.append(Character.valueOf((char) (k + 64)));
				}
				ColumnConfig cf = cm.getColumn(j);
				if (cf.getDateTimeFormat() != null) {
					Date date = new Date();
					date.setDate(i);
					map.put(cm.getDataIndex(j), date);
				} else if (cf.getNumberFormat() != null) {
					map.put(cm.getDataIndex(j), new Double(sb.toString()
							.substring(0, sb.toString().length() - 3)));
				} else {
					map.put(cm.getDataIndex(j), sb2.toString());
				}
			}
			BaseModelData data = new BaseModelData(map);
			l.add(data);
		}
		removeAll();
		add(l);
	}

	public void handleEvent(BaseEvent be) {
		this.height = WidgetHelper.getHeight(grid);
		load();
	}

	public void setGrid(Grid grid) {
		this.grid = grid;
		grid.addListener(Events.BeforeRender, this);
	}
}
