#ifndef INCLUDE_DOCMI_SEQUENCE_H
#define INCLUDE_DOCMI_SEQUENCE_H

#include "element.h"

namespace docmi{

typedef std::vector<Element*> Elements;

// V[PXiDICOMvfWj
class Sequence
{
protected:
	Elements m_elements;

private:
	void copy( const Sequence& rhs );

public:

	virtual Sequence* clone() const = 0;
	virtual ~Sequence(){ clear(); }

	// vfToAǂݎp̃|C^Ԃ
	const Element* search( ushort group_id, ushort element_id ) const;

	// vfToA|C^Ԃ
	Element* search( ushort group_id, ushort element_id );

	virtual void clear();

	void modifyElement( const Element& e );

	void deleteElement( ushort group_id, ushort element_id );

	String getString( ushort group_id, ushort element_id ) const;

	const Elements* getElements() const { return &m_elements; }
	Elements* getElements() { return &m_elements; }

	virtual int length() const = 0;
	int size() const { return length(); }
	virtual void setData( const uchar* data, int length ) = 0;

	virtual const uchar* data() const = 0;
	// ^OɊ܂܂f[^̈ꕔԂB
	virtual int getPart( uchar* buf, int start, int request_size ) const = 0;

	int getElementCount();

private:
	Sequence& operator=( const Sequence& rhs );

	// 4oCgVRH
	bool is4ByteLengthVR( const uchar* vr ){
		if( memcmp( vr, "OB", 2 ) == 0 ||
			memcmp( vr, "OW", 2 ) == 0 ||
			memcmp( vr, "SQ", 2 ) == 0 ||
			memcmp( vr, "UN", 2 ) == 0 ){
			return true;
		}

		return false;
	}
	

protected:
	Sequence(){}
	Sequence( const Sequence& rhs ){ copy( rhs ); }
};


} // namespace docmi

#endif

