#include "sequence.h"

using namespace docmi;

void Sequence::copy( const Sequence& rhs )
{
	int size = m_elements.size();
	for( int i=0; i < size; i++ ){
		delete m_elements[i];
	}
	m_elements.clear();

	size = rhs.m_elements.size();
	for( i=0; i < size; i++ ){
		Element* temp = rhs.m_elements[i]->clone();
		m_elements.push_back( temp );
	}
}

/// vfToAǂݎp̃|C^Ԃ
const Element* Sequence::search( ushort group_id, ushort element_id ) const
{

	for( Elements::const_iterator it=m_elements.begin(); it != m_elements.end(); ++it ){
		if( (*it)->groupID() == group_id &&
			(*it)->elementID() == element_id ){
			return *it;
		}
	}

	return NULL;
}

/** vfToA|C^Ԃ
 */
Element* Sequence::search( ushort group_id, ushort element_id ){

	for( Elements::iterator it=m_elements.begin(); it != m_elements.end(); ++it ){
		if( (*it)->groupID() == group_id &&
			(*it)->elementID() == element_id ){
			return *it;
		}
	}

	return NULL;
}

void Sequence::clear()
{
	int size = m_elements.size();
	for( int i=0; i < size; i++ ){
		delete m_elements[i];
	}
	m_elements.clear();
}

void Sequence::modifyElement( const Element& e )
{
	Element* temp = e.clone();
	ushort gid = temp->groupID();
	ushort eid = temp->elementID();

	for( Elements::iterator it=m_elements.begin(); ; ++it ){

		if( it == m_elements.end() ){
			m_elements.insert( it, temp );
			return;
		}

		if( (*it)->groupID() > gid ||
			( (*it)->groupID() == gid && (*it)->elementID() > eid ) ){
			m_elements.insert( it, temp );
			return;
		}

		if( (*it)->groupID() == gid && (*it)->elementID() == eid ){
			delete *it;
			*it = temp;
			return;
		}
	}
}

void Sequence::deleteElement( ushort group_id, ushort element_id ){
	for( Elements::iterator it=m_elements.begin(); it != m_elements.end(); ++it ){
		if( (*it)->groupID() == group_id &&
			(*it)->elementID() == element_id ){
			delete *it;
			m_elements.erase( it );
			return;

		}
	}
}

String Sequence::getString( ushort group_id, ushort element_id ) const
{
	const Element* e = search( group_id, element_id );
	if( e ){ return e->getString();	}
	else   { return ""; }
}

int Sequence::getElementCount()
{
	return m_elements.size();
}