#ifndef INCLUDE_ONDEMAND_DICOMDATA_H
#define INCLUDE_ONDEMAND_DICOMDATA_H

#include "DicomData.h"


namespace docmi{

/** t@CxǂݍDICOMf[^iDICOMf[^+t@Cǂݍ݃NXj
 */
class OnDemandDicomData : public DicomData
{
	FileInputController m_input;
public:
	OnDemandDicomData(){}

protected:
	OnDemandDicomData( const OnDemandDicomData& rhs ): DicomData( rhs ), m_input(rhs.m_input){}

public:

	virtual ~OnDemandDicomData(){
		close();
	}

	virtual void clear()
	{
		DicomData::clear();
	}

	virtual Sequence* clone()
	{
		return new OnDemandDicomData( *this );
	}

	void setPath( const char* path ){
		m_input.setPath( path );
	}

	void open(){
		if( !m_input.open() ){
			throw Exception( "OnDemandDicomData.open(): t@CJ܂" );
		}
	}

	void close(){
		m_input.close();
	}

	FileInputController& getInput(){ return m_input; }
};


} // namespace docmi

#endif
