#ifndef INCLUDE_DOCMI_FILE_READER_H
#define INCLUDE_DOCMI_FILE_READER_H

#include "DicomData.h"
#include "filesize.h"
#include "FileInputController.h"

namespace docmi {

class FileReader  
{
protected:
	class TagValue {
	private:
		ushort group;
		ushort element;
	public:
		TagValue(){ group=0; element=0; }
		void set( ushort g, ushort e ){ group=g; element=e; }
		String to_str(){
			return strprintf( "(%04x,%04x)", group, element );
		}
	};
	enum FILETYPE {
		TYPE_EXPLICIT_LITTLE,
		TYPE_IMPLICIT_LITTLE,
		TYPE_NOPREAMBLE
	};

	FILETYPE m_file_type;
	int m_file_len;
	String m_path;

	InputController* m_input;
	TagValue m_current_element;
	void mythrow( const char* message ){
		throw Exception( strprintf( "%s ( \"%s\" ^O%st߁At@Cʒu %dByte(0x%xByte)t)",
				message, m_path.c_str(), m_current_element.to_str().c_str(), m_input->getOffset(), m_input->getOffset() ) );
	}
public:
	FileReader(){};
	~FileReader(){};

	// 4oCgVRH
	bool is4ByteLengthVR( uchar* vr ){
		if( memcmp( vr, "OB", 2 ) == 0 ||
			memcmp( vr, "OW", 2 ) == 0 ||
			memcmp( vr, "SQ", 2 ) == 0 ||
			memcmp( vr, "UN", 2 ) == 0 ){
			return true;
		}

		return false;
	}

private:

	// V[PXVRH
	bool isVR_SQ( uchar* vr ){
		if( memcmp( vr, "SQ", 2 ) == 0 ){
			return true;
		}

		return false;
	}

private:
	// t@CvAu邩H
	bool checkPreamble()
	{
		uchar tmp[4];
		m_input->seek_set( 128 );
		readFile( tmp, 4 );
		m_input->seek_set( 0 );

		if( memcmp( tmp, "DICM", 4 ) == 0 ){
			m_file_type = TYPE_EXPLICIT_LITTLE;
			return true;
		} else {
			m_file_type = TYPE_NOPREAMBLE;
			return false;
		}
	}

	/** ^Zbg
	 */
	void setMetaInformation( DicomData& data, const Element& meta_element )
	{
		if( meta_element.groupID() != 0x0002 ) return;

		switch( meta_element.elementID() ){
		case 0x0002: data.setMediaStorageSopClassUid( meta_element.getString() ); break;
		case 0x0003: data.setMediaStorageSopInstanceUid( meta_element.getString() ); break;
		case 0x0010: data.setTransferSyntaxUid( meta_element.getString() ); break;
		case 0x0012: data.setImplementationClassUid( meta_element.getString() ); break;
		case 0x0013: data.setImplementationVersionName( meta_element.getString() ); break;
		case 0x0016: data.setSourceApplicationEntityTitle( meta_element.getString() ); break;
		}
	}

public:

	/** DICOMt@CJ
	 *
	 *  throw Exception
	 */
	void open( DicomData& data, const char* path ){
		m_path = path;
		data.clear();

		FileInputController input( path );
		if( !input.open() ){
			throw Exception( strprintf( "FileReader.open(): t@CJ܂ł \"%s\"", path ) );
		}
		m_file_len = GetFileSize( path );

		try{
			m_input = &input;
			doLoad( data );
		} catch( Exception& x ){
			throw x;
		}
	}

protected:
	void doLoad( DicomData& data ){
		// t@CvAu𒲂ׂ
		if( checkPreamble() ){
			// t@CvAuǂݔ΂
			m_input->seek_set( 132 );
		}

		// vfǂݍ
		ConcreteElement e;

		while( readElement( e ) ){
			if( e.groupID() == 0x0002 ){
				setMetaInformation( data, e );
			} else {
				data.modifyElement( e );
			}
		}
	}

	// t@Cw肳ꂽ̃f[^ǂݍ
	void readFile( uchar* buf, uint length ){
		if( m_input->read( buf, length ) < length ){
			mythrow( "FileReader.readFile(): t@C̃f[^ǂݍ݂Ɏs܂" );
		}
	}

private:

	/** JvZf[^ǂݍ
	 *
	 *  E(7fe0,0010)̒-1̂ƂA摜f[^͕(fffe,e000)Ɋi[
	 *
	 *  JvZf[^tH[}bg
	 *  -----------------------------------------------
	 *  e0 7f 01 00 ff ff ff ff 00 e0 fe ff 04 00 00 00
	 *  00 30 00 00 00 e0 fe ff 00 10 00 00 ...
	 *  -----------------------------------------------
	 *  
     *  (7fe0,0010)     -1
	 *  (fffe,e000)      4 0x3000    : ڂ̃f[^̓JvZf[^̐擪ւ̃ItZbg
	 *  (fffe,e000) 0x1000 ...
	 *   .
	 *   .
	 *  (fffe,e0dd)      0           : I[^O
	 *
	 *  throw Exception
	 */
	int readCupsuleData( Element& e )
	{
		ConcreteSequence s;
		int length = 0; // ǂݍ񂾃t@C

		while( 1 ){
			
			uchar tmp[4];
			s.clear();

			readFile( tmp, 4 );
			length += 4;

			// ^Oǂݍ
			ushort group_id   = ((ushort*)tmp)[0];
			ushort element_id = ((ushort*)tmp)[1];

			// I[^OH
			if( group_id == 0xfffe && element_id == 0xe0dd ){
				m_input->seek_cur( 4 );
				length += 4;
				break;
			}

			// f[^^OH
			if( group_id != 0xfffe || element_id != 0xe000 ){
				mythrow( "FileReader.readCupsuleData(): JvZ\Ƀf[^^OȊÕ^O݂܂" );
			}

			// f[^ǂݍ
			int data_length = read4byteLength();
			length += 4;

			// f[^0ȏォH
			if( data_length < 0 ){
				mythrow( "FileReader.readCupsuleData(): JvZ\̃f[^^OɁAÖٓIZbgĂ܂B" );
			}

			// f[^ǂݍ
			setData2Sequence( s, length, data_length );

			e.addSequence( s );
		}

		return length;
	}

	/** t@CAV[PX\̒gǂݍ
	 *  @retval : ǂݍ񂾃f[^TCY
	 *  throw Exception
	 */
	int readSequenceBody( Sequence& s, int sequence_length )
	{
		ConcreteElement e;
		int element_length;
		int length = 0;

		// I
		if( sequence_length > 0 ){
			
			while( sequence_length > 0 ){
				if( !readElement( e, element_length ) ){
					mythrow( "FileReader.readSequenceBody(): IDICOMvf̓ǂݍ݂Ɏs܂" );
				}
				s.modifyElement( e );
				length += element_length;
				sequence_length -= element_length;

				// V[PX𒴂
				if( sequence_length < 0 ){
					mythrow( "FileReader.readSequenceBody(): V[PXsł" );
				}
			}

		// ÖٓI
		} else {
			while( 1 ){
				if( !readElement( e, element_length ) ){
					mythrow( "FileReader.readSequenceBody(): ÖٓIvf̓ǂݍ݂Ɏs܂" );
				}
				length += element_length;

				// V[PXI^OH
				if( e.groupID() == 0xfffe && e.elementID() == 0xe00d ){
					break;
				}

				s.modifyElement( e );
			}
		}

		return length;
	}

	/** t@CAV[PX\ǂݍ(Io[W)
	 *  @retval : ǂݍ񂾃f[^TCY
	 *  throw Exception
	 */
	int readOneSequence( Sequence& s )
	{
		int length = 0; // ǂݍ񂾃t@C
		uchar tmp[4];

		s.clear();

		readFile( tmp, 4 );
		length += 4;

		// ^Oǂݍ
		ushort group_id = ((ushort*)tmp)[0];
		ushort element_id = ((ushort*)tmp)[1];

		// V[PXJn^OH
		if( group_id != 0xfffe || element_id != 0xe000 ){
			mythrow( "FileReader.readOneSequence(): vf̓ǂݍ݂Ɏs܂" );
		}

		// f[^ǂݍ
		int sequence_length = read4byteLength();
		length += 4;

		length += readSequenceBody( s, sequence_length );
		return length;
	}

	/** t@CAV[PX\ǂݍ(ÖٓIo[W)
     *  @retval : ǂݍ񂾃f[^TCY
	 *  throw Exception
	 */
	int readOneSequenceImplicitLength( Sequence& s, bool& b_finish )
	{
		int length = 0; // ǂݍ񂾃t@C
		uchar tmp[4];
		b_finish = false;

		s.clear();

		readFile( tmp, 4 );
		length += 4;

		// ^Oǂݍ
		ushort group_id = ((ushort*)tmp)[0];
		ushort element_id = ((ushort*)tmp)[1];

		// V[PXWI^OH
		if( group_id == 0xfffe && element_id == 0xe0dd ){
			m_input->seek_cur( 4 );
			length += 4;
			b_finish = true;
			return length;
		}

		// V[PXJn^OH
		if( group_id != 0xfffe || element_id != 0xe000 ){
			mythrow( "FileReader.readOneSequenceImplicitLength(): V[PX^ỎɁAV[PXJn^OȊÕ^O܂" );
		}

		// f[^ǂݍ
		int sequence_length = read4byteLength();
		length += 4;

		length += readSequenceBody( s, sequence_length );
		return length;
	}
 
	/** V[PX^O̓eǂݍ
	 *
	 *  @retval : ǂݍ񂾃f[^TCY
	 *  throw Exception
	 */
	int readSequence( Element& sequence_element, int length )
	{
		ConcreteSequence s;

		if( length >= 0 ){
			int rest = length;
			while( rest > 0 ){		
				int sequence_length = readOneSequence( s );
				sequence_element.addSequence( s );
				rest -= sequence_length;
			}
			return length;
		} else {
			int read_length = 0;
			while( 1 ){
				bool b_finish;
				read_length += readOneSequenceImplicitLength( s, b_finish );
				if( b_finish ){
					return read_length;
				}

				sequence_element.addSequence( s );
			}
		}
	}

private:
	/** vfǂ݂
	 * @retval true : 
	 * @retval false : t@C̏I
	 *
	 * throw Exception
	 */
	bool readElement( ConcreteElement& e ){
		int length = 0;
		return readElement( e, length );
	}

	/** 4oCg̃f[^ǂ݂
	 *
	 *  throw Exception
	 */
	int read4byteLength()
	{
		uchar tmp[4];
		readFile( tmp, 4 );
		uint ulength = *((uint*)tmp);
		if( ulength == 0xffffffff ){
			return -1;
		} else {
			return ulength;
		}
	}

	/** 2oCg̃f[^ǂ݂
	 *
	 *  throw Exception
	 */
	int read2byteLength()
	{
		uchar tmp[2];
		readFile( tmp, 2 );
		ushort ulength = *((ushort*)tmp);
		if( ulength == 0xffff ){
			return -1;
		} else {
			return ulength;
		}
	}
		

	/** vfǂݍ
	 * @retval true : 
	 * @retval false : t@C̏I
	 *
	 * thrown Exception
	 */
	bool readElement( ConcreteElement& e, int& read_length ){
		uchar tmp[4];
		bool b_success = true;
		uchar* data = NULL;
		read_length = 0;

		e.clear();

		try{
			readFile( tmp, 4 );
			read_length += 4;
		} catch( Exception& x ){
			// ^OǂݍޑOɃt@CI
			int error = x.code();
			return false;
		}

		e.setGroupID( ((ushort*)tmp)[0] );
		e.setElementID( ((ushort*)tmp)[1] );

		m_current_element.set( e.groupID(), e.elementID() );

		{
			bool b_seaquence;
			int length;

			if( m_file_type == TYPE_EXPLICIT_LITTLE ||
				( m_file_type == TYPE_IMPLICIT_LITTLE && e.groupID() == 0x0002 ) ){ // IVRvf

				// VRif[^jǂݍ
				uchar vr[2];
				readFile( vr, 2 );
				read_length += 2;

				if( is4ByteLengthVR( vr ) ){
					m_input->seek_cur( 2 );
					length = read4byteLength();
					read_length += 6;
				} else {
					length = read2byteLength();
					read_length += 2;
				}

				b_seaquence = isVR_SQ( vr );
			} else { // ÖٓIVRvf
				length = read4byteLength();
				read_length += 4;
				b_seaquence = e.isSQVR();
			}

			if( b_seaquence ){
				// V[PX^Oǂݍ
				readSequence( e, length );
				read_length += length;

			} else {
				
				if( length == -1 ){
					if( e.groupID() == 0x7fe0 && e.elementID() == 0x0010 ){
						// JvZf[^ǂݍ
						read_length += readCupsuleData( e );
					} else {
						mythrow( "FileReader.readElement(): V[PX^Oł摜^OłȂvfɁAÖٓIZbgĂ܂" );
					}
				} else if( length < 0 ){ // f[^O
					mythrow( "FileReader.readElement(): ̃f[^ZbgĂ܂" );
				} else if( length > m_file_len ){ // f[^t@Cȏ
					mythrow( "FileReader.readElement(): f[^t@CTCY𒴂Ă܂" );
				} else {

					setData2Element( e, read_length, length );

					if( e.groupID() == 0x0002 && e.elementID() == 0x0010 ){
						if( strcmp( e.getString(), "1.2.840.10008.1.2" ) == 0 &&
							m_file_type != TYPE_NOPREAMBLE ){
							m_file_type = TYPE_IMPLICIT_LITTLE;
						}
					}
				}
			}

		}

		delete [] data;

		return true;
	}

protected:
	virtual void setData2Sequence( ConcreteSequence& s, int& sequence_length, int data_length )
	{
		uchar* data = new uchar[data_length];
		readFile( data, data_length );
		sequence_length += data_length;
		s.setData( data, data_length );
		delete [] data;
	}


	virtual void setData2Element( ConcreteElement& e, int& element_length, int data_length )
	{
		uchar* data = new uchar[data_length];
		readFile( data, data_length );
		element_length += data_length;
		e.setData( data, data_length );
		delete [] data;
	}

};

} // namespace docmi

#endif
