#ifndef INCLUDE_DOCMI_FILE_INPUT_CONTROLLER_H
#define INCLUDE_DOCMI_FILE_INPUT_CONTROLLER_H

#include <string>
#include "InputController.h"

namespace docmi {

class FileInputController : public InputController
{
	FILE* m_file;
	String m_path;
	int m_offset;
public:

	virtual int getOffset(){
		return m_offset;
	}

	FileInputController(){
		m_path = "";
		m_file = NULL;
		m_offset = 0;
	}

	FileInputController( const char* path ){
		m_path = path;
		m_file = NULL;
		m_offset = 0;
	}

	FileInputController( const FileInputController& rhs ){
		m_path = rhs.m_path;
		m_file = NULL;
		m_offset = 0;
	}

	FileInputController& operator=( const FileInputController& rhs ){
		close();
		m_path = rhs.m_path;
	}

	void setPath( const char* path ){
		close();
		m_path = path;
	}

	virtual ~FileInputController(){
		close();
	}

	virtual void seek_set( int offset ){
		if( m_file == NULL ) return;
		fseek( m_file, offset, SEEK_SET );
		m_offset = offset;
	}
	virtual void seek_cur( int offset ){
		if( m_file == NULL ) return;
		fseek( m_file, offset, SEEK_CUR );
		m_offset += offset;
	}

	bool open(){
		close();
		if( m_path.size() <= 0 ){ return false; }
		m_file = fopen( m_path.c_str(), "rb" );
		if( m_file != NULL ){
			return true;
		} else {
			return false;
		}
	}
	void close(){
		if( m_file ){
			fclose( m_file );
			m_file = NULL;
		}

		m_offset = 0;
	}

	int read( uchar* buf, int size ){
		if( m_file == NULL ) return 0;
		int len = fread( buf, 1, size, m_file );
		m_offset += len;
		return len;
	}

	// t@C̈ꕔǂݍ
	// 
	int readPart( uchar* buf, int offset, int size ){
		int read_len = 0;
		if( m_path.size() <= 0 ){ return 0; }
		FILE* f = fopen( m_path.c_str(), "rb" );
		if( f ){
			fseek( f, offset, SEEK_SET );
			read_len = fread( buf, 1, size, f );
			fclose( f );
		}
		
		return read_len;
	}

private:
	
};

}

#endif
