#include "element.h"
#include <stdio.h>
#include <stdarg.h>

using namespace docmi;

template<class T>
class ArrayHolder
{
	T* m_data;
public:
	ArrayHolder( int length ){
		m_data = new T[length];
	}
	~ArrayHolder(){ delete [] m_data; }
	T* data(){ return m_data; }
};

/** V[PX^OɊ܂܂V[PXivfWjԂ
 *
 */
const Sequence* Element::getSequence( uint index ) const
{
	if( index < m_sequences.size() ){
		return m_sequences[index];
	}

	return NULL;
}

/** V[PX^OɊ܂܂V[PXivfWjԂ
 *
 */
Sequence* Element::getSequence( uint index )
{
	if( index < m_sequences.size() ){
		return m_sequences[index];
	}

	return NULL;
}


/** vf̃Rs[
 */
void Element::copy( const Element& rhs )
{
	m_group_id = rhs.m_group_id;
	m_element_id = rhs.m_element_id;

	int size = m_sequences.size();
	for( int i=0; i < size; i++ ){
		delete m_sequences[i];
	}
	m_sequences.clear();

	size = rhs.m_sequences.size();
	for( i=0; i < size; i++ ){
		Sequence* temp = rhs.m_sequences[i]->clone();
		m_sequences.push_back( temp );
	}
}

/** f[^
 */
void Element::clear()
{
	m_group_id = 0;
	m_element_id = 0;

	int size = m_sequences.size();
	for( int i=0; i < size; i++ ){
		delete m_sequences[i];
	}
	m_sequences.clear();
}

/** V[PXǉ
 */
void Element::addSequence( Sequence& s )
{
	Sequence* temp = s.clone();
	m_sequences.push_back( temp );
}

// VRԂ
String Element::getVR() const
{
	const DictionaryItem* item = m_dictionary->Find( this->groupID(), this->elementID() );
	if( item ){
		return item->getVR();
	} else {
		return "UN";
	}
}

// ^O̐Ԃ
String Element::getExplanation() const
{
	const DictionaryItem* item = m_dictionary->Find( this->groupID(), this->elementID() );
	if( item ){
		return item->getExplanation();
	} else {
		return "";
	}
}

// vf?
bool Element::isStringVR() const
{
	return isStringVR( getVR() );
}

// SQvfH
bool Element::isSQVR() const
{
	if( strcmp( getVR(), "SQ" ) == 0 ){
		return true;
	} else {
		return false;
	}
}

// 4oCgVRH
bool Element::is4ByteLengthVR() const
{
	if( strcmp( getVR(), "SQ" ) == 0 ||
		strcmp( getVR(), "OB" ) == 0 ||
		strcmp( getVR(), "OW" ) == 0 ||
		strcmp( getVR(), "UN" ) == 0 ){
		return true;
	} else {
		return false;
	}

}


// nꂽ́AVRH
bool Element::isStringVR( const char* vr ) const
{
	if( strcmp( vr, "AE" ) == 0 ||
		strcmp( vr, "AS" ) == 0 ||
		strcmp( vr, "CS" ) == 0 ||
		strcmp( vr, "DA" ) == 0 ||
		strcmp( vr, "DS" ) == 0 ||
		strcmp( vr, "DT" ) == 0 ||
		strcmp( vr, "IS" ) == 0 ||
		strcmp( vr, "LO" ) == 0 ||
		strcmp( vr, "LT" ) == 0 ||
		strcmp( vr, "OF" ) == 0 ||
		strcmp( vr, "PN" ) == 0 ||
		strcmp( vr, "SH" ) == 0 ||
		strcmp( vr, "ST" ) == 0 ||
		strcmp( vr, "TM" ) == 0 ||
		strcmp( vr, "UI" ) == 0 ||
		strcmp( vr, "UT" ) == 0 ){
		return true;
	} else {
		return false;
	}
}


void Element::setSpaceendString( const char* str )
{
	int len = strlen( str );
	String temp = str;
	if( len % 2 ){
		temp.append( " " );
		len += 1;
	}
	this->setData( (const uchar*)temp.c_str(), len );
}

void Element::setNullendString( const char* str )
{
	int len = strlen( str );
	if( len % 2 ){
		len += 1;
	}
	this->setData( (const uchar*)str, len );
}


String Element::getString() const
{
	String vr = getVR();
	String value;
	char tmp[256];

	if( isStringVR( vr ) ){
		ArrayHolder<uchar> str( length() + 1 );
		this->getPart( str.data(), 0, length() );
		str.data()[length()] = '\0';
		value = (char*)str.data();
	} else if( strcmp( vr, "UL" ) == 0 ){ // unsigned long
		int count = length() / 4;
		ArrayHolder<uchar> buf( length() + 1 );
		this->getPart( buf.data(), 0, length() );
		const uint* p_data = (const uint*)buf.data();
		
		for( int i=0; i < count; i++ ){
			if( i > 0 ){ value += "\\"; }
			sprintf( tmp, "%u", p_data[i] );
			value += tmp;
		}
	} else if( strcmp( vr, "US" ) == 0 ){ // unsigned short
		int count = length() / 2;
		ArrayHolder<uchar> buf( length() + 1 );
		this->getPart( buf.data(), 0, length() );
		const ushort* p_data = (const ushort*)buf.data();
		
		for( int i=0; i < count; i++ ){
			if( i > 0 ){ value += "\\"; }
			sprintf( tmp, "%u", p_data[i] );
			value += tmp;
		}
	} else if( strcmp( vr, "SL" ) == 0 ){ // signed long
		int count = length() / 4;
		ArrayHolder<uchar> buf( length() + 1 );
		this->getPart( buf.data(), 0, length() );
		const int* p_data = (const int*)buf.data();
		
		for( int i=0; i < count; i++ ){
			if( i > 0 ){ value += "\\"; }
			sprintf( tmp, "%d", p_data[i] );
			value += tmp;
		}
	} else if( strcmp( vr, "SS" ) == 0 ){ // signed short
		int count = length() / 2;
		ArrayHolder<uchar> buf( length() + 1 );
		this->getPart( buf.data(), 0, length() );
		const short* p_data = (const short*)buf.data();
		
		for( int i=0; i < count; i++ ){
			if( i > 0 ){ value += "\\"; }
			sprintf( tmp, "%u", p_data[i] );
			value += tmp;
		}
	} else if( strcmp( vr, "FL" ) == 0 ){ // float
		int count = length() / 4;
		ArrayHolder<uchar> buf( length() + 1 );
		this->getPart( buf.data(), 0, length() );
		const float* p_data = (const float*)buf.data();
		
		for( int i=0; i < count; i++ ){
			if( i > 0 ){ value += "\\"; }
			sprintf( tmp, "%f", p_data[i] );
			value += tmp;
		}
	} else if( strcmp( vr, "FD" ) == 0 ){ // double
		int count = length() / 8;
		ArrayHolder<uchar> buf( length() + 1 );
		this->getPart( buf.data(), 0, length() );
		const double* p_data = (const double*)buf.data();
		
		for( int i=0; i < count; i++ ){
			if( i > 0 ){ value += "\\"; }
			sprintf( tmp, "%f", p_data[i] );
			value += tmp;
		}
	} else {
		int count = getMin( length(), 10 );
		ArrayHolder<uchar> buf( count );
		this->getPart( buf.data(), 0, count );
		const uchar* p_data = (const uchar*)buf.data();
		
		value = "[";
		for( int i=0; i < count; i++ ){
			if( i > 0 ){ value += " "; }
			sprintf( tmp, "%02X", p_data[i] );
			value += tmp;
		}
		value += "]";
	}

	return value;
}

void Element::deleteSequence( uint index )
{
	if( index < 0 || index >= m_sequences.size() ) return;
	delete m_sequences[index];
	m_sequences.erase( &m_sequences[index] );
}

String docmi::strprintf( const char* str_format, ... )
{
	int alloc_size = 100;
	int return_size;
	char* temp;
	va_list argList;

	while( 1 ){
		temp = new char[ alloc_size ];

		va_start( argList, str_format );
		return_size = _vsnprintf( temp, alloc_size, str_format, argList );
		va_end( argList );


		if( return_size >= 0 && return_size < alloc_size ){
			std::string str = temp;
			delete [] temp;
			return str;
		}

		delete [] temp;
		if( return_size >= 0 ){
			alloc_size = return_size + 1;
		} else {
			alloc_size *= 2;
		}
	}
}