#ifndef INCLUDE_DOCMI_DICTIONARY_H
#define INCLUDE_DOCMI_DICTIONARY_H

#include "Base.h"
#include <vector>
#include <list>

namespace docmi{

#define ITEM_SIZE 0xFFFF

class DictionaryItem
{
	ushort m_group_id;
	ushort m_element_id;
	String  m_vr;
	String  m_explanation;
public:

	void setID( ushort group_id, ushort element_id ){
		m_group_id = group_id;
		m_element_id = element_id;
	}
	
	void setVR( const char* vr ){
		m_vr = vr;
	}

	void setExplanation( const char* explanation ){
		m_explanation = explanation;
	}

	ushort groupID() const{ return m_group_id; }
	ushort elementID() const{ return m_element_id; }

	// vfVRԂ
	String getVR() const{
		return m_vr;
	}

	// vf̐Ԃ
	String getExplanation() const{
		return m_explanation;
	}
};

/** DICOM
 *
 */
class Dictionary
{
private:
	std::list<DictionaryItem>* item_chain[ITEM_SIZE];
	static Dictionary* m_instance;
	static int m_counter;

private:
	Dictionary(){
		for( int i=0; i < ITEM_SIZE; i++ ){
			item_chain[i] = NULL;
		}
	}
	virtual ~Dictionary(){
		for( int i=0; i < ITEM_SIZE; i++ ){
			if( item_chain[i] != NULL ){
				delete item_chain[i];
			}
		}
	}
public:

	static Dictionary* Create(){
		if( m_counter == 0 ){
			m_instance = new Dictionary;
			m_instance->setData();
		}
		AddRef();
		return m_instance;
	}

private:
	// QƃJE^𑝂₷
	static void AddRef(){
		m_counter++;
	}

public:
	static void Release(){
		m_counter--;
		if( m_counter == 0 ){
			delete m_instance;
			m_instance = NULL;
		}
	}

	void addItem( const DictionaryItem& item ){
		if( item_chain[item.elementID()] == NULL ){
			item_chain[item.elementID()] = new std::list<DictionaryItem>;
		}

		item_chain[item.elementID()]->push_back( item );
	}
	void setData();
	const DictionaryItem* Find( ushort g, ushort e ) const;

private:
	Dictionary& operator=( const Dictionary& rhs );
};

} // namespace docmi

#endif
