#ifndef INCLUDE_DOCMI_CONCRETE_SEQUENCE_H
#define INCLUDE_DOCMI_CONCRETE_SEQUENCE_H

#include "concreteelement.h"

namespace docmi{

/** V[PXiDICOMvfWj
 */
class ConcreteSequence : public Sequence
{
	DataHolder* strategy;

public:

	virtual Sequence* clone() const {
		return new ConcreteSequence( *this );
	}

	// RXgN^
	ConcreteSequence(){
		strategy = new DataHolderUnbuffered;
	}

	ConcreteSequence( const uchar* data, int length ){
		strategy = NULL;
		setData( data, length );
	}
	

protected:
	ConcreteSequence( const ConcreteSequence& rhs ): Sequence( rhs )
	{
		strategy = rhs.strategy->clone();
	}

public:

	// fXgN^
	virtual ~ConcreteSequence(){
		delete strategy;
	}
	
	// f[^
	virtual void clear()
	{
		Sequence::clear();
		strategy->clear();
	}

	virtual int length() const {
		return strategy->length();
	}

	virtual void setData( const uchar* data, int length ){
		delete strategy;
		DataHolderBuffered* strategy_buffered = new DataHolderBuffered();
		strategy_buffered->setData( data, length );
		strategy = strategy_buffered;
	}

	virtual const uchar* data() const{
		if( !strategy->isBuffered() ){
			// f[^obt@
			uchar* buf = new uchar[ strategy->length() ];
			strategy->getPart( buf, 0, strategy->length() );
			DataHolderBuffered* strategy_buffered = new DataHolderBuffered();
			strategy_buffered->setData( buf, strategy->length() );
			delete [] buf;

			// const B
			// ێf[^𑀍삷邪AӖIɂ͕ςȂȂ̂ŁA
			// ڂԂ
			ConcreteSequence* e = (ConcreteSequence*)this;
			delete e->strategy;
			e->strategy = strategy_buffered;
		}

		return strategy->data();
	}

	// ^OɊ܂܂f[^̈ꕔԂB
	virtual int getPart( uchar* buf, int start, int request_size ) const
	{
		return strategy->getPart( buf, start, request_size );
	}

	void setFileOffset( FileInputController* input, int offset, int length )
	{
		delete strategy;
		DataHolderUnbuffered* temp = new DataHolderUnbuffered;
		temp->setFileOffset( input, offset, length );
		strategy = temp;
	}

private:
	ConcreteSequence& operator=( const ConcreteSequence& rhs );
};

}

#endif

