#ifndef INCLUDE_DOCMI_CONCRETE_ELEMENT_H
#define INCLUDE_DOCMI_CONCRETE_ELEMENT_H

#include "element.h"
#include "fileinputcontroller.h"

namespace docmi{

class DataHolder {
public:
	// f[^
	virtual void clear() = 0;
	// f[^Ԃ
	virtual int length() const = 0;
	// f[^̈ꕔRs[ĕԂB
	virtual int getPart( uchar* buf, int start, int request_size ) const = 0;
	// obt@ꂽf[^ԂBobt@ĂȂȂNULLԂ
	virtual const uchar* data() const = 0;
	// f[^obt@Ă邩H
	virtual bool isBuffered() const = 0;

	virtual ~DataHolder(){}
	virtual DataHolder* clone() = 0;
protected:
	DataHolder(){}

private:
	DataHolder& operator=( const DataHolder& rhs );
};

// f[^ɓǂݍ񂾎̏
class DataHolderBuffered : public DataHolder
{
	BinaryData m_data;

public:
	virtual void clear(){ m_data.clear(); }
	virtual int length() const { return m_data.length(); }
	virtual int getPart( uchar* buf, int start, int request_size ) const{
		return m_data.getPart( buf, start, request_size );
	}

	// f[^Zbg
	void setData( const uchar* data, int length ){ m_data.setData( data, length ); }
	// f[^̃|C^Ԃ
	virtual const uchar* data() const{ return m_data.data(); }
	virtual bool isBuffered() const{ return true; }

	DataHolderBuffered(){}
	virtual DataHolder* clone(){
		return new DataHolderBuffered( *this );
	}
protected:
	DataHolderBuffered( const DataHolderBuffered& rhs ): m_data( rhs.m_data ){}
private:
	DataHolderBuffered& operator=( const DataHolderBuffered& rhs );
};

// f[^ǂݍłȂԂ̏B
// f[^~ƂɃt@C炻̓sxǂݍށB
class DataHolderUnbuffered : public DataHolder
{
	FileInputController* m_input;
	int m_length;
	int m_offset;

public:
	virtual void clear(){
		m_input = NULL;
		m_length = 0;
		m_offset = 0;
	}
	virtual int length() const { return m_length; }
	virtual int getPart( uchar* buf, int start, int request_size ) const{
		if( start < 0 || start >= m_length ){ return 0; }
		return readData( buf, m_offset + start, getMin( m_length - start, request_size ) );
	}

	void setFileOffset( FileInputController* input, int offset, int length )
	{
		m_input = input;
		m_offset = offset;
		m_length = length;
	}
	virtual const uchar* data() const{ return NULL; }
	virtual bool isBuffered() const{ return false; }

private:
	int readData( uchar* buf, int start, int size ) const
	{
		if( m_input != NULL ){
			return m_input->readPart( buf, start, size );
		} else {
			return 0;
		}
	}

public:
	DataHolderUnbuffered(){ clear(); }
	virtual DataHolder* clone(){
		return new DataHolderUnbuffered( *this );
	}

protected:
	DataHolderUnbuffered( const DataHolderUnbuffered& rhs ){
		m_input  = rhs.m_input;
		m_length = rhs.m_length;
		m_offset = rhs.m_offset;
	}

private:
	DataHolderUnbuffered& operator=( const DataHolderUnbuffered& rhs );
};

class ConcreteElement : public Element
{
	DataHolder* m_data_holder;
public:

	virtual Element* clone() const{
		return new ConcreteElement( *this );
	}

	// RXgN^
	ConcreteElement( ushort group_id = 0, ushort element_id = 0 ): Element( group_id, element_id ){
		m_data_holder = new DataHolderUnbuffered;
	}

	ConcreteElement( ushort group_id, ushort element_id, const uchar* data, int length ): Element( group_id, element_id ){
		m_data_holder = NULL;
		setData( data, length );
	}

	ConcreteElement( ushort group_id, ushort element_id, const char* str ): Element( group_id, element_id ){
		m_data_holder = NULL;
		setSpaceendString( str );
	}

protected:
	ConcreteElement( const ConcreteElement& rhs ): Element( rhs ){
		m_data_holder = rhs.m_data_holder->clone();
	}

public:
	virtual ~ConcreteElement(){
		delete m_data_holder;
	}

	// f[^
	virtual void clear()
	{
		Element::clear();
		m_data_holder->clear();
	}

	virtual int length() const {
		return m_data_holder->length();
	}

	virtual void setData( const uchar* data, int length ){
		delete m_data_holder;
		DataHolderBuffered* temp = new DataHolderBuffered();
		temp->setData( data, length );
		m_data_holder = temp;
	}

	virtual const uchar* data() const{

		if( !m_data_holder->isBuffered() ){
			// f[^obt@
			uchar* buf = new uchar[ m_data_holder->length() ];
			m_data_holder->getPart( buf, 0, m_data_holder->length() );
			DataHolderBuffered* temp = new DataHolderBuffered();
			temp->setData( buf, m_data_holder->length() );
			delete [] buf;

			// const B
			// ێf[^𑀍삷邪AӖIɂ͕ςȂȂ̂ŁA
			// ڂԂ
			ConcreteElement* e = (ConcreteElement*)this;
			delete e->m_data_holder;
			e->m_data_holder = temp;
		}

		return m_data_holder->data();
	}

	// ^OɊ܂܂f[^̈ꕔԂB
	virtual int getPart( uchar* buf, int start, int request_size ) const
	{
		return m_data_holder->getPart( buf, start, request_size );
	}

	// t@CɊi[ꂽꏊZbg
	void setFileOffset( FileInputController* input, int offset, int length )
	{
		delete m_data_holder;
		DataHolderUnbuffered* temp = new DataHolderUnbuffered;
		temp->setFileOffset( input, offset, length );
		m_data_holder = temp;
	}

private:
	ConcreteElement& operator=( const ConcreteElement& rhs );
};

} // namespace docmi

#endif
