// docmi_dumper.cpp : R\[ AvP[Vp̃Gg |Cg̒`
//

#include "stdafx.h"
#include "../import/OnDemandFileReader.h"
using namespace docmi;

void printSequence( const Sequence* s, int nest );

void indent( int count )
{
	for( int i=0; i < count; i++ ){
		printf( "  " );
	}
}

// 1Gg_v
void printElement( const Element* e, int nest )
{
	String tmp;
	indent( nest );

	if( e->isStringVR() ){
		tmp = "\"";
		tmp += e->getString();
		tmp += "\"";
	} else {
		tmp = e->getString();
	}

	String vr = e->getVR();
	if( vr.size() <= 0 ){ vr = "??"; }

	if( e->isSQVR() ){
		printf( "(%4x,%4x) [%s]  %4d item                   # %s \n", e->groupID(), e->elementID(), vr.c_str(), e->getSequences()->size(), e->getExplanation().c_str() );
	} else {
		printf( "(%4x,%4x) [%s] (%4d) %-21s # %s\n", e->groupID(), e->elementID(), vr.c_str(), e->length(), tmp.c_str(), e->getExplanation().c_str() );
	}
	const Sequences* sequences = e->getSequences();

	for( Sequences::const_iterator it=sequences->begin(); it != sequences->end(); ++it ){
		printSequence( *it, nest + 1 );
	}
}

// 1V[PX_v
void printSequence( const Sequence* s, int nest )
{
	const Elements* elements = s->getElements();
	
	indent( nest );
	printf( "<Sequence start>" );
	if( s->length() > 0 ){
		printf( " (%4d)", s->length() );
	}
	puts( "" );

	for( Elements::const_iterator it=elements->begin(); it != elements->end(); ++it ){
		printElement( *it, nest + 1 );
	}

	indent( nest );
	printf( "<Sequence end>\n" );
}


int main(int argc, char* argv[])
{
	if( argc < 2 ){
		puts( "docmi_dumper [path]" );
		return 1;
	}

	OnDemandFileReader reader;
	OnDemandDicomData dicom_data;

	try {
		reader.open( dicom_data, argv[1] );
		puts( "FileReader::open() Success" );

		printSequence( &dicom_data, 0 );
	} catch( Exception& x ){
		printf( "FileReader::open() Failed [%s]", x.message().c_str() );
	}

	return 0;
}

