unit ecma_engine;

//͖؂̎s
//2001/04/10 ~
//by Wolfy

{$DEFINE REFCOUNT_DEBUG}

interface

uses
  windows,classes,sysutils,ecma_type,ecma_expr,ecma_classes,hashtable,ecma_object,
{$IFNDEF NO_SOCKET}
  ecma_sockobject,
{$ENDIF}
{$IFNDEF NO_ACTIVEX}
  activex,ComObj,ecma_activex,
{$ENDIF}
{$IFNDEF NO_DYNACALL}
  dynamiccall,
{$ENDIF}
{$IFNDEF NO_WSH}
  ecma_wsh,
{$ENDIF}
  forms;

type
  TJEngine = class(TObject)
  private
    FParent: TObject;
    FTables: TJSymbolTables;
    FFactory: TJObjectFactory;
    FGlobalFactory: TJObjectFactory;

    FIsRan: Boolean;
    FAbort: Boolean;
    FIsRunning: Boolean;
    FFuncFactory: TJFunctionFactory;
    FGarbageCollection: Boolean;
    FLineNo: Integer;
    //event
    FOnNewObject: TNewObjectEvent;
    FOnStdout: TStringEvent;
    FOnStderr: TStringEvent;
    FOnRun: TNotifyEvent;
    FOnDone: TNotifyEvent;
    FOnStep: TStepEvent;
    FOnStdin: TReadStringEvent;

    //global object
    FGlobalObject: TJGlobalObject;
    FStringObject: TJStringObject;
    FNumberObject: TJNumberObject;
    FRegExpObject: TJRegExpObject;
    FMathObject: TJMathObject;
    FDateObject: TJDateObject;
    FBoolObject: TJBooleanObject;
{$IFNDEF NO_ACTIVEX}
    FActiveXObject: TJActiveXObject;
{$ENDIF}
{$IFNDEF NO_WSH}
    FWScriptObject: TJWScriptObject;
{$ENDIF}
    procedure Println(S: String);
    procedure PrintlnError(S: String);
    procedure EvalStatement(P: PJStatement; Iteration: Boolean; SwitchValue: PJSwitchValue = nil);
    function EvalExpr(P: PJExpr): TJValue;
    function MemberExpr(P: PJExpr): TJValue;
    procedure MemberAssign(P: PJExpr; Value: TJValue);
    function ArrayExpr(P: PJExpr): TJValue;
    procedure ArrayAssign(P: PJExpr; Value: TJValue);

    procedure ParamExpr(List: TJValueList; Arg: PJExpr);
    procedure ObjectExpr(Obj: TJObject; Elements: PJExpr);

    procedure MakeInstance(Obj: TJObject; Members: PJStatement);
    function MakeObject(Name: String; Param: TJValueList): TJObject;
    function NewSymbolTable: TJSymbolTable;
    procedure RegistGlobalObjects(ASymbolTable: TJSymbolTable);
    procedure BeforeRun(Main: Boolean = False);
    procedure AfterRun;

    //object event
    procedure RegExpOnMatchStart(Sender: TObject);
    procedure RegExpOnMatch(Sender: TObject; Index: Integer; var Value: TJValue);
    procedure RegExpOnMatchEnd(Sender: TObject);
    procedure FactoryOnNewObject(Sender: TObject; JObject: TJObject);
    procedure GlobalObjectOnPrint(Sender: TObject; S: String);
    procedure GlobalObjectOnPrintError(Sender: TObject; S: String);
    procedure GlobalObjectOnRead(Sender: TObject; var S: String; var Success: Boolean);
    procedure SymbolTableOnClear(Sender: TObject);
    function GetObjectCount: Integer;
  public
    constructor Create(AParent: TObject);
    destructor Destroy; override;
    function Run(Root: PJStatement): Integer;
    function CallExpr(Func: TJFunction; Param: TJValueList): TJValue;
    function CallFunction(Root: PJStatement; Symbol: String;
      Param: TJValueList; var RetValue: TJValue): Boolean;
    procedure Clear;
    procedure Abort;
    procedure ImportObject(ObjectName: String; ObjectClass: TJObjectClass);
    procedure AllClear;
    function IsRunning: Boolean;
    function WaitRunning: Boolean;

    property GlobalObject: TJGlobalObject read FGlobalObject;
    property ObjectCount: Integer read GetObjectCount;
    property GarbageCollection: Boolean read FGarbageCollection write FGarbageCollection;
    property GlobalFactory: TJObjectFactory read FGlobalFactory;
    property Parent: TObject read FParent;
    //event
    property OnNewObject: TNewObjectEvent read FOnNewObject write FOnNewObject;
    property OnStdout: TStringEvent read FOnStdout write FOnStdout;
    property OnStderr: TStringEvent read FOnStderr write FOnStderr;
    property OnRun: TNotifyEvent read FOnRun write FOnRun;
    property OnDone: TNotifyEvent read FOnDone write FOnDone;
    property OnStep: TStepEvent read FOnStep write FOnStep;
    property OnStdin: TReadStringEvent read FOnStdin write FOnStdin;
  end;

implementation


{ TJEngine }

procedure TJEngine.Println(S: String);
//stdout
begin
  GlobalObjectOnPrint(Self,S + CRLF);
end;

constructor TJEngine.Create(AParent: TObject);
//쐬
begin
  inherited Create;
  FParent := AParent;
  FFuncFactory := TJFunctionFactory.Create;
  FFactory := TJObjectFactory.Create(Self);
  FFactory.OnNewObject := FactoryOnNewObject;
  FGlobalFactory := TJObjectFactory.Create(Self);
  //FGlobalFactory.OnNewObject := FactoryOnNewObject;

  //g݃IuWFNgo^
  ImportObject('Global',TJGlobalObject);
  ImportObject('Array',TJArrayObject);
  ImportObject('String',TJStringObject);
  ImportObject('Number',TJNumberObject);
  ImportObject('Boolean',TJBooleanObject);
  ImportObject('RegExp',TJRegExpObject);
  ImportObject('Math',TJMathObject);
  ImportObject('Date',TJDateObject);

  //ftHgIuWFNg
  FGlobalObject := TJGlobalObject.Create(FGlobalFactory,nil);
  FGlobalObject.OnPrint := GlobalObjectOnPrint;
  FGlobalObject.OnRead := GlobalObjectOnRead;
  FStringObject := TJStringObject.Create(FGlobalFactory,nil);
  FNumberObject := TJNumberObject.Create(FGlobalFactory,nil);
  FRegExpObject := TJRegExpObject.Create(FGlobalFactory,nil);
  FMathObject := TJMathObject.Create(FGlobalFactory,nil);
  FDateObject := TJDateObject.Create(FGlobalFactory,nil);
  FBoolObject := TJBooleanObject.Create(FGlobalFactory,nil);
{$IFNDEF NO_ACTIVEX}
  FActiveXObject := TJActiveXObject.Create(FGlobalFactory,nil);
{$ENDIF}
{$IFNDEF NO_WSH}
  FWScriptObject := TJWScriptObject.Create(FGlobalFactory,nil);
  FWScriptObject.OnStdOut := GlobalObjectOnPrint;
  FWScriptObject.OnStdErr := GlobalObjectOnPrintError;
  FWScriptObject.OnStdIn := GlobalObjectOnRead;
{$ENDIF}
  //QƃJEg
  FGlobalObject.IncRef;
  FStringObject.IncRef;
  FNumberObject.IncRef;
  FRegExpObject.IncRef;
  FMathObject.IncRef;
  FDateObject.IncRef;
  FBoolObject.IncRef;
{$IFNDEF NO_ACTIVEX}
  FActiveXObject.IncRef;
{$ENDIF}
{$IFNDEF NO_WSH}
  FWScriptObject.IncRef;
{$ENDIF}

  FTables := TJSymbolTables.Create;
  //Ce[u
  FTables.Current := __GLOBAL;
  FTables.Items[__GLOBAL] := NewSymbolTable;
end;

destructor TJEngine.Destroy;
//j
begin
  //QƃJEg
  FGlobalObject.DecRef;
  FStringObject.DecRef;
  FNumberObject.DecRef;
  FRegExpObject.DecRef;
  FMathObject.DecRef;
  FDateObject.DecRef;
  FBoolObject.DecRef;
{$IFNDEF NO_ACTIVEX}
  FActiveXObject.DecRef;
{$ENDIF}
{$IFNDEF NO_WSH}
  FWScriptObject.DecRef;
{$ENDIF}

  FreeAndNil(FTables);
  FreeAndNil(FFuncFactory);
  FreeAndNil(FFactory);
  FreeAndNil(FGlobalFactory);
  inherited;
end;

function TJEngine.Run(Root: PJStatement): Integer;
//s
var
  func: TJFunction;
begin
  Result := 0;
  //s̏ꍇI
  if IsRunning then
    Exit;
  //s
  FIsRunning := True;
  BeforeRun(True);
  try
    FAbort := False;
    Clear;
    try
      //O[ol[Xy[X
      func.FuncType := ftImport;
      func.Table := FTables.Items[__GLOBAL];
      FTables[__GLOBAL] := FFuncFactory.BuildFunction(func);

      EvalStatement(Root,False);
      FIsRan := True;
    except
      on E:EJThrow do
        PrintlnError('Exception: ' +
          E.ExceptName + '(' + IntToStr(FLineNo) + ') => ' + E.ErrorMsg);
      on E:EJReturn do
      begin
        Result := AsInteger(@E.Value);
      end;
      on E:EJAbort do
        PrintlnError('Abort Script(' + IntToStr(FLineNo) + ')');
      on E:EJExit do
        Result := E.Status;
    end;

    AfterRun;
  finally
    FIsRunning := False;
  end;
end;

procedure TJEngine.EvalStatement(P: PJStatement;
  Iteration: Boolean; SwitchValue: PJSwitchValue);
//ԂɎs
var
  current: PJStatement;
  v,exceptvalue,returnvalue,compared: TJValue;
  exception,ereturn,ebreak,econtinue,abrt: Boolean;
  exceptname,errormsg,currenttablename: String;
  sl: TStringList;
  i: Integer;
  func: TJFunction;
  switch: TJSwitchValue;
{$IFNDEF NO_ACTIVEX}
  enum: TJEnumeratorObject;
  param: TJValueList;
{$ENDIF}
  arry: TJBaseArrayObject;
begin
  exception := False;
  ereturn := False;
  econtinue := False;
  ebreak := False;

  current := P;
  while Assigned(current) do
  begin
    //sԍ
    FLineNo := current^.LineNo;
    //abort
    if FAbort then
      raise EJAbort.Create('script abort');
    //Cxg
    if Assigned(FOnStep) then
    begin
      abrt := False;
      FOnStep(Self,abrt);
      //~
      if abrt then
        raise EJAbort.Create('script abort');
    end;

    //ϐ錾Jn
    if current^.SType = stVar then
    begin
      //stVarDecl
      EvalStatement(current^.Sub1,Iteration);
    end
    else if current^.SType = stVarDecl then
    begin  //ϐ錾o^
      if Assigned(current^.Expr^.Left) then
        v := EvalExpr(current^.Expr^.Left)
      else
        EmptyValue(v);

      FTables[current^.Expr^.Symbol] := v;
    end
    //C|[g
    else if current^.SType = stImport then
    begin
      //__Global__e[uɒlƂēo^
      func.FuncType := ftImport;
      func.Table := NewSymbolTable;
      FTables[current^.Expr^.Symbol] := FFuncFactory.BuildFunction(func);
      //Ve[uo^
      FTables.Items[current^.Expr^.Symbol] := func.Table as TJSymbolTable;
      currenttablename := FTables.Current;
      FTables.Current := current^.Expr^.Symbol;
      try
        //s
        EvalStatement(current^.Sub1,False);
      finally
        //Ƃɖ߂
        FTables.Current := currenttablename;
      end;
    end
    //֐`
    else if current^.SType = stFunctionDecl then
    begin
      //֐Zbg
      func.FuncType := ftStatement;
      func.Statement := current;
      //p[^Zbg
      func.Parameter := current^.Sub1;
      //e[uɓo^
      FTables[current^.Expr^.Symbol] := FFuncFactory.BuildFunction(func);
    end
    //NX`
    else if current^.SType = stClassDecl then
    begin
      func.FuncType := ftClass;
      func.Statement := current;
      FTables[current^.Expr^.Symbol] := FFuncFactory.BuildFunction(func);
    end
    else if current^.SType = stFinally then
    begin
      //OɊ֌WȂs
      EvalStatement(current^.Sub1,Iteration);
      //return̏ꍇ͗ON
      if ereturn then
      begin
        //ereturn := False;
        raise EJReturn.Create(returnvalue);
      end
      else if ebreak then
      begin
        //ebreak := False;
        //if Iteration then
          raise EJBreak.Create('break');
      end
      else if econtinue then
      begin
        //econtinue := False;
        //if Iteration then
          raise EJContinue.Create('continue');
      end;
    end
    else if exception then
    begin
      //OLb`
      if current^.SType = stCatch then
      begin
        exception := False;
        //ϐo^
        if IsVariable(current^.Expr) then
        begin
          //userO
          if exceptname = E_THROW then
            FTables[current^.Expr^.Symbol] := exceptvalue
          else //Oo^
            FTables[current^.Expr^.Symbol] := BuildString(exceptname);
        end;
        //s
        EvalStatement(current^.Sub1,Iteration);
      end;
    end
    else begin //OȂ
      case current^.SType of
        stNone:;

        stExpr:
        begin
          v := EvalExpr(current^.Expr);
          //ʂobject
          if IsObject(@v) and (v.vObject.RefCount = 0) then
            v.vObject.DecRef;
        end;
        //blocks
        stBlock:
        begin
          EvalStatement(current^.Sub1,Iteration);
        end;
        //for
        stFor:
        begin
          //
          EvalExpr(current^.Expr);
          while True do
          begin
            //݂ꍇ̂
            if Assigned(current^.Sub2^.Expr) then
            begin
              v := EvalExpr(current^.Sub2^.Expr);
              if not AsBool(@v) then
                Break;
            end;

            try try
              //ubNs
              EvalStatement(current^.Sub1,True);
            finally
              //n
              EvalExpr(current^.Sub2^.Next^.Expr);
            end;

            except
              //OƂĎ
              on EJBreak do
                Break;
              on EJContinue do
                Continue;
            end;
          end;
        end;
        //if
        stIf:
        begin
          v := EvalExpr(current^.Expr);
          if AsBool(@v) then
            EvalStatement(current^.Sub1,Iteration)
          else begin
            EvalStatement(current^.Sub2,Iteration);
          end;
        end;
        //while 
        stWhile:
        begin
          while True do
          begin
            v := EvalExpr(current^.Expr);
            if not AsBool(@v) then
              Break;

            try
              //s
              EvalStatement(current^.Sub1,True);
            except
              //OƂĎ
              on EJBreak do
                Break;
              on EJContinue do
                Continue;
            end;
          end;
        end;
        //for in
        stForIn,stForInArrayElement:
        begin
          //ϐŖꍇ͗O
          if current^.Expr^.Code <> opVariable then
            raise EJThrow.Create(E_TYPE,'need variable - for..in');

          v := EvalExpr(current^.Sub2^.Expr);
          //z
          if IsArrayObject(@v) then
          begin
            arry := v.vObject as TJBaseArrayObject;             
            case current^.SType of
              //vf
              stForInArrayElement:
              begin
                for i := 0 to arry.Count - 1 do
                begin
                  FTables[current^.Expr^.Symbol] := arry.GetItem(i);
                  try
                    //ubNs
                    EvalStatement(current^.Sub1,True);
                  except
                    //OƂĎ
                    on EJBreak do
                      Break;
                    on EJContinue do
                      Continue;
                  end;
                end;
              end;
              //index
              stForIn:
              begin
                for i := 0 to arry.Count - 1 do
                begin
                  FTables[current^.Expr^.Symbol] := BuildInteger(i);
                  try
                    //ubNs
                    EvalStatement(current^.Sub1,True);
                  except
                    //OƂĎ
                    on EJBreak do
                      Break;
                    on EJContinue do
                      Continue;
                  end;
                end;
              end;
            end;
          end
{$IFNDEF NO_ACTIVEX}
          else if IsCollection(@v) then //Enumerators
          begin
            param := TJValueList.Create;
            try
              param.Add(v);
              enum := TJEnumeratorObject.Create(FFactory,param);
              try
                enum.IncRef;
                
                while not enum.AtEnd do
                begin
                  FTables[current^.Expr^.Symbol] := enum.Item;
                  try try
                    //ubNs
                    EvalStatement(current^.Sub1,True);
                  finally
                    enum.MoveNext;
                  end;
                  except
                    //OƂĎ
                    on EJBreak do
                      Break;
                    on EJContinue do
                      Continue;
                  end;
                end;
              finally
                enum.DecRef;
              end;
            finally
              param.Free;
            end;
          end
{$ENDIF}
          else if IsObject(@v) then
          begin
            //SĂkey𓾂
            sl := TStringList.Create;
            try
              sl.Text := v.vObject.PropertyList;
              for i := 0 to sl.Count - 1 do
              begin
                //keyϐɓ
                FTables[current^.Expr^.Symbol] := BuildString(sl[i]);  
                try
                  //ubNs
                  EvalStatement(current^.Sub1,True);
                except
                  //OƂĎ
                  on EJBreak do
                    Break;
                  on EJContinue do
                    Continue;
                end;
              end;
            finally
              sl.Free;
            end;
          end
          else //IuWFNgłȂȂO
            raise EJThrow.Create(E_TYPE,'need object,array or collection - for..in');
        end;
        
        //switch
        stSwitch:
        begin
          //]
          v := EvalExpr(current^.Expr);
          try
            //labeleds SwitchValuet
            switch.Match := False;
            switch.Default := nil;
            switch.Value := @v;
            //iterationtrue
            //܂xdefault𖳎ĎsĂ݂
            EvalStatement(current^.Sub1,True,@switch);
            //matchȂdefault傪݂default傩s
            if not switch.Match and Assigned(switch.Default) then
            begin
              switch.Match := True;
              EvalStatement(switch.Default,True,@switch);
            end;
          except //break󂯂
            on EJBreak do
          end;
        end;
        //case default
        stLabeled:
        begin
          //switch value鎞̂ݎs
          if Assigned(SwitchValue) then
          begin
            //matchĂ鎞͖Ŏs
            if SwitchValue^.Match then
              EvalStatement(current^.Sub1,Iteration,nil)
            else begin
              //case:
              if Assigned(current^.Expr) then
              begin
                //萔l𓾂
                v := EvalExpr(current^.Expr);
                //K\eŔr
                if IsRegExpObject(@v) then
                begin
                  compared :=
                    BuildBool((v.vObject as TJRegExpObject).Test(SwitchValue^.Value^));
                end
                else if IsRegExp(@v) then
                begin
                  FRegExpObject.SetRegExpValue(v);
                  compared :=
                    BuildBool(FRegExpObject.Test(SwitchValue^.Value^));
                end
                else //Ŕr
                  compared := CompareValue(opEQ,v,SwitchValue^.Value^); 

                if AsBool(@compared) then
                begin
                  EvalStatement(current^.Sub1,Iteration,nil);
                  //vȍ~͖Ŏs
                  SwitchValue^.Match := True;
                end;
              end
              //default:
              else
                SwitchValue^.Default := current; //default̏ꏊۑƂ
            end;
          end
          else //ςȏꏊlabel
            raise EJThrow.Create(E_SYNTAX,'switch case: or default:');
        end;

        stDo: //do - while
        begin
          while True do
          begin
            try
              //s
              EvalStatement(current^.Sub1,True);
            except
              //OƂĎ
              on EJBreak do
                Break;
              on EJContinue do
                Continue;
            end;

            //𔻒f
            v := EvalExpr(current^.Expr);
            if not AsBool(@v) then
              Break;
          end;
        end;
        //break  for,while doswitch~߂
        stBreak:
        begin
          if Iteration then
            raise EJBreak.Create('break')
          else
            raise EJThrow.Create(E_SYNTAX,'break');
        end;
        //continue
        stContinue:
        begin
          if Iteration then
            raise EJContinue.Create('continue')
          else
            raise EJThrow.Create(E_SYNTAX,'continue');
        end;
        //return
        stReturn:
        begin
          //returnO
          v := EvalExpr(current^.Expr);
          raise EJReturn.Create(v);
        end;
        //throw
        stThrow:
        begin
          v := EvalExpr(current^.Expr);
          //throwO
          raise EJThrow.Create(E_THROW,'',@v);
        end;
        //try
        stTry:
        begin
          try
            EvalStatement(current^.Sub1,Iteration);
          except
            on E:EJThrow do
            begin
              exceptname := E.ExceptName;
              exception := True;
              exceptvalue := E.Value;
              errormsg := E.ErrorMsg;
            end;
            //return߂炦
            on E:EJReturn do
            begin
              ereturn := True;
              returnvalue := E.Value;
            end;

            on EJBreak do
              ebreak := True;

            on EJContinue do
              econtinue := True;

          end;
        end;
        //with
        stWith:
        begin
          v := EvalExpr(current^.Expr);
          //objectȂ
          if v.ValueType = vtObject then
            FTables.PushThis(v.vObject)
          else //O
            raise EJThrow.Create(E_TYPE,'need object - with');

          try
            EvalStatement(current^.Sub1,Iteration);
          finally
            FTables.PopThis;
          end;

        end;

      end;
    end;
    //
    current := current^.Next;
  end;
  //OłȂȂ
  if exception then
    raise EJThrow.Create(exceptname,errormsg,@exceptvalue);
end;


function TJEngine.EvalExpr(P: PJExpr): TJValue;
//]
var
  l,r,t: PJExpr;
  v,con: TJValue;
  param: TJValueList;
  currenttablename,objname: String;  
begin
  EmptyValue(Result);
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  t := P^.Third;

  case P^.Code of
    opExpr:
    begin
      EvalExpr(l);
      Result := EvalExpr(r);
    end;
    //ϐce[u猟
    opVariable:
    begin
      Result := FTables[P^.Symbol];
      if IsUndefined(@Result) then
      begin
        //ϐ`Ȃ̂ŗO
        if not FTables.HasValue(P^.Symbol) then
          raise EJThrow.Create(E_NAME,'undefined - ' + P^.Symbol);
      end;
      {if FTables.HasValue(P^.Symbol) then
        Result := FTables[P^.Symbol]
      else //ϐ`Ȃ̂ŗO
        raise EJThrow.Create(E_NAME,P^.Symbol);}
    end;
    // variable = expr
    opAssign:
    begin
      Result := EvalExpr(r);
      if l^.Code = opVariable then
      begin
        FTables[l^.Symbol] := Result;
      end
      else if (l^.Code = opMember) then
      begin
        MemberAssign(l,Result);
      end
      else if (l^.Code = opArray) then
      begin
        ArrayAssign(l,Result);
      end;
    end;

    //P
    //萔ĉ܂ܕԂ
    opConstant:
    begin
      Result := P^.Value^;
    end;

    opMinus,opPlus,opBitNot:
    begin
      Result := CalcValue1(P^.Code,EvalExpr(l));
    end;
    opPreInc:
    begin
      Result := EvalExpr(l);
      Result := BuildInteger(AsInteger(@Result) + 1);
      if l^.Code = opVariable then
        FTables[l^.Symbol] := Result;
    end;
    opPreDec:
    begin
      Result := EvalExpr(l);
      Result := BuildInteger(AsInteger(@Result) - 1);
      if l^.Code = opVariable then
        FTables[l^.Symbol] := Result;
    end;
    opPostInc:
    begin
      Result := EvalExpr(l);
      if l^.Code = opVariable then
        FTables[l^.Symbol] := BuildInteger(AsInteger(@Result) + 1);
    end;
    opPostDec:
    begin
      Result := EvalExpr(l);
      if l^.Code = opVariable then
        FTables[l^.Symbol] := BuildInteger(AsInteger(@Result) - 1);
    end;
    //Q
    opAdd,opSub,opMul,opDiv,opMod,opDivInt,opBitAnd,opBitOr,opBitXor,
    opBitLeft,opBitRight,opBitRightZero:
    begin
      Result := CalcValue2(P^.Code,EvalExpr(l),EvalExpr(r));
    end;
    //Z
    opMulAssign,opDivAssign,opAddAssign,opSubAssign,opModAssign,
    opBitLeftAssign,opBitRightAssign,opBitRightZeroAssign,
    opBitAndAssign,opBitXorAssign,opBitOrAssign:
    begin
      Result := AssignValue(P^.Code,EvalExpr(l),EvalExpr(r));
      if l^.Code = opVariable then
        FTables[l^.Symbol] := Result
      else if (l^.Code = opMember) then //oɑ
        MemberAssign(l,Result)
      else if (l^.Code = opArray) then
        ArrayAssign(l,Result);
    end;
    //r
    opLS,opGT,opLSEQ,opGTEQ,opEQ,opNE,opEQEQEQ,opNEEQEQ,
    opLogicalOr2,opLogicalAnd2:
    begin
      Result := CompareValue(P^.Code,EvalExpr(l),EvalExpr(r));
    end;
    //V[gT[Lbg]
    opLogicalOr:
    begin
      v := EvalExpr(l);
      if AsBool(@v) then
        Result := BuildBool(True) //right͕]Ȃ
      else begin
        v := EvalExpr(r);
        Result := BuildBool(AsBool(@v));
      end;
    end;
    opLogicalAnd:
    begin
      v := EvalExpr(l);
      if not AsBool(@v) then
        Result := BuildBool(False) //right͕]Ȃ
      else begin
        v := EvalExpr(r);
        Result := BuildBool(AsBool(@v));
      end;
    end;
    opLogicalNot:
    begin
      Result := CompareValue(P^.Code,EvalExpr(l),v);
    end;
    //R
    opConditional:
    begin
      v := EvalExpr(l);
      if AsBool(@v) then //Е̂ݕ]
        Result := EvalExpr(r)
      else
        Result := EvalExpr(t);
      //Result := CalcValue3(opConditional,Evalexpr(l),EvalExpr(r),EvalExpr(t));
    end;
    //oĂяo L=object R=variable
    opMember: Result := MemberExpr(P);

    opArray: Result := ArrayExpr(P);

    //֐Ăяo
    opCall:    //L(vtFunction) R
    begin
      v := EvalExpr(l);
      if IsFunction(@v) then
      begin
        param := TJValueList.Create;
        try
          //p[^Zbg
          ParamExpr(param,r);
          Result := CallExpr(v.vFunction^,param);
        finally
          param.Free;
        end;
      end
      else if IsObject(@v) then
      begin
        //Object̏ꍇ͔zƂ݂Ȃ
        Result := ArrayExpr(P);
      end
      else
        raise EJThrow.Create(E_CALL,'call function error,need function or object');
    end;
    //object쐬
    opNew:
    begin
      objname := l^.Symbol;
      param := TJValueList.Create;
      try
        ParamExpr(param,r);
        if not Assigned(t) then
          Result := BuildObject(MakeObject(objname,param))
        else begin
          currenttablename := FTables.Current;
          FTables.Current := t^.Symbol;
          try
            Result := BuildObject(MakeObject(objname,param));
          finally
            FTables.Current := currenttablename;
          end;
        end;
        //RXgN^ 񂾂Ă
        if Result.vObject.Members.HasKey(objname) then
        begin
          con := Result.vObject.Members.Value[objname];
          if IsFunction(@con) and (con.vFunction.FuncType = ftStatement) then
          begin
            con.vFunction.This := Result.vObject;
            CallExpr(con.vFunction^,param);
          end;
        end;
      finally
        param.Free;
      end;
    end;
    //Object쐬
    opNewObject:
    begin
      Result := BuildObject(TJObject.Create(FFactory,nil));
      ObjectExpr(Result.vObject,l);
    end;
    //z쐬
    opNewArray:
    begin
      param := TJValueList.Create;
      try
        //lZbg
        ParamExpr(param,l);
        Result.ValueType := vtObject;
        if param.Count = 1 then //ЂƂ̂ƂɗvfƂĈ
        begin
          Result.vObject := TJArrayObject.Create(FFactory,nil);
          (Result.vObject as TJArrayObject).Add(param[0]);
        end
        else
          Result.vObject := TJArrayObject.Create(FFactory,param);
      finally
        param.Free;
      end;
    end; 
    //݂̃JgobjectԂ
    opThis:
    begin
      Result.ValueType := vtObject;
      Result.vObject := FTables.This;
    end;
    opSuper:
    begin
      raise EJThrow.Create(E_SYNTAX,'super');
      //Result := MemberExpr(P,FTables.This);
      //Result.ValueType := vtObject;
      //Result.vObject := FTable.This;
    end;
    opDelete:
    begin
      //`
      if l^.Code = opVariable then
        FTables[l^.Symbol] := BuildUndefined;
    end;
    opVoid:
    begin
      Result := Evalexpr(l);
      Result := BuildNull;
    end;
    opTypeOf:
    begin
      Result := EvalExpr(l);
      Result := BuildString(TypeOf(@Result));
    end;
    else begin
      EvalExpr(l);
      EvalExpr(r);
    end;
  end;
end;

function TJEngine.CallFunction(Root: PJStatement; Symbol: String;
  Param: TJValueList; var RetValue: TJValue): Boolean;
//O̊֐Ăяo
var
  v: TJValue;
begin
  Result := False;
  EmptyValue(RetValue);
  //s̏ꍇI
  if IsRunning then
    Exit;
  //s
  FIsRunning := True;

  try
    FAbort := False;
    if Assigned(Root) then
      Run(Root)
    else if not FIsRan then
      Exit;

    v := FTables[Symbol];
    //֐s
    if v.ValueType = vtFunction then
    begin
      BeforeRun;
      try
        RetValue := CallExpr(v.vFunction^,Param);
        Result := True;
      except
        on E:EJThrow do
          PrintlnError('Exception: ' +
            E.ExceptName + '(' + IntToStr(FLineNo) + ') => ' + E.ErrorMsg);
        on E:EJAbort do
          PrintlnError('Abort Script(' + IntToStr(FLineNo) + ')');
      end;

      AfterRun;
    end;
  finally
    FIsRunning := False;
  end;
end;

function TJEngine.CallExpr(Func: TJFunction; Param: TJValueList): TJValue;
//֐Ăяo
var
  paramdecl: PJStatement;
  i,index: Integer;
  args: TJArrayObject;   
  currenttablename,funcname: String;
{$IFNDEF NO_ACTIVEX}
  oleret: OleVariant;
  dispparams: TDispParams;
  arglist: PVariantArgList;
  diput: TDispId;
{$ENDIF}
{$IFNDEF NO_DYNACALL}
  dynavalues: TDynaValueArray;
{$ENDIF}
begin
  EmptyValue(Result);
{$IFNDEF NO_DYNACALL}
  dynavalues := nil;
{$ENDIF}
  //\
  if Func.FuncType = ftStatement then
  begin
    //O
    currenttablename := FTables.Current;
    if Func.NameSpace <> '' then
      FTables.Current := Func.NameSpace;

    FTables.Push;
    //݂ꍇthisvbV
    if Assigned(Func.This) then
      FTables.PushThis(Func.This)
    else //݂ȂƂ GlobalObject
      FTables.PushThis(FGlobalObject);

    //argumentsɓo^
    args := TJArrayObject.Create(FFactory,nil);
    try
      //ݒ
      for i := 0 to Param.Count - 1 do
        args.Add(Param[i]);

      FTables['arguments'] := BuildObject(args);
      //p[^o^
      i := 0;
      paramdecl := Func.Parameter;
      while Assigned(paramdecl) do
      begin
        //ԂɃ[Jϐɓo^
        if (i < Param.Count) and (Assigned(paramdecl^.Expr)) then
          FTables[paramdecl^.Expr^.Symbol] := Param[i];

        paramdecl := paramdecl^.Next;
        Inc(i);
      end;

      try
        EvalStatement(Func.Statement^.Sub2,False);
      except
        on E:EJReturn do
        begin
          Result := E.Value;
          //QƃJEgbN
          if IsObject(@Result) then
            Result.vObject.LockRef;
        end;
      end;
    finally
      FTables.PopThis;
      FTables.Pop;
      FTables.Current := currenttablename;
      //QƃJEgAbN
      if IsObject(@Result) then
        Result.vObject.UnlockRef;
    end;
  end
  //Delphi\bh
  else if Func.FuncType = ftMethod then
    Result := Func.Method(Param)
{$IFNDEF NO_ACTIVEX}
  else if Func.FuncType = ftActiveX then
  begin //ActiveX\bh
    //VarClear(oleret); VarClear̓oOĂ
    VariantInit(oleret);
    //p[^쐬
    if Param.Count > 0 then
      GetMem(arglist,SizeOf(TVariantArg) * Param.Count)
    else
      arglist := nil;

    try
      //tɂ
      index := 0;
      for i := Param.Count - 1 downto 0 do
      begin
        //tagVariantOleVariant͓
        arglist^[index] := TVariantArg(ValueToVariant(Param[i]));
        Inc(Index);
      end;

      dispparams.rgvarg := arglist;
      dispparams.cArgs := Param.Count;
      dispparams.rgdispidNamedArgs := nil;
      dispparams.cNamedArgs := 0;
      //property put̏ꍇ
      if Func.AXMethod.Flag = axfPut then
      begin
        diput := DISPID_PROPERTYPUT;
        dispparams.rgdispidNamedArgs := @diput;
        dispparams.cNamedArgs := 1;
      end;

      //Ăяo
      try
        //\bhĂяõoOVarClearVariantInitɑウƒ
        OleCheck(Func.AXMethod.Parent.Invoke(
          Func.AXMethod.Dispid,
          GUID_NULL,
          GetUserDefaultLCID,
          AXMethodFlagToDisp(Func.AXMethod.Flag),
          dispparams,
          @oleret,nil,nil));

        Result := VariantToValue(oleret,FFactory);
      except
        if Func.This is TJActiveXObject then
          funcname := (Func.This as TJActiveXObject).DispIdToString(Func.AXMethod.Dispid)
        else
          funcname := '';
        //O
        raise EJThrow.Create(E_ACTIVEX,
          AXMethodFlagToString(Func.AXMethod.Flag) + ' error: ' + funcname);
      end;
    finally
      if Assigned(arglist) then
        FreeMem(arglist);
    end;
  end
{$ENDIF}
  //DLL֐̌Ăяo
{$IFNDEF NO_DYNACALL}
  else if Func.FuncType = ftDynaCall then
  begin
    //SynaValueXg쐬
    dynavalues := ValueListToDynaValueArray(Func.DynaDeclare.Arguments,Param);
    //Ăяo
    Result :=
      DynaResultToValue(
        Func.DynaDeclare.ReturnValue,
        DynaCall(
          MakeCallFlags(Func.DynaDeclare.Call),
          Func.DynaDeclare.Procaddr,
          DynaValueArrayToDynaParmArray(dynavalues),
          nil,
          0
        )
      );
  end
{$ENDIF}
  else
    raise EJThrow.Create(E_CALL,'not support function type');
end;

function TJEngine.MemberExpr(P: PJExpr): TJValue;
//o
//L(ʃIuWFNg) R(ϐj
//member ... object.variable
var
  parent: TJValue;
  l,r: PJExpr;
  sym: TJSymbolTable;
begin
  EmptyValue(Result);
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  //IuWFNg𓾂
  parent := EvalExpr(l);

  if IsObject(@parent) then
  begin
    //thisIuWFNgς c ӖH
    //FTable.PushThis(parent.vObject);
    try
      Result := parent.vObject.GetValue(r^.Symbol,False);
      //֐̏ꍇɂthisZbg
      if IsFunction(@Result) then
        Result.vFunction.This := parent.vObject;
    finally
      //FTable.PopThis;
    end;
  end
  else if IsString(@parent) then //̃vpeB
  begin
    FStringObject.text := AsString(@parent);
    Result := FStringObject.GetValue(r^.Symbol,False);
  end
  else if IsRegExp(@parent) then //K\
  begin
    FRegExpObject.SetRegExpValue(parent);
    Result := FRegExpObject.GetValue(r^.Symbol,False);
  end
  else if not IsNaN(@parent) then //
  begin
    FNumberObject.FValue := parent;
    Result := FNumberObject.GetValue(r^.Symbol,False);
  end
  else if IsBool(@parent) then //bool
  begin
    FBoolObject.FBool := AsBool(@parent);
    Result := FBoolObject.GetValue(r^.Symbol,False);
  end
{$IFNDEF NO_ACTIVEX}
  else if IsDispatch(@parent) then
  begin
    FActiveXObject.Clear;
    FActiveXObject.disp := AsDispatch(@parent);
    Result := FActiveXObject.GetValue(r^.Symbol,False);
  end
{$ENDIF}
  else if IsFunction(@parent) and (parent.vFunction^.FuncType = ftImport) then
  begin
    //O
    sym := parent.vFunction^.Table as TJSymbolTable;
    Result := sym[r^.Symbol];
    if IsFunction(@Result) and (Result.vFunction^.FuncType = ftStatement) then
    begin
      //֐ɂ͖O
      Result.vFunction.NameSpace := sym.Name;
    end;
  end
  else
    raise EJThrow.Create(E_NAME,'member error ' + r^.Symbol);
end;

procedure TJEngine.MemberAssign(P: PJExpr; Value: TJValue);
//o֑
//L(ʃIuWFNg) R(ϐj
//member ... object.variable
var
  parent: TJValue;
  l,r: PJExpr;
  sym: TJSymbolTable;
begin
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  //IuWFNg𓾂
  parent := EvalExpr(l);
  if IsObject(@parent) then
  begin
    //o
    if r^.Code = opVariable then
    begin
      parent.vObject.SetValue(r^.Symbol,Value,False);
    end
    else
      raise EJThrow.Create(E_KEY,'member assign error ' + r^.Symbol);
  end
  else if IsFunction(@parent) and (parent.vFunction^.FuncType = ftImport) then
  begin
    //O
    sym := parent.vFunction^.Table as TJSymbolTable;
    sym[r^.Symbol] := Value;
  end
  else
    raise EJThrow.Create(E_NAME,'member assign error' + r^.Symbol);
end;

procedure TJEngine.ParamExpr(List: TJValueList; Arg: PJExpr);
//֐p[^Zbg
var
  current: PJExpr;
  v: TJValue;
begin
  current := Arg;
  while Assigned(current) do
  begin
    v := EvalExpr(current^.Right);
    List.Insert(0,v);
    //List.Add(EvalExpr(current^.Right));
    current := current^.Left;
  end;
end;

procedure TJEngine.Clear;
//e[uNA
begin
  FTables.Clear;
  FFuncFactory.Clear;
  FFactory.Clear;

  FIsRan := False;
  FLineNo := E_UNKNOWN_LINE_NO;
end;

procedure TJEngine.Abort;
begin
  FAbort := True;
end;

procedure TJEngine.FactoryOnNewObject(Sender: TObject;
  JObject: TJObject);
var
  re: TJRegExpObject;
begin
  if JObject is TJRegExpObject then
  begin
    //K\ɍ׍H
    re := TJRegExpObject(JObject);
    re.OnMatchStart := RegExpOnMatchStart;
    re.OnMatchParen := RegExpOnMatch;
    re.OnMatchEnd := RegExpOnMatchEnd;
  end;

{$IFNDEF NO_SOCKET}
  //socket֌Wɍ׍H
  if JObject is TJBaseSocketObject then
  begin
    TJBaseSocketObject(JObject).OnPrint := FGlobalObject.Print;
  end;
{$ENDIF}

  if Assigned(FOnNewObject) then
    FOnNewObject(Self,JObject);
end;

procedure TJEngine.ObjectExpr(Obj: TJObject; Elements: PJExpr);
//L(ϐ)
//R(l)
var
  current: PJExpr;
  //a,b,c,d: TJExpr;
begin
  current := Elements;
  while Assigned(current) do
  begin
    Obj.SetValue(current^.Right^.Left^.Symbol,EvalExpr(current^.Right^.Right),True);
    current := current^.Left;
  end;
end;

procedure TJEngine.MakeInstance(Obj: TJObject; Members: PJStatement);
//objectɃoZbg
var
  current: PJStatement;
  func: TJFunction;
  v: TJValue;
  exp: PJExpr;
begin
  //Oo^
  Obj.RegistName(Members^.Expr^.Symbol);
  //super
  //Obj.RegistProperty('super',BuildObject(Obj));

  current := Members^.Sub1;
  while Assigned(current) do
  begin
    case current^.SType of
      stFunctionDecl:
      begin
        //֐Zbg
        func.FuncType := ftStatement;
        func.Statement := current;
        //p[^Zbg
        func.Parameter := current^.Sub1;
        //oɓo^
        Obj.RegistProperty(current^.Expr^.Symbol,FFuncFactory.BuildFunction(func));
      end;
      //varƕϐ錾
      stVar,stVarDecl:
      begin
        exp := nil;
        case current^.SType of
          stVar: exp := current^.Sub1^.Expr;
          stVarDecl: exp := current^.Expr;
        end;

        if Assigned(exp) then
        begin
          if Assigned(exp^.Left) then
            v := EvalExpr(exp^.Left)
          else
            v := BuildNull;

          Obj.RegistProperty(exp^.Symbol,v);
        end;     
      end;
    end;
    current := current^.Next;
  end;
end;

function TJEngine.MakeObject(Name: String; Param: TJValueList): TJObject;
var
  v: TJValue;
begin
  //g݃IuWFNgΕԂ
  if FFactory.HasObject(Name) then
  begin
    Result := FFactory._NewObject(Name,Param);
  end
  else if FTables.HasValue(Name) then //[U`邩H
  begin
    v := FTables[Name];
    //tableɓo^Ă
    if IsFunction(@v) and (v.vFunction.FuncType = ftClass) then
    begin
      //super objectꍇobject
      if not Assigned(v.vFunction.Statement^.Expr^.Left) then
      begin
        //ċAŌĂ
        Result := MakeObject('Object',Param);
        //쐬
        MakeInstance(Result,v.vFunction.Statement);
      end
      //
      else begin
        //ċA
        Result := MakeObject(v.vFunction.Statement^.Expr^.Left^.Symbol,Param);
        //쐬
        MakeInstance(Result,v.vFunction.Statement);
      end;
    end
    else
      raise EJThrow.Create(E_NAME,'create object error ' + Name);
  end
  else //object̂ŗO
    raise EJThrow.Create(E_NAME,'create object error ' + Name);
end;

function TJEngine.NewSymbolTable: TJSymbolTable;
//VV{e[u쐬
begin
  Result := TJSymbolTable.Create(FGlobalObject);
  Result.OnClear := SymbolTableOnClear;
  RegistGlobalObjects(Result);
end;

procedure TJEngine.ImportObject(ObjectName: String;
  ObjectClass: TJObjectClass);
begin
  FFactory.ImportObject(ObjectName,ObjectClass);
  FGlobalFactory.ImportObject(ObjectName,ObjectClass);
end;

procedure TJEngine.RegExpOnMatch(Sender: TObject; Index: Integer;
  var Value: TJValue);
//K\IuWFNgXV
begin
  FRegExpObject.RegistProperty('$' + IntToStr(Index),Value);
  FRegExpObject.RegistProperty('lastParen',Value);
end;

procedure TJEngine.RegExpOnMatchStart(Sender: TObject);
//K\IuWFNgXVJn
begin
  FRegExpObject.ClearMatch;
end;

procedure TJEngine.RegExpOnMatchEnd(Sender: TObject);
//}b`I O[oXV
var
  re: TJRegExpObject;
begin
  re := Sender as TJRegExpObject;
  FRegExpObject.RegistProperty('input',re.GetValue('input',True));
  FRegExpObject.RegistProperty('index',re.GetValue('index',True));
  FRegExpObject.RegistProperty('lastIndex',re.GetValue('lastIndex',True));
  FRegExpObject.RegistProperty('lastMatch',re.GetValue('lastMatch',True));
  FRegExpObject.RegistProperty('leftContext',re.GetValue('leftContext',True));
  FRegExpObject.RegistProperty('rightContext',re.GetValue('rightContext',True));
  FRegExpObject.RegistProperty('lastParen',re.GetValue('lastParen',True));
end;


procedure TJEngine.GlobalObjectOnPrint(Sender: TObject; S: String);
begin
  if Assigned(FOnStdout) then
    FOnStdout(Self,S);
end;

procedure TJEngine.SymbolTableOnClear(Sender: TObject);
begin
  RegistGlobalObjects(Sender as TJSymbolTable);
end;

procedure TJEngine.RegistGlobalObjects(ASymbolTable: TJSymbolTable);
begin
  ASymbolTable.Global['Global'] := BuildObject(FGlobalObject);
  ASymbolTable.Global['String'] := BuildObject(FStringObject);
  ASymbolTable.Global['Number'] := BuildObject(FNumberObject);
  ASymbolTable.Global['RegExp'] := BuildObject(FRegExpObject);
  ASymbolTable.Global['Math'] := BuildObject(FMathObject);
  ASymbolTable.Global['Date'] := BuildObject(FDateObject);
  ASymbolTable.Global['Boolean'] := BuildObject(FBoolObject);
{$IFNDEF NO_WSH}
  ASymbolTable.Global['WScript'] := BuildObject(FWScriptObject);
{$ENDIF}
end;

procedure TJEngine.PrintlnError(S: String);
//stderr
begin
  GlobalObjectOnPrintError(Self,S + CRLF);
end;

procedure TJEngine.GlobalObjectOnPrintError(Sender: TObject; S: String);
begin
  if Assigned(FOnStderr) then
    FOnStderr(Self,S);
end;

procedure TJEngine.AllClear;
//SăNA
begin
  Clear;
  FFactory.Clear;
end;

function TJEngine.IsRunning: Boolean;
//sǂ
begin
  Result := FIsRunning;
end;

function TJEngine.WaitRunning: Boolean;
//ҋ@
var
  tid,aid: DWORD;
begin
  Result := IsRunning;
  //s̏ꍇ
  if Result then
  begin
    //ҋ@
    Sleep(5);
    //sXbh`FbN
    tid := GetCurrentThreadId;
    aid := GetWindowThreadProcessId(Application.Handle,nil);
    //C̏ꍇ̓bZ[W
    if aid = tid then
      Application.ProcessMessages;
  end;
end;

procedure TJEngine.ArrayAssign(P: PJExpr; Value: TJValue);
//z֑
//L(ʃIuWFNg) R(ϐj
//array  ... object[arguments]
var
  parent: TJValue;
  l,r: PJExpr;
  key: String;
  param: TJValueList;
  v: TJValue;
begin
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  //IuWFNg𓾂
  parent := EvalExpr(l);
  if IsObject(@parent) then
  begin
    //RargumentsȂ̂R^.RightōŌ̈𓾂邱Ƃł
    v := EvalExpr(r^.Right);
    key := AsString(@v);
    //Zbg
    parent.vObject.SetValue(key,Value,True);
  end
  else if IsFunction(@parent) and (parent.vFunction^.FuncType = ftActiveX) then
  begin
{$IFNDEF AX}
    //ActiveXvpeBPutĂяo
    param := TJValueList.Create;
    try
      //CfNT
      ParamExpr(param,r);
      //l
      param.Add(Value);
      parent.vFunction.AXMethod.Flag := axfPut;
      CallExpr(parent.vFunction^,param);
    finally
      param.Free;
    end;
{$ENDIF}
  end
  else
    raise EJThrow.Create(E_NAME,'array assign error ' + r^.Symbol);
end;

function TJEngine.ArrayExpr(P: PJExpr): TJValue;
//z̒l𓾂
//L(ʃIuWFNg) R(ϐj
//array  ... object[arguments]
var
  parent,v: TJValue;
  l,r: PJExpr;
  param: TJValueList;
begin
  EmptyValue(Result);
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  //IuWFNg𓾂
  parent := EvalExpr(l);

  if IsObject(@parent) then
  begin
    //thisIuWFNgς c ӖH
    //FTable.PushThis(parent.vObject);
    try
      //z
      //RargumentsȂ̂R^.RightōŌ̈𓾂邱Ƃł
      if Assigned(r) then
        v := EvalExpr(r^.Right)
      else
        v := BuildString('');

      Result := parent.vObject.GetValue(AsString(@v),True);
      //֐̏ꍇɂthisZbg
      if IsFunction(@Result) then
        Result.vFunction.This := parent.vObject;
    finally
      //FTable.PopThis;
    end;
  end
  else if IsString(@parent) then //
  begin
    FStringObject.text := AsString(@parent);
    v := EvalExpr(r^.Right);
    Result := FStringObject.GetValue(AsString(@v),True);
  end
  else if IsFunction(@parent) and (parent.vFunction^.FuncType = ftActiveX) then
  begin
    //ActiveXvpeBGetĂяo
    param := TJValueList.Create;
    try
      ParamExpr(param,r);
      parent.vFunction.AXMethod.Flag := axfGet;
      Result := CallExpr(parent.vFunction^,param);
    finally
      param.Free;
    end;
  end
  else
    raise EJThrow.Create(E_NAME,'array error ' + r^.Symbol);
end;

procedure TJEngine.GlobalObjectOnRead(Sender: TObject; var S: String; var Success: Boolean);
begin
  if Assigned(FOnStdin) then
    FOnStdin(Self,S,Success);
end;

function TJEngine.GetObjectCount: Integer;
begin
  Result := FFactory.ObjectCount;
end;

procedure TJEngine.AfterRun;
//s
begin
  if Assigned(FOnDone) then
    FOnDone(Self);
end;

procedure TJEngine.BeforeRun(Main: Boolean);
//sO
begin
{$IFNDEF NO_WSH}
  //WScripẗ
  if Main then
    FWScriptObject.Arguments.Parse(FGlobalObject.arguments);
{$ENDIF}  
  if Assigned(FOnRun) then
    FOnRun(Self);
end;

end.

