
/*!
@file dkcThreadLock.c
@auther d
@since 2004/3/xx
*/

#include "dkcThreadLock.h"
#include "dkcStdio.h"

static CRITICAL_SECTION g_csCriticalSection;
static DWORD				g_dwLockedThread = 0;	//	LockĂThreadId(0:Lock)
static int					gLockCount = 0;		//	LockĂ
	//	(XbhȂΕLockł̂)
//Ă邩ǂtOB
static BOOL gInited = FALSE;



static void Init(){
	{
		if(TRUE==gInited){return;}
	}
	InitializeCriticalSection(&g_csCriticalSection);
	g_dwLockedThread = (DWORD)-1;
	gLockCount	= 0;
#	ifdef DEBUG
	ODS("dkcLockThreadInit\n");
#	endif
	gInited = TRUE;
}

static void End(){
	{
		if(FALSE==gInited){return;}
	}
	DeleteCriticalSection(&g_csCriticalSection);
	gInited = FALSE;
	memset(&g_csCriticalSection,0,sizeof(g_csCriticalSection));
	if (gLockCount!=0) {
		dkcmNOT_ASSERT("dkcThreadLockLock񐔂UnlockȂ܂܏IĂ");
	}
#	ifdef DEBUG
	ODS("dkcLockThreadEnd\n");
#	endif
}


///	CriticalSectionɓ
static void Enter(){
	if(FALSE==gInited){
		dkcmFORCE_NOT_ASSERT("dkcThreadLockInit()ŏĂȂ");
		return;
	}
	EnterCriticalSection(&g_csCriticalSection);
	
	g_dwLockedThread = GetCurrentThreadId();
	//	قȂXbh炱ɓĂ邱Ƃ͂łȂ
	//	(CriticalSection̒`)
	gLockCount++;

}

///CriticalSection甲
static void Leave(){
	if(FALSE==gInited){
		dkcmFORCE_NOT_ASSERT("dkcThreadLockInit()ŏĂȂ");
		return;
	}
	if (gLockCount==0){
		dkcmNOT_ASSERT("CriticalSectionManagerEnterĂȂ̂LeaveĂ");
	}

	if (--gLockCount==0) {
		g_dwLockedThread = (DWORD)-1;
	}
	//	LeaveɑXbhEnter\
	LeaveCriticalSection(&g_csCriticalSection);
}

BOOL WINAPI dkcThreadLockIsLockedByThisThread(){
	DWORD dw = GetCurrentThreadId();
	return (g_dwLockedThread == dw);
}

BOOL WINAPI dkcThreadLockIsInited()
{
	return gInited;
}

void WINAPI dkcThreadLockInit(){
	Init();
}

void WINAPI dkcThreadLock_Lock(){
	Enter();
}

void WINAPI dkcThreadLock_Unlock(){
	Leave();
}

void WINAPI dkcThreadLockEnd(){
	End();
}
