/*!
@auther d
@note
licence:BSD Licence
*/

#include <limits.h>
#include "dkcStream.h"
#include "dkcStdio.h"

#if 0

#define dkcmIS_STREAM_ERROR_FLAG(c) \
	((c)!=edkcStreamInitBuffer && (c)!=	edkcStreamInitFile)


static int WINAPI dkcForInitErrorCheck(const DKC_STREAM *ptr){
	if(NULL==ptr){//|C^NULL
		return -1;
	}
	if(ptr->mBuffer){//ɏς
		return -1;
	}
	return 0;
}



static int WINAPI dkcForFlagErrorCheck(const DKC_STREAM *ptr){
	if(dkcmIS_STREAM_ERROR_FLAG(ptr->mMode)) return -1;
	return 0;//succeeded
}


//stream
int WINAPI dkcNewStream(DKC_STREAM *ptr,short flag,size_t size){
	void *p = NULL;
	
	if(dkcForInitErrorCheck(ptr)){return edk_FAILED;}
	if(dkcmIS_STREAM_ERROR_FLAG(flag))
	{//ςȈȁI
		return edk_ArgumentException;
	}	

	//p = calloc(gInitSize,gInitSize);
	p = dkcAllocate(size);

	if(NULL==p){//mۂłȂ
		return edk_OutOfMemory;
	}



	ptr->mBuffer = p;
	ptr->mNowOffset = 0;
	ptr->mSize = size;
	ptr->mMode = flag;
	//clear foepn mode
	NULL_CHAR_ARRAY(ptr->mFileMode);

	return edk_SUCCEEDED;
}

int WINAPI dkcNewStreamForFile(DKC_STREAM *ptr,const char *filename,
																	 const char *mode)
{
	FILE *fp = NULL;
	size_t mode_len = 0;

	if(dkcForInitErrorCheck(ptr)){return edk_FAILED;}
	if(NULL==mode){return edk_FAILED;}
	mode_len = strlen(mode);
	if(mode_len > 2) return edk_FAILED;


	fp = fopen(filename,mode);
	if(!fp){return edk_FAILED;}

	ptr->mBuffer = (BYTE *)fp;
	ptr->mNowOffset = 0;
	ptr->mSize = UINT_MAX;//max!!!
	ptr->mMode = 	edkcStreamInitFile;//for file
	
	//copy fopen mode
	if(DKUTIL_FAILED(dkc_memcpy(ptr->mFileMode,sizeof(ptr->mFileMode),mode,mode_len))){
		return edk_FAILED;
	}
	return edk_SUCCEEDED;
}

/*!
@param point[in] oCgڂ炩B

*/
static int WINAPI dkcStreamSeekLogic(DKC_STREAM *ptr,int offset,int point,int origin){
	/*
	ԑ@ہF
	offset + succeeded
	offset - succeeded
	offset + length error
	offset - length error
	*/
	FILE *fp = NULL;
	size_t change = (size_t)(point + offset);

	switch(ptr->mMode){
	case 	edkcStreamInitBuffer:
		if(!(ptr->mSize > change)){
			return edk_FAILED;
		}
		break;
	case edkcStreamInitFile:
		fp = (FILE *)ptr->mBuffer;
		if(0 != fseek(fp,offset,origin)){
			return edk_FAILED;
		}
		break;
	//default://vȂ̂ť
		//return edk_FAILED;
	}

	//common...

	ptr->mNowOffset = change;


		

	return edk_SUCCEEDED;
}

int WINAPI dkcStreamSeek(DKC_STREAM *ptr,int offset,int origin){
	int result = edk_FAILED;
	if(NULL==ptr) return edk_FAILED;
	if(dkcForFlagErrorCheck(ptr)) return edk_FAILED;
	switch(origin)
	{
	case edkcStreamSeekCurrent://̈ʒuV[N
		result = dkcStreamSeekLogic(ptr,offset,ptr->mNowOffset,origin);
		break;
	case edkcStreamSeekEnd://Ō̈ʒuV[N
		result = dkcStreamSeekLogic(ptr,offset,0,origin);
		break;
	case edkcStreamSeekSet://ŏ̈ʒuV[N
		result = dkcStreamSeekLogic(ptr,offset,ptr->mSize /*- 1*/,origin);
		break;
	default:
		//ςȈȁI
		return edk_ArgumentException;
	}
	return result;
}

int WINAPI dkcStreamRead(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize){
	//int result = edk_FAILED;
	int Read = 0;
	size_t f_read = 0;
	
	
	if(NULL==ptr) return edk_FAILED;
	//if(dkcForFlagErrorCheck(ptr)) return edk_FAILED;
	
	switch(ptr->mMode){
	case edkcStreamInitBuffer:
		Read = (int)(ptr->mNowOffset + size); 
		Read = (int)ptr->mSize - (int)Read; 
		if(Read < 0) return edk_BufferOverFlow;
		
		dkcmNOT_ASSERT(edk_FAILED==dkc_memcpy(buffer,size,
			ptr->mBuffer + ptr->mNowOffset,size
		));
		
		ptr->mNowOffset += size;
		f_read = size;
		break;
	case edkcStreamInitFile:
		
		f_read = fread(buffer,1,size,(FILE *)ptr->mBuffer);
		ptr->mNowOffset += f_read;
		
		break;
	default:
		return edk_FAILED;
	}
	if(readsize){
		*readsize = f_read;
	}
	return edk_SUCCEEDED;
}


int WINAPI dkcStreamResize(DKC_STREAM *ptr,size_t want_size,size_t *reallocated_size)
{
	int ra_r = 0;
	void *NewPtr = NULL;
	void *OldPtr = NULL;
	size_t ReallocatedSize = want_size;
	
	if(NULL==ptr) return edk_FAILED;
	if(edkcStreamInitBuffer != ptr->mMode) return edk_FAILED;

	OldPtr = ptr->mBuffer;

	ra_r = dkcReallocate(&NewPtr,want_size,&OldPtr);
	if(DKUTIL_FAILED(ra_r)){
		return edk_FAILED;
	}
	if(reallocated_size){
		*reallocated_size = ReallocatedSize;
	}

	ptr->mBuffer = NewPtr;
	ptr->mSize = ReallocatedSize;


	return edk_SUCCEEDED;
}

static int WINAPI dkcStreamAutoExpandResize(DKC_STREAM *ptr){
	int ra_r = 0;
	void *NewPtr = NULL;
	void *OldPtr = NULL;
	size_t ReallocatedSize = 0;
	
	if(NULL==ptr) return edk_FAILED;
	if(edkcStreamInitBuffer != ptr->mMode) return edk_FAILED;

	OldPtr = ptr->mBuffer;

	ra_r = dkcReallocateAutoExpand(realloc,&NewPtr,&OldPtr,ptr->mSize,&ReallocatedSize);
	if(DKUTIL_FAILED(ra_r)){
		return edk_FAILED;
	}

	ptr->mBuffer = NewPtr;
	ptr->mSize = ReallocatedSize;


	return edk_SUCCEEDED;

}

int WINAPI dkcStreamWrite(DKC_STREAM *ptr,const void *buffer,size_t size){
	int Read = 0;
	int ra_r=0;
	//size_t ReallocateSize = 0;
	size_t f_write = 0;
	//void *NewPtr,*OldPtr;

	if(NULL==ptr) return edk_FAILED;

	//OldPtr = ptr->mBuffer;
	switch(ptr->mMode){
	case edkcStreamInitBuffer:
		Read = (int)(ptr->mNowOffset + size); 
		Read =  (int)ptr->mSize - (int)Read;
		if(Read < 0){
			ra_r = dkcStreamAutoExpandResize(ptr);
			if(DKUTIL_FAILED(ra_r)){
				return edk_FAILED;
			}
		
		}
		Read = ptr->mSize - ptr->mNowOffset;
		
		dkcmNOT_ASSERT(DKUTIL_FAILED(dkc_memcpy(
			(void *)((BYTE *)ptr->mBuffer + ptr->mNowOffset),
			(size_t)Read,
			buffer,size)
		));
		
		ptr->mNowOffset += size;
		break;
	case edkcStreamInitFile:
		f_write = fwrite(buffer,1,size,(FILE*)ptr->mBuffer);
		ptr->mNowOffset += f_write;
		break;
	default:
		return edk_FAILED;
	}
	return edk_SUCCEEDED;
}






int WINAPI dkcStreamDump(DKC_STREAM *ptr,const char *filename){
	int result = edk_FAILED;
	if(dkcForInitErrorCheck(ptr)) return edk_FAILED;
	switch(ptr->mMode){
	case edkcStreamInitBuffer:
		result = dkcSaveBinary(ptr->mBuffer,ptr->mSize,filename);
		break;
	case edkcStreamInitFile:
		//none
		break;
	default:
		return edk_FAILED;
	}

	return result;
}

int WINAPI dkcDeleteStream(DKC_STREAM *ptr){
	if(NULL==ptr->mBuffer) return edk_FAILED;
	switch(ptr->mMode){
	case edkcStreamInitBuffer:
		dkcFree(&ptr->mBuffer);
		break;
	case edkcStreamInitFile:
		fclose((FILE *)ptr->mBuffer);
		break;
	default:
		dkcmNOT_ASSERT("dkcDeleteStream invalid argument!!!");
		return edk_FAILED;
	}
	ptr->mBuffer = NULL;
	ptr->mSize = 0;
	ptr->mMode = 0;
	ptr->mNowOffset = 0;
	NULL_CHAR_ARRAY(ptr->mFileMode);
	//memset(ptr,0,sizeof(*ptr));
	return edk_SUCCEEDED;
}


DKC_STREAM * WINAPI dkcAllocNewStream(short flag,size_t size,const char *filename,const char *mode){
	int r;
	DKC_STREAM *t = (DKC_STREAM *)dkcAllocate(sizeof(DKC_STREAM));
	if(!t) return NULL;
	
	if(edkcStreamInitFile == flag && filename){
		r = dkcNewStreamForFile(t,filename,mode);
		if(DKUTIL_FAILED(r)){goto Error;}
		
	}
	else
	{
		r = dkcNewStream(t,flag,size);
		if(DKUTIL_FAILED(r)){goto Error;}
	}
	return t;
Error:
	dkcFree((void**)&t);
	//if(t){free(t);t=NULL;}
	return t;
}
//dkcAllocNewStream()Ƒ
int WINAPI dkcFreeDeleteStream(DKC_STREAM **ptr){
	int r;
	r = dkcDeleteStream(*ptr);
	if(DKUTIL_FAILED(r)) return r;

	dkcFree(ptr);
	return edk_SUCCEEDED;
}



int WINAPI dkcStreamClear(DKC_STREAM *ptr){
	if(NULL==ptr) return edk_FAILED;
	if(edkcStreamInitBuffer != ptr->mMode) return edk_FAILED;
	memset(ptr->mBuffer,0,ptr->mSize);
	ptr->mNowOffset = 0;
	return edk_SUCCEEDED;
}

int WINAPI dkcStreamToBuffer(const DKC_STREAM *ptr,int seek,int want_start,int want_end,char *buff,size_t buffsize)
{
	int r;//
	if(NULL==ptr) return edk_FAILED; 
	//t@C[hȂăViCIII
	if(edkcStreamInitFile==ptr->mMode) return edk_FAILED;

	switch(seek){
	case edkcStreamSeekCurrent://̈ʒuV[N
		r = dkc_memcpy(buff,buffsize,
			(void *)((BYTE *)ptr->mBuffer + ptr->mNowOffset + want_start),(size_t)want_end);
		break;
	case edkcStreamSeekEnd://Ō̈ʒuV[N
		r = dkc_memcpy(buff,buffsize,//want_start  - ł낤B
			(void *)((BYTE *)ptr->mBuffer + want_start),(size_t)want_end);
		break;
	case edkcStreamSeekSet://ŏ̈ʒuV[N
		r = dkc_memcpy(buff,buffsize,
			(void *)((BYTE *)ptr->mBuffer + want_start),(size_t)want_end);
		break;
	default:
		return edk_FAILED;
	}
	return r;
}

DKC_STREAM * WINAPI dkcAllocNewStreamCopy(const DKC_STREAM *ptr)
{
	DKC_STREAM *tp = NULL;
	//FILE *fp = NULL;
	//void *tbuf = NULL;
	//size_t tsize = 0;

	if(NULL==ptr) return NULL;
	//t@CI[v[hȂĒmȂIII
	if(tp->mMode == edkcStreamInitFile) return NULL;
	/*
	char mstr[3];
	mstr[0] = ptr->mMode[0];
	mstr[1] = ptr->mMode[1];
	mstr[2] = '\0';

	tp = dkcAllocNewStream(ptr->mMode,ptr->mSize,filename,mstr);
	*/
	tp = dkcAllocNewStream(ptr->mMode,ptr->mSize,NULL,NULL);
	if(NULL==tp) return NULL;
	if(edkcStreamInitBuffer == ptr->mMode){
		//Rs[
		dkcStreamWrite(tp,ptr->mBuffer,ptr->mSize);
	}else{//file
	
		/*tsize = ptr->mSize;
		tbuf = 	dkcAllocate(tsize);
		
		fp = (FILE *)ptr->mBuffer;
		fseek(fp,0,edkcStreamSeekSet);//B
		fread(tbuf,1,UINT_MAX,fp);//Ƃ肠ǂ߂邾B

		*/

	}
	//ItZbgύX             /* 擪 */
	dkcStreamSeek(tp,ptr->mNowOffset,edkcStreamSeekSet);
	return tp;
}


int WINAPI dkcStreamSerialize(const DKC_STREAM *ptr,const char *filename){
	BYTE *p = NULL;
	size_t fsize;
	int result;
	if(NULL==ptr) return edk_ArgumentException;
	if(edkcStreamInitFile==ptr->mMode) return edk_FAILED;

	dkcStreamAllocSerialize(ptr,&p,&fsize);

	result = dkcSaveBinary(p,fsize,filename);

	dkcStreamFreeSerialize(&p);

	return result;
}

//Xg[fVACYB
//int WINAPI dkcSTreamDeserialize(DKC_STREAM *ptr,const char *filename){}

//Xg[̃fVACYobt@炷B
DKC_STREAM * WINAPI dkcAllocNewStreamDeserializeFromBuffer(
		const DKC_STREAM *ptr,const BYTE *buffer,size_t buffsize)
{
	DKC_STREAM *p;


	if( NULL==buffer) return NULL;
	//+1͍Œ̃obt@̃TCYB
	//if(buffsize < sizeof(DKC_STREAM) + 1) return edk_FAILED;
	

	p = dkcAllocNewStream(edkcStreamInitBuffer,ptr->mSize,NULL,NULL);
	dkcStreamWrite(p,buffer,buffsize);
	dkcStreamSeek(p,ptr->mNowOffset,edkcStreamSeekSet);

	return p;
}

//VACYobt@̊蓖Ăs̃AhX擾B
DKC_EXTERN int WINAPI dkcStreamAllocSerialize(const DKC_STREAM *ptr,
																			 BYTE **buffer_ptr,size_t *readsize)
{
	BYTE *p;
	size_t fsize;
	
	if(NULL==ptr || NULL==buffer_ptr || NULL==readsize) return edk_ArgumentException;
	
	if(edkcStreamInitFile==ptr->mMode) return edk_FAILED;

	fsize = sizeof(DKC_STREAM) + ptr->mSize;
	p = (BYTE *)dkcAllocate(fsize);
	
	if(p==NULL) return edk_OutOfMemory;
	
	memcpy(p,ptr,sizeof(DKC_STREAM));
	memcpy((void *)((BYTE *)p + sizeof(DKC_STREAM)),ptr->mBuffer,ptr->mSize);

	return edk_SUCCEEDED;
}


//VACYobt@B
int WINAPI dkcStreamFreeSerialize(BYTE **alloced_buffer){
	return dkcFree(alloced_buffer);
}


#endif
