/*!
@file dkcStdio.h
@brief		buffer over flowȂ@֐^^;
@author		d
@since		transplanted from dkutilStdio.h:2004/2/28
@note
I<br>
http://www-6.ibm.com/jp/developerworks/security/000616/j-buffer-defend.html
*/
#ifndef dkutil_c_Stdio__h
#define dkutil_c_Stdio__h	


#include <stdio.h>
#include <string.h>
#include "dkcOSIndependent.h"

#ifdef __cplusplus
namespace dkutil{
	/*!
	@param dest[out] Rs[
	@param size1[in] dest̃TCY
	@param src[in] Rs[
	@param size2[in] src̃TCY
	@return size1 < size2 edk_FAILEDԂB
	*/
	///memcpÿSŁH
	inline int dkmemcpy(void *dest,size_t size1,const void *src,size_t size2){
		if(size1 < size2) return edk_FAILED;
		::memcpy(dest,src,size2);
		return edk_SUCCEEDED;
	}
	/*!
	@param dest[out] Rs[
	@param size1[in] dest̃TCY
	@param src[in] Rs[
	@param size2[in] src̃TCY
	@return size1 < size2 edk_FAILEDԂB
	*/
	///memmovëSŁH
	inline int dkmemmove( void *dest,size_t size1,const void *src, size_t size2 ){
		if(size1 < size2) return edk_FAILED;
		::memmove(dest,src,size2);
		return edk_SUCCEEDED;
	}
	/*!
	@todo 
	sprintfɏȂ񂽂炩񂽂炪肭oȂ %xƂ%fƂH
	𒼂B
	[boost::formatgقCCiOOGGGp~ɂ`ȁB̊֐B
	*/
#	if 0
	inline int dksprintf(char *buff,size_t bufsize,char *format,...){
		BOOST_STATIC_ASSERT(!"ȁ[I");
		//char buff[2048]="";
		size_t buffnum=bufsize;
		char *origin = format;
		{
			va_list VaList;
			va_start( VaList , origin ) ;
			int r;
			r = _vsnprintf( buff ,buffnum - 1, origin , VaList );
			if(0 > r){
				return edk_FAILED;
			}else{
				buff[r+1] = '\0';
			}
			va_end( VaList ); 
		}

		return edk_SUCCEEDED;
	}
#	endif //end of if 0
	/*!
	@note
	<b>strncpẙ댯</b><br>
	string2 ̍ŏ count  string1 ɃRs[Ă string1 Ԃ܂B
	count string2 ̒ȉ̏ꍇ́A
	<font color=red>Rs[ɎI NULL  (\0) t܂B</font><br>
	<br>
	Ȃ̂ŁAsrcleñTCYsize1傫ꍇedk_FAILEDԂ܂B
	@param dest[out] Rs[
	@param size1[in] dest̃TCY
	@oaram src[in] Rs[
	@param srclen[in] srcRs[镶
	@bug
	bug:		if(size1 < srclen) correct:if(size1 <= srclen)
	*/
	inline int dkstrcpy(char *dest,size_t size1,const char *src,size_t srclen){
		if(size1 <= srclen) return edk_FAILED;
		::strncpy(dest,src,srclen);
		//if(dest[srclen] != '\0') return edk_FAILED;
		dest[srclen] = '\0';//0邩srclen + 1ł͂ȂB
		return edk_SUCCEEDED;
	}
	///@see dkstrcpy(char *dest,size_t size1,const char *src,size_t srclen);
	inline dkstrcpy(BYTE *dest,size_t size1,const BYTE *src,size_t srclen)
	{
		return dkstrcpy((char *)dest,size1,(const char *)src,srclen);
	}
	/*!
	@bug
	bug:if(size1 <  srclen) correct:if(size1 <= srclen)
	@todo
	size10̎ȂA`FbNׂH
	AvȁBsrclenOȂƐ藧ȂB
	
	*/
	///dkstrcpyƈႢAobt@ɓ邾Rs[B@note amap = as much as possible.
	inline int dkstrcpy_amap(char *dest,size_t size1,const char *src,size_t srclen){
#	ifndef NDEBUG
		assert(!(0 == size1 && 0 == srclen));
#	endif
		if(size1 <= srclen){//<=IH
			::strncpy(dest,src,size1);
			dest[size1 - 1] = '\0';
			return edk_Not_Satisfactory;
		}else{
			::strncpy(dest,src,srclen);
			dest[srclen] = '\0';
			return edk_SUCCEEDED;
		}
	}
	inline int dkstrcpy_amap2(char *dest,size_t size1,const char *src){
		return dkstrcpy_amap(dest,size1,src,strlen(src));
	}
	/*!
	@param dest[out] Rs[
	@param destsize[in] dest̃TCY(byte)
	@param destlen[in] destɓĂ镶̒ *1
	@param src[in] Rs[
	@param srclen[in] Rs[ɓĂ镶̒ *1
	@note
	<b>*1:</b> NULL܂܂ȂB<br>
	<b>strncat̊댯H</b><br>
	ǂȂĂ邩͕ȂA
	dest̃TCY`FbNĂSƎvB<br>
	*/
	inline int dkstrcat(char *dest,size_t destsize,size_t destlen,
		const char *src,size_t srclen)
	{
		//destlen + srclen + NULL
		if(destsize < destlen + srclen + 1)	return edk_FAILED;
		::strncat(dest,src,srclen);
		return edk_SUCCEEDED;
	}
	///dkstrcat()Helper ֐
	inline int dkstrcat2(char *dest,size_t destsize,const char *src){
		return dkstrcat(dest,destsize,strlen(dest),src,strlen(src));
	}
	///dkstrcat()̏o邾Rs[ 
	inline int dkstrcat_amap(char *dest,size_t destsize,size_t destlen,
		const char *src,size_t srclen)
	{
		//destlen + srclen + NULL
		int result = edk_SUCCEEDED;
		size_t lsize = destlen + srclen + 1;
		if(destsize < lsize)
		{//I[o[Ă祥
			srclen = lsize - destsize - 1;
			result = edk_Not_Satisfactory;
		}
		::strncat(dest,src,srclen);
		//dest[destlen + srclen - 1] = '\0';
		return result;
	}
	///dkstrcat3Helper
	inline int dkstrcat_amap2(char *dest,size_t destsize,const char *src){
		return dkstrcat_amap(dest,destsize,strlen(dest),src,strlen(src));
	}

	/*!
	@param buf1[in] robt@̂P
	@param buf1PermitSize[in] buf1̃TCY
	@param buf2[in] robt@̂Q
	@param count[in] oCgr邩ǂ̃TCY
	@return  buf1PermitSize < count ̎Aedk_LogicErrorԂB
	@note
	*/	
	inline int dkmemcmp( const void *buf1,size_t buf1PermitSize,
		const void *buf2, size_t count )
	{
		if(buf1PermitSize < count)return edk_LogicError;
		if(0 !=::memcmp(buf1,buf2,count))return edk_FAILED;
		return edk_SUCCEEDED;
	}

	/*!
	@param b1[in] f[^
	@param b1size[in] b1̐
	@param b2[in] f[^
	@param b2size[in] b2̐
	@return b1size < b2size̎Aedk_LogicErrorԂB
	b1b2Ƃedk_SUCCEEDED Ⴄedk_FAILED
	*/
	///RyÃx[X
	template<typename TYPE_>
	inline int WINAPI dkcmp_base(const TYPE_ *b1,size_t b1size,
		const TYPE_ *b2,size_t b2size)
	{
		if(b1size < b2size) return edk_LogicError;
		int result = edk_SUCCEEDED;
		//Ƃ肠}b`邩m߂B
		for(size_t i=0;i<b2size;i++)
		{
			if(b1[i] != b2[i])
			{
				result = edk_FAILED;
				break;
			}
		}
		return result;
	}

	/*!
	@param b1[in] 镶
	@param b1size[in] b1̕
	@param b2[in] 镶
	@param b2size[in] b2̕
	@return b1size < b2size̎Aedk_LogicErrorԂB

	*/
	inline int dkstrcmp(const char *b1,size_t b1size,const char *b2,size_t b2size)
	{
		//镶񂪑Ƃ̂ŃG[
		if(b1size < b2size) return edk_LogicError;
		
		int result = edk_SUCCEEDED;
		if(b2size % 4 == 0)
		{//intŌ
			size_t fb1size = b1size / 4;
			size_t fb2size = b2size / 4;
			const int *fb1 = (const int *)b1;
			const int *fb2 = (const int *)b2;
			return dkcmp_base(fb1,fb1size,fb2,fb2size);
		}
		//else
		//{
			//basic ȌB
			return dkcmp_base(b1,b1size,b2,b2size);
		//}
	}
	/*!
	@param num[in] 𐔂ϐ
	@return ̌
	@todo
	rbgZłǂɂoǁOOGGE[
	*/
	///̌𐔂
	template<typename INTEGER_>
	inline size_t beam(INTEGER_ num){	
		
		size_t b = 0 ;
		for(INTEGER_ i = 10 ; num >= i ; i *= 10 ){
			b ++ ;
		}
		return b;
	}

	/// va  size oCg̓eƁAvb  size oCg̓eB
	inline void memswap( void *va, void *vb, size_t size )
	{
		char *ca;
		char *cb;
		char  cTmp;
		for( ca = (char *)va, cb = (char *)vb; size > 0; size--, ca++, cb++ )
		{
			cTmp = *ca;
			*ca  = *cb;
			*cb  = cTmp;
		}
	}//memswap



	/// 傫 size ̗vf num Ȃz array ̗vf
	/// tɕבւB
	inline void memreverse( void *array, size_t num, size_t size )
	{
		char *l;
		char *r;

		l = (char *)array;
		r = (char *)array + ((num-1) * size);
		for( ; l < r; l = l+size, r = r-size )
			memswap( l, r, size );
	}//memreverse


	/// 傫 size ̗vf num Ȃz array ̗vf
	/// Eɗvf shift ]ړB
	inline void memrrotate( void *array, size_t shift, size_t num, size_t size )
	{
		memreverse( array,                      num,       size ); // 012345678 -> 876543210
		memreverse( array,                      shift,     size ); // 876543210 -> 678543210
		memreverse( (char *)array+(size*shift), num-shift, size ); // 678543210 -> 678012345
	}//memrrotate


	/// 傫 size ̗vf num Ȃz array ̗vf
	/// ɗvf shift ]ړB
	inline void memlrotate( void *array, size_t shift, size_t num, size_t size )
	{
		memreverse( array,                      shift,     size ); // 012345678 -> 210345678
		memreverse( (char *)array+(size*shift), num-shift, size ); // 210345678 -> 210876543
		memreverse( array,                      num,       size ); // 210876543 -> 345678012
	}//memlrotate
}//end of dkutil namespace
#if 0
inline int WINAPI dkc_memcpy(void *dest,size_t size1,const void *src,size_t size2){
	return dkutil::dkmemcpy(dest,size1,src,size2);
}
inline int WINAPI dkc_strcpy(char *dest,size_t size1,const char *src,size_t srclen){
	return dkutil::dkstrcpy(dest,size1,src,srclen);
}
inline int WINAPI dkc_strcpy(BYTE *dest,size_t size1,const BYTE *src,size_t srclen){
	return dkc_strcpy((char *)dest,size1,(const char *)src,srclen);
}
inline int WINAPI dkc_strcpy_amap(char *dest,size_t size1,const char *src,size_t srclen){
	return dkutil::dkstrcpy_amap(dest,size1,src,srclen);
}
///@see dkutil::dkstrcpy_amap2
inline int WINAPI dkc_strcpy_amap2(char *dest,size_t size1,const char *src){
	return dkutil::dkstrcpy_amap2(dest,size1,src);
}
///@see dkutil::dkstrcat
inline int WINAPI dkc_strcat(char *dest,size_t destsize,size_t destlen,
		const char *src,size_t srclen)
{
		return dkutil::dkstrcat(dest,destsize,destlen,src,srclen);
}
///@see dkutil::dkstrcat2
inline int WINAPI dkc_strcat2(char *dest,size_t destsize,const char *src){
	return dkutil::dkstrcat2(dest,destsize,src);
}
///@see dkutil::dkstrcat_amap
inline int WINAPI dkc_strcat_amap(char *dest,size_t destsize,size_t destlen,
		const char *src,size_t srclen)
{
	return dkutil::dkstrcat_amap(dest,destsize,destlen,src,srclen);
}
///@see dkutil::dkstrcat_amap2
inline int WINAPI dkc_strcat_amap2(char *dest,size_t destsize,const char *src){
	return dkutil::dkstrcat_amap2(dest,destsize,src);
}
///@see dkutil::dkmemcmp
inline int WINAPI dkc_memcmp( const void *buf1,size_t buf1PermitSize,
	const void *buf2, size_t count )
{
	return dkutil::dkmemcmp(buf1,buf1PermitSize,buf2,count);
}
inline int WINAPI dkc_strcmp(const char *b1,size_t b1size,const char *b2,size_t b2size)
{
	return dkutil::dkstrcmp(b1,b1size,b2,b2size);
}
inline size_t dkc_beam(int num){	
	return dkutil::beam(num);
}

///@see dkutil::memswap
inline void dkc_memswap( void *va, void *vb, size_t size )
{
	dkutil::memswap(va,vb,size);
}

///@see dkutil::memreverse
inline void dkc_memreverse( void *array, size_t num, size_t size )
{
	dkutil::memreverse(array,num,size);
}
///@see dkutil::memrrotate
inline void dkc_memrrotate( void *array, size_t shift, size_t num, size_t size )
{
	dkutil::memrrotate(array,shift,num,size);
}

///@see dkutil::memlrotate
inline void dkc_memlrotate( void *array, size_t shift, size_t num, size_t size )
{
	dkutil::memlrotate(array,shift,num,size);
}
#endif//end of if 0

#else //for C lang

#endif //end of __cplusplus

DKC_EXTERN int WINAPI dkc_memcpy(void *dest,size_t size1,const void *src,size_t size2);

DKC_EXTERN int WINAPI dkc_memmove(void *dest,size_t size1,const void *src, size_t size2 );


DKC_EXTERN int WINAPI dkc_strcpy(char *dest,size_t size1,const char *src,size_t srclen);

DKC_EXTERN int WINAPI dkc_strcpy_amap(char *dest,size_t size1,const char *src,size_t srclen);
///@see dkutil::dkstrcpy_amap2
DKC_EXTERN int WINAPI dkc_strcpy_amap2(char *dest,size_t size1,const char *src);
///@see dkutil::dkstrcat
DKC_EXTERN int WINAPI dkc_strcat(char *dest,size_t destsize,size_t destlen,
		const char *src,size_t srclen);
///@see dkutil::dkstrcat2
DKC_EXTERN int WINAPI dkc_strcat2(char *dest,size_t destsize,const char *src);
///@see dkutil::dkstrcat_amap
DKC_EXTERN int WINAPI dkc_strcat_amap(char *dest,size_t destsize,size_t destlen,
		const char *src,size_t srclen);
///@see dkutil::dkstrcat_amap2
DKC_EXTERN int WINAPI dkc_strcat_amap2(char *dest,size_t destsize,const char *src);
///@see dkutil::dkmemcmp
DKC_EXTERN int WINAPI dkc_memcmp( const void *buf1,size_t buf1PermitSize,
	const void *buf2, size_t count );
DKC_EXTERN int WINAPI dkc_strcmp(const char *b1,size_t b1size,const char *b2,size_t b2size);
DKC_EXTERN size_t dkc_beam(int num);

///@see dkutil::memswap
DKC_EXTERN void dkc_memswap( void *va, void *vb, size_t size );

///@see dkutil::memreverse
DKC_EXTERN void dkc_memreverse( void *array, size_t num, size_t size );
///@see dkutil::memrrotate
DKC_EXTERN void dkc_memrrotate( void *array, size_t shift, size_t num, size_t size );

///@see dkutil::memlrotate
DKC_EXTERN void dkc_memlrotate( void *array, size_t shift, size_t num, size_t size );

/*!
@param memory[in][out] obt@ւ̃|C^
@param size[in] memorỹTCY
@param point[in] _(oCgڂ)Swap邩H
@return edk_SUCCEEDEDȊOȂG[
@note
char *buff="buffer";݂ɏobt@SwapƃG[B
*/
///̃̈pointɓւB
DKC_EXTERN int dkc_stream_swap(char *memory,size_t size,size_t point);



#if 0
/*!
@note
	oTF񔽓c F KittyGW

  strnicmp - Q̕񒆂̕A啶ʂ
              r܂B

  ̊֐́AVisual C++ɂ͂邪A{[hRpCɂ
  ȂB̂߁A{[hpɍ쐬B
  @ł́A܂ɗȂ̑召͍̔sȂ
  ƂƂB

@F
    const char *string1@r镶P
    const char *string2@r镶Q
    size_t     count@@ r镶

  ߂lF
    int Q̕΂OAȂ΂PԂ
        r镶ɒBOɁȀI[ɒBꍇ́A
        ȂƂ݂ȂB

@param string1@r镶P
@param string2@r镶Q
@param r镶
@return Q̕΂OAȂ΂PԂ
r镶ɒBOɁȀI[ɒBꍇ́AȂƂ݂ȂB
*/

DKC_EXTERN int WINAPI strnicmp(
    const char *string1, const char *string2, size_t count);

#endif

#endif //end of include once