/*!
@file dkcSingleList.h
@since 2003/3/xx
@note
ȂȂC^[lbgłȂHVOXgB

Ȃ݂C++STLstd::slist͔WȂ̂łAقڕWƍlċXƂ̎ťB
C++hslistE߂܂OOGGG
@brief VOXg
*/

#ifndef dkutil_c_SingleList__h
#define dkutil_c_SingleList__h

#include "dkcOSIndependent.h"
#include "dkcBuffer.h"
#include "dkcSerialize.h"

/*!
VOXg\
*/
typedef struct dkc_SingleList{
	BYTE *mBuff;
	size_t mSize;
	struct dkc_SingleList *mNext;
}DKC_SINGLELIST;





///VOXg̈𓾂B
DKC_EXTERN DKC_SINGLELIST * WINAPI dkcAllocSingleList(const void *data,size_t size);
/*!
DKC_SINGLELISTf[g
(NĂ郊Xg폜܂B
̗vf폜ꍇdkcEraseSingleListgĂBj
@note
KgpƂ͂ĂłB
*/
///dkcAllocNewSingleList()ŊmۂXg̈Ɠobt@폜BdkcAllocNewSingleListƑ΁B
DKC_EXTERN int WINAPI dkcFreeSingleList(DKC_SINGLELIST **ptr);


/*!
@note
ptr̎ɐVf[^}B
Vf[^̎ptr̎ւ̃f[^}B
}F
1: ptr->next1->next2;
2: ptr->new data->next1->next2;
*/
DKC_EXTERN int WINAPI dkcSingleListInsert(DKC_SINGLELIST *ptr,const void *data,size_t size);


DKC_EXTERN void WINAPI dkcSingleListChain(DKC_SINGLELIST *ptr,DKC_SINGLELIST *nextp);

/*!
@param top[in] Xg̐[
@return Xĝ悤̐
*/
DKC_EXTERN size_t WINAPI dkcSingleListSize(DKC_SINGLELIST *top);
/*!
@param ptr[in] 폜vfւ̃|C^
@return 폜vfɎւ̗vfwĂ|C^ꍇÃ|C^ԂB
NULL̏ꍇ́Aւ̗vfwĂ|C^͖B
*/
DKC_EXTERN DKC_SINGLELIST * WINAPI dkcSingleListErase(DKC_SINGLELIST *ptr);
/*!
Xg\̓ɕۑĂf[^炤
*/
DKC_EXTERN int WINAPI dkcSingleListGetBuffer(DKC_SINGLELIST *ptr,void *data,size_t size);

/*!
VOXg̈̗vfĂobt@Ƀf[^ށi㏑j
Ȃobt@TCY̓TCYB
*/
DKC_EXTERN int WINAPI dkcSingleListSetBuffer(DKC_SINGLELIST *ptr,const void *data,size_t size);
/*!
dkcSingleListSetBuffer()Wrapper
*/
#define dkcSingleListDynamicSetBuffer(p,d,s) dkcSingleListSetBuffer(p,d,s)

/*!
@return VOXg̈̗vfmۂĂobt@̒̃f[^̃Rs[ԂB
*/
DKC_EXTERN DKC_BUFFER* WINAPI dkcAllocSingleListBuffer(const DKC_SINGLELIST *ptr);

#define dkcFreeSingleListBuffer(p) dkcFreeBuffer(p)


///DKC_SERIALIZEVSingleListB
DKC_EXTERN DKC_SINGLELIST * WINAPI dkcAllocSingleListDeserialize(DKC_DESERIALIZE *se);


///DKC_SERIALIZEɃVACYf[^Ԃ
DKC_EXTERN void WINAPI dkcSingleListSerialize(const DKC_SINGLELIST *ptr,DKC_SERIALIZE *se);


//**********************************************************

/*! stlǂ(́AEEEj */
typedef struct dkc_SingleListObject{
	DKC_SINGLELIST *mBegin;
	DKC_SINGLELIST *mTail;
	DKC_SINGLELIST* (*next)(const DKC_SINGLELIST *);
	DKC_SINGLELIST* (*begin)(struct dkc_SingleListObject *);
	DKC_SINGLELIST* (*tail)(struct dkc_SingleListObject *);
	BOOL (*end)(const DKC_SINGLELIST *);
	BOOL (*push_back)(struct dkc_SingleListObject *,const void *data,size_t size);
	/*!
	@param p[in] struct dkc_SingleListObjectւ̃|C^
	@param prev[in][out] 폜vf(target)̑Õ|C^
	@param target[in] 폜vf
	*/
	void (*erase)(struct dkc_SingleListObject *p,DKC_SINGLELIST *prev,DKC_SINGLELIST *target);
	int (WINAPI *setbuffer)(DKC_SINGLELIST *ptr,const void *data,size_t size);
	int (WINAPI *getbuffer)(DKC_SINGLELIST *ptr,void *data,size_t size);
	BOOL (*empty)(struct dkc_SingleListObject *);
}DKC_SINGLELIST_OBJECT;

DKC_EXTERN DKC_SINGLELIST_OBJECT * WINAPI dkcAllocSingleListObject(const void *data,size_t size);

DKC_EXTERN int WINAPI dkcFreeSingleListObject(DKC_SINGLELIST_OBJECT **);


DKC_EXTERN DKC_SINGLELIST_OBJECT * WINAPI dkcAllocSingleListObjectDeserialize(DKC_DESERIALIZE *se);



DKC_EXTERN void WINAPI dkcSingleListObjectSerialize(const DKC_SINGLELIST_OBJECT *ptr,DKC_SERIALIZE *se);

#endif //end of include once