
/*!
@file dkcSJISFileSystem.c
@auther d
@
*/
#ifdef WIN32
#include <SYS/STAT.H>
#endif
#include "dkcOSIndependent.h"
#include "dkcSJISFileSystem.h"
#include "dkcStdio.h"
#include "dkcString.h"
#include "dkcThreadLock.h"
#include "dkcSingleList.h"










BOOL WINAPI dkcIsEffectivePath(const char *path,size_t size){
	char dest[dkcdMAXPATH_BUFFER];
	const size_t dsize = dkcdMAXPATH_BUFFER;

	//΃pXH΃pXHł̃t@C݂邩H
	if(FALSE==dkcFileExist(path)){
		return FALSE;
	}
	//path𐳋K
	if(DKUTIL_FAILED(dkcToAbsolutelyPath(dest,dsize,path,size))){
		return FALSE;
	}
	//KāAt@CɎgpėǂgĂ邩H
	if(FALSE==dkcIsNativePathString(dest,strlen(dest))){
		return FALSE;
	}

	return TRUE;
}
BOOL WINAPI dkcIsRelativityPath(const char *path)
{
	int point;
	dkcmNOT_ASSERT(NULL==path);
	point = dkcSJIS_StrChrSearch(path,':');
	if(point == -1) return TRUE;
	return FALSE;
}
BOOL WINAPI dkcIsAbsolutelyPath(const char *path)
{
	return !dkcIsRelativityPath(path);
}

///̌낪PathSeparatorTRUE
BOOL WINAPI dkcIsTailPathSep(const char *src,size_t dlen){
	int point;
	point = dkcSJIS_SearchPathSep(src);
	//if(point != -1 && (size_t)point == dlen - 1/*&& (size_t)point != dlen*/)
	if((size_t)point == dlen - 1)
	{	//݂B
		return TRUE;
	}
	//݂ȂB
	return FALSE;
}
///@return path separator}KvA}oTRUE
int WINAPI dkcPushBackPathSep(char *dest,size_t dlen,size_t size){
	if(FALSE==dkcIsTailPathSep(dest,dlen)){
		if(size < dlen + 2){
			return edk_OutputBufferWasLost;//obt@I
		}
		dest[dlen ] = dkcdPATH_SEP;
		dest[dlen + 1] = '\0';//YĂ͂ȂB
		return edk_SUCCEEDED;
	}
	return edk_EndProcess;
}

int WINAPI dkcDirectoryConcatenate(char *dest,size_t dlen,size_t dsize,const char *src){
	//int point;
	//error check
	dkcmNOT_ASSERT(dlen + 2 > dsize);
	if(dlen + 2 > dsize){
		return edk_FAILED;
	}
	
	/*point = dkcSJIS_StrChrSearchTail(dest,dlen,dkcdPATH_SEP);
	if(point != -1 && (size_t)point != dlen)
	{//path separatorAꂪdest̍Ŋɖ
		if(!dkcmIS_PATH_SEP(src[0]) )
		{//path separatorŖ
			//path ؂蕶tĂB
			dest[dlen ] = dkcdPATH_SEP;
			dest[dlen + 1] = '\0';//YĂ͂ȂB
		}
	}*/
	dkcPushBackPathSep(dest,dlen,dsize);
	return dkc_strcat_amap(dest,dsize,dlen,src,strlen(src));
}

int WINAPI dkcCurrentDirectoryConcatenate(char *dest,size_t dsize,const char *src)
{
	//size_t len;
	//int point;
	
	dkcmNOT_ASSERT(dsize <= dkcdMAXPATH_LEN);//<=NULL܂ނ߁B
	
	dkcGetCurrentDirectory(dest,dsize);
	
	
	return dkcDirectoryConcatenate(dest,strlen(dest),dsize,src);
}
#define MAX_PATH_CHECK(dsize) \
{\
	dkcmNOT_ASSERT(dsize < dkcdMAXPATH_BUFFER);\
	if(dsize < dkcdMAXPATH_BUFFER){\
		return edk_BufferOverFlow;\
	}\
}

static int ToAbsolutelyLogic(char *dest,size_t dsize,const char *src)
{
	/*if(dsize < dkcdMAXPATH_BUFFER){//ȃobt@ǂȂ邩ȂOOG
		return edk_BufferOverFlow;
	}*/
	MAX_PATH_CHECK(dsize);
#	ifdef WIN32

	if(NULL==_fullpath(dest,src,dsize)){
		return edk_FAILED;
	}
#	else//unix or linux ??
	if(NULL==__realpath(src,dest)){
		return edk_FAILED;
	}
#	endif
	return edk_SUCCEEDED;	
}
//pX𐳋K֐
int WINAPI dkcToAbsolutelyPath(char *dest,size_t dsize,const char *src,size_t ssize)
{
	char *tp = NULL;
	int r;
	MAX_PATH_CHECK(dsize);

	
	if(NULL==dest) return edk_FAILED;

	if(dkcIsRelativityPath(src)==TRUE)
	{//JgfBNgtB

		tp = malloc(dkcdMAXPATH_BUFFER);
		if(NULL==tp) return edk_OutOfMemory;

		dkcCurrentDirectoryConcatenate(tp,dkcdMAXPATH_BUFFER,src);
		r =  ToAbsolutelyLogic(dest,dsize,tp);
		free(tp);
		return r;

	}
	return ToAbsolutelyLogic(dest,dsize,src);


	
	/*
	ԑ@
	PATH_SEP
	.
	sjis

	/////
	.....
	../../
	/././

	*/
		/*
	size_t i,di;
//	size_t j;
	int point;
	//char prev;
	const char *pathsep="\\/";
	DKC_SINGLELIST_OBJECT *plo = NULL;
	DKC_SINGLELIST *lit = NULL;
	
	
	di = 0;

	if(dsize < ssize){
		return edk_ArgumentException;
	}
	//listm
	plo = dkcAllocSingleListObject(NULL,20);
	if(NULL==plo) return edk_FAILED;

	//directoryp[X
	for(i=0;;){
		point = dkcSJIS_StrChrSearchInStr(&src[i],pathsep);
		if(point < 0){
			if(i != ssize){
				if(FALSE==plo->push_back(plo,&src[i],size - i)){
					return edk_FAILED;
				}
			}
			break;
		}
		
		if(FALSE
			==plo->push_back(plo,&src[i],point - 1)//Ƃ܂ł-1
			)
		{
			return edk_FAILED;
		}

		i += point;
	}

	for(i=0;i<ssize;){


		if(dkcmIsSJIS1(src[i]) && dkcmIsSJIS2(src[i + 1]))
		{//SJIS
			i++;
			i++;
			continue;
		}
		// src == //
		if(prev==dkcdPATH_SEP && src[i] == dkcdPATH_SEP)
		{
			i++;
			continue;
		}
		// src == ..
		if(prev=='.' && src[i] == '.')
		{
			while(src[i] != '.') i++;
			if(dkcdPATH_SEP==src[i]) i++;
			point = dkcSJIS_StrChrSearch(&src[i],dkcdPATH_SEP);

			if(point == -1){
				break;
			}
			i += point;

			continue;
		}

		dest[di] = src[i];
		di++;
		i++;
		prev = src[i];
	}
	*/
	
	return edk_SUCCEEDED;
}


DKC_PATHSTRING * WINAPI dkcAllocPathString(const char *path)
{
	DKC_PATHSTRING *p;
	size_t len;
	/*if(NULL==path){
		return NULL;
	}*/

	p = dkcAllocate(sizeof(DKC_PATHSTRING));
	if(NULL==p) return NULL;

	p->mString = dkcAllocString(dkcdMAXPATH_BUFFER + 1);//̃TCYȂƃ_
	if(NULL==p->mString) goto Error;

	//pXRs[
	if(path){
		len = strlen(path);
		//lCeBuȃpXB
		if(FALSE==dkcIsNativePathString(path,len)){
			goto Error;
		}
		dkcPathStringCopy(p,path,len);
	}
	p->mIterateCount = 0;

	return p;
Error:
	if(p){
		dkcFreeString(&p->mString);
	}
	dkcFree(&p);
	return NULL;
}

int WINAPI dkcFreePathString(DKC_PATHSTRING **ptr)
{
	if(NULL==ptr || NULL==*ptr){
		return edk_ArgumentException;
	}
	dkcFreeString(&((*ptr)->mString));
	return dkcFree(ptr);
}

//pX̃f[^𓾂B
size_t WINAPI dkcPathStringSize(const DKC_PATHSTRING *p)
{
	return dkcStringSize(p->mString);
}

const char *WINAPI dkcPathStringPointer(const DKC_PATHSTRING *p)
{
	return dkcStringPointer(p->mString);
}


//pX؂B

int WINAPI dkcPathStringDevideBegin(DKC_PATHSTRING *ptr,char *buff,size_t size)
{
	return dkcPathStringDevideBegin_Logic(ptr,&ptr->mIterateCount,buff,size);
}

int WINAPI dkcPathStringDevideNext(DKC_PATHSTRING *ptr,char *buff,size_t size)
{
	return dkcPathStringDevideNext_Logic(ptr,&ptr->mIterateCount,buff,size);

}

void WINAPI dkcPathStringDevideEnd(DKC_PATHSTRING *ptr){
	dkcPathStringDevideEnd_Logic(&ptr->mIterateCount);
}


int WINAPI dkcPathStringDevideBegin_Logic(DKC_PATHSTRING *ptr,size_t *count,char *buff,size_t size)
{
	int i,point;
	const char *p;
	dkcmNOT_ASSERT(NULL==ptr || NULL==buff || 0==size);
	
	//len = dkcPathStringSize(ptr);
	p = dkcPathStringPointer(ptr);

	point = dkcSJIS_StrChrSearch(p,'\\');
	if(-1==point){return edk_EndProcess;}

	for(i=0;i<point;i++){//driveŵ̂邩ǂB
		if(':'==p[i]){
			if(DKUTIL_FAILED(dkc_strcpy(
				buff,size,p,(size_t)i//-1
				)))
			{
				return edk_BufferOverFlow;
			}
			point = dkcSJIS_StrChrSearch(&p[i],'\\');//̕B
			//i܂:̎\\ƌ܂Ă邯ǁAB
			*count = (size_t)i + point + 1;//Ɏn߂̂
			return edk_SUCCEEDED;
		}
	}
	if(DKUTIL_FAILED(dkc_strcpy(
		buff,size,p,(size_t)point-1
		)))
	{
		return edk_FAILED;
	}
	*count = (size_t)point + 1;//Ɏn߂̂
	return edk_SUCCEEDED;
}

int WINAPI dkcPathStringDevideNext_Logic(DKC_PATHSTRING *ptr,size_t *count,char *buff,size_t size)
{
	int point;
	const char *p;
	size_t len;
	//len = dkcPathStringSize(ptr);
	p = dkcPathStringPointer(ptr);
	len = dkcStringSize(ptr->mString);
	if(len <= *count)
	{//̊֐Ăяô͏I肾イɁII
		return edk_EndProcess;
	}
	point = dkcSJIS_StrChrSearch(&p[*count],'\\');
	if(-1==point)
	{//Ō܂ŗ܂B

	
		len -= *count;
		if(DKUTIL_FAILED(dkc_strcpy(//c蕨SRs[
			buff,size,&p[*count],len
		)))
		{
			return edk_FAILED;
		}
		*count += len;
		return edk_SUCCEEDED;//out
	}
	if(DKUTIL_FAILED(dkc_strcpy(
		buff,size,&p[*count],(size_t)point
		)))
	{
		return edk_FAILED;
	}
	*count += (size_t)point + 1;//Ɏn߂̂
	return edk_SUCCEEDED;//out
}

void WINAPI dkcPathStringDevideEnd_Logic(size_t *count){
	*count = 0;
}

int WINAPI dkcPathStringElementInsert_Logic(DKC_PATHSTRING *ptr,size_t count,
					const char *src,size_t len)
{
	int r;
	size_t size = len + 5;
	
	char *p;
	if(len==0 || FALSE==dkcIsNativePathString(src,len))
	{
		return edk_FAILED;
	}
	if(FALSE==dkcIsTailPathSep(src,len))//PathSeparatorII
	{
		p = malloc(size);
	
		if(!p) return edk_OutOfMemory;
		strcpy(p,src);//܂gȂǂłɃobt@͕ۏ؂Ă̂strcpy
		dkcPushBackPathSep(p,len,size);

		r = dkcStringInsert(ptr->mString,count,p,strlen(p));
		free(p);
	}else{
		r = dkcStringInsert(ptr->mString,count,src,len);
	}
	return r;
}

int WINAPI dkcPathStringElementErase_Logic(
	DKC_PATHSTRING *ptr,size_t count)
{
	const char *p = dkcPathStringPointer(ptr);
	int endlen = dkcSJIS_SearchPathSep(&p[count]);

	if(-1==endlen){
		endlen = dkcPathStringSize(ptr);
		endlen = endlen - count;
	}else{
		//endlen;//}CiXĂ \\ReplaceȂ
	}
	return dkcStringErase(ptr->mString,count - 1,(size_t)endlen + 1);//count -1͑O\\endlen + 1-1
}



int WINAPI dkcPathStringElementReplace_Logic(DKC_PATHSTRING *ptr,size_t count,
																			const char *src,size_t len)
{
	const char *p = dkcPathStringPointer(ptr);
	int endlen;
	if(len==0 || FALSE==dkcIsNativePathString(src,len))
	{
		return edk_FAILED;
	}
	endlen = dkcSJIS_SearchPathSep(&p[count]);//count猟Ă
	if(-1==endlen){
		endlen = dkcPathStringSize(ptr);
		endlen = endlen - count;
	}else{
		if(0 != endlen)
			endlen--;//}CiXĂ \\ReplaceȂ
	}
	return dkcStringReplace(ptr->mString,count,count + endlen,src,len);
	/*
	size_t size = len + 5;
	int r;
//	int point;
	const char *pointer;
	char *p ;
	if(FALSE==dkcIsTailPathSep(src,len))//PathSeparatorII
	{
		//ƕύX
		p = malloc(size);
		if(!p) return edk_OutOfMemory;
		strcpy(p,src);
		r = dkcPushBackPathSep(p,len,size);
	}else{
		p = (char *)src;
	}
	pointer = dkcPathStringPointer(ptr);
	//count璲ׂB
	dkcSJIS_SearchPathSep(&pointer[count]);
	*/
	


	

}





//pX𐳋KēB
static int dkcPathStringNormalizeCopyLogic(DKC_PATHSTRING *ptr,const char *buff,size_t size,
																						 int (WINAPI *function__)(DKC_STRING *,const char *,size_t))
{
	//const size_t bsize = dkcdMAXPATH_BUFFER + 1;
	size_t len;
	int result;
	//char *pb = malloc(bsize);
	//if(NULL== pb) return edk_OutOfMemory;
	char pb[dkcdMAXPATH_BUFFER];
	size_t bsize = sizeof(pb);

	result = 	dkcToAbsolutelyPath(pb,bsize,buff,size);
	

	len = strlen(pb);

#	ifdef DEBUG //肦Ȃ`G[`FbN
	dkcmNOT_ASSERT(DKUTIL_FAILED(result));	
	dkcmNOT_ASSERT(len >= bsize);// >=ɂ̂NULLׂĂ邩ǂB
	dkcmNOT_ASSERT(NULL==function__);
#	endif
	if(DKUTIL_FAILED(result)){
		goto Error;
	}
	result = function__(ptr->mString,pb,len);

Error:
	//if(pb){free(pb);pb=NULL;}
	return result;
}
//pX𐳋KēB
int WINAPI dkcPathStringCopy(DKC_PATHSTRING *ptr,const char *buff,size_t size)
{
	
	dkcmNOT_ASSERT(ptr->mString->mByteSize + size >= dkcdMAXPATH);
	if(ptr->mString->mByteSize + size >= dkcdMAXPATH)
	{//ȏ͓ȂB
		return edk_FAILED;
	}
	return dkcPathStringNormalizeCopyLogic(ptr,buff,size,dkcStringCopy);
}

int WINAPI dkcPathStringNormalizeConcatenateLogic(
	DKC_PATHSTRING *ptr,const char *buff,size_t size)
{
	char dest[dkcdMAXPATH_BUFFER];


	if(FALSE==dkcIsTailPathSep(dkcPathStringPointer(ptr),dkcPathStringSize(ptr)))
	{
		dkcStringConcatenate(ptr->mString,dkcdPATH_SEP_STR,1);
	}
	dkcStringConcatenate(ptr->mString,buff,size);
	
	size = dkcPathStringSize(ptr) + 1;

	//p = malloc(dkcPathStringSize(ptr));
	//if(!p) return edk_OutOfMemory;


	if(DKUTIL_FAILED(
		ToAbsolutelyLogic(dest,sizeof(dest),dkcPathStringPointer(ptr))
		)){
		return edk_FAILED;
	}

	return dkcPathStringCopy(ptr,dest,strlen(dest));
}

//pX𐳋KČqB
int WINAPI dkcPathStringConcatenate(DKC_PATHSTRING *ptr,const char *buff,size_t size)
{
	int result;

	dkcmNOT_ASSERT(ptr->mString->mByteSize + size >= dkcdMAXPATH);
	if(ptr->mString->mByteSize + size >= dkcdMAXPATH)
	{//ȏ͓ȂB
		return edk_FAILED;
	}

	if(ptr->mString->mByteSize)
	{//łɓĂ̂B
		result = dkcPathStringNormalizeConcatenateLogic(ptr,buff,size);
	}
	else
	{//͂
		result =  dkcPathStringCopy(ptr,buff,size);
	}
	//return dkcPathStringNormalizeInsertLogic(ptr,buff,size,dkcStringConcatenate);	
	return result;
}



int WINAPI dkcPathStringGetDrive(DKC_PATHSTRING *ptr,char *buff,size_t size){
	const char *p = dkcStringPointer(ptr->mString);
	int point = dkcSJIS_StrChrSearch(p,':');
	if(-1 == point) return edk_Not_Found;//ȂB
	//return dkc_memcpy(buff,size,p,(size_t)point - 1);
	return dkc_strcpy(buff,size,p,(size_t)1);//driveȂ1ŏ\ˁOOG
}

int WINAPI dkcPathStringGetFileExtension(DKC_PATHSTRING *ptr,char *buff,size_t size)
{
	int point2;
	size_t len;
	const char *p = dkcStringPointer(ptr->mString);
	int point = dkcSJIS_StrChrSearchLast(p,'.');

	if(point < 0) return edk_Not_Found;//ȂB
	
	point2 = dkcSJIS_SearchPathSep(&p[point]);
	if(point < point2){//C:\ok.OK\folder̂悤ȏ󋵂ɂȂĂB
		return edk_Not_Found;
	}
	len = dkcStringSize(ptr->mString);
	//if(point - 1 <= 0) return edk_FAILED;

	if((size_t)(point + 1) > len) return edk_FAILED;//LogicalȃG[HH
	return dkc_strcpy(buff,size,&p[point + 1],(size_t)len - (size_t)point );

}

int WINAPI dkcPathStringGetFileName(DKC_PATHSTRING *ptr,char *buff,size_t size)
{
	const char *p = dkcStringPointer(ptr->mString);
	int point = dkcSJIS_StrChrSearchLast(p,dkcdPATH_SEP);
	size_t len = dkcStringSize(ptr->mString);
	//if(point - 1 <= 0) return edk_FAILED;
	if(point < 0) return edk_FAILED;
	if((size_t)(point + 1) > len) return edk_FAILED;
	if((size_t)point == len) return edk_FAILED;//t@CB
	return dkc_strcpy(buff,size,&p[point + 1],(size_t)len - (size_t)point );
}

int WINAPI dkcPathStringGetDirectory(DKC_PATHSTRING *ptr,char *buff,size_t size)
{
	const char *p = dkcStringPointer(ptr->mString);
	int point = dkcSJIS_StrChrSearchTail(p,strlen(p),dkcdPATH_SEP);
	size_t len = dkcStringSize(ptr->mString);
	//if(point - 1 <= 0) return edk_FAILED;
	if(point < 0) return edk_FAILED;
	if((size_t)(point + 1) > len) return edk_FAILED;
	//if((size_t)point == len) return edk_FAILED;//t@CB
	return dkc_strcpy(buff,size,p,point);//\\܂߂B

}





BOOL WINAPI dkcFileExist(const char *filename){
	struct stat s;
	if(!filename) return FALSE;
	return (stat(filename,&s)==0) ? TRUE : FALSE;
}

UINT WINAPI dkcFileSize(const char *filename){
	struct stat s;//s
	if(!filename) return 0;
  return (stat(filename,&s)==0) ? (UINT)s.st_size : 0;
}


BOOL WINAPI dkcSetCurrentDirectory(const char *filename){
	size_t len = strlen(filename);
	dkcmNOT_ASSERT(0==len || FALSE==dkcIsEffectivePath(filename,len));
#	ifdef WIN32
	return(0 != SetCurrentDirectory(filename));
	//return (_chdir(filename)==0);
#	else
	return (chdir(filename)==0);
#	endif
}


BOOL WINAPI dkcGetCurrentDirectory(char *buff,size_t size){
#	ifdef WIN32
	if(0==GetCurrentDirectory(size,buff)){
		return FALSE;
	}
	/*if(NULL==_getcwd(path,dkcdMAXPATH_BUFFER)){
		return FALSE;
	}*/
#else
  if(NULL==getcwd(buff,size))
		return FALSE;
#endif
	return TRUE;

#if 0
	/* ǂɂȂĂ邩Ȃ̂łƂ肠+1 */
	char path[dkcdMAXPATH_BUFFER + 1];
	size_t len;
#	ifdef WIN32
	if(0==GetCurrentDirectory(size,path)){
		return FALSE;
	}
	/*if(NULL==_getcwd(path,dkcdMAXPATH_BUFFER)){
		return FALSE;
	}*/
#else
  if(NULL==getcwd(path,dkcdMAXPATH_BUFFER))
		return FALSE;
#endif
	len = strlen(path);
	return DKUTIL_SUCCEEDED(dkc_strcpy(buff,size,path,len));
#endif //end of if 0
}

static BOOL WINAPI dkcCreateDirectoryLogic(const char *dir,const void *ptr){
#ifdef WIN32
	 //return (0 == _mkdir( dir ));
	 return (0 != CreateDirectory(dir,(SECURITY_ATTRIBUTES *)ptr));
#else
	 return (0 == mkdir( dir ));
#endif
}



int WINAPI dkcCreateDirectory(const char *pPath)
{
	BOOL result;
	char work[dkcdMAXPATH_BUFFER];
	unsigned long n = 0;
	unsigned long len = strlen(pPath);

#ifdef WIN32//sjis support
	SECURITY_ATTRIBUTES attr;
	
	DKUTIL_STRUCTURE_INIT(attr);
	NULL_CHAR_ARRAY(work);

	//error check
	if(dkcdMAXPATH_LEN < len){
		dkcmNOT_ASSERT_MESSAGE("pathB",pPath);
		return edk_FAILED;
	}
	if(0==len ){
		return edk_ArgumentException;
	}

	//܂͈ڂj
	if ( dkcmIsSJIS1(pPath[n]) || ! dkcmIS_INVALID_FOLDERNAME_CHAR(pPath[n]) )
	{//SJIŜPڂINVALIDȒlł͖B
		work[n] = pPath[n];
		if(1==len){
			//tH_쐬
			attr.nLength = sizeof(SECURITY_ATTRIBUTES);
			attr.lpSecurityDescriptor = NULL;
			attr.bInheritHandle = FALSE;

			result = dkcCreateDirectoryLogic( work, &attr );
			
			dkcmNOT_ASSERT("directoryȂ" && FALSE==result);
			return edk_SUCCEEDED;
		}
	}
	n++;
	//ڂJn
	while ( n < len )
	{
		 //tH_擾
		while ( n < len )
		{
			
			if(! dkcmIsSJIS1(pPath[n - 1]) && ! dkcmIsSJIS2(pPath[n]) )
			{//SJISł͂ȂII
				if ( ( dkcmIS_PATH_SEP(pPath[n]) ) /*&& pPath[n] != '\0'*//*(n != '\0')*/ )
				{
					if ( work[n-1] != ':' )
					{//driveǂݍ܂Ȃ炵B
						break;
					}
				}
				else if(dkcmIS_INVALID_FOLDERNAME_CHAR(pPath[n]))
				{//SJISNÂɊԈႢ
					return edk_FAILED;
				}
			}
			
			work[n] = pPath[n];
			n++;
		}
		work[n] = '\0';

		//tH_쐬
		attr.nLength = sizeof(SECURITY_ATTRIBUTES);
		attr.lpSecurityDescriptor = NULL;
		attr.bInheritHandle = FALSE;

		result = dkcCreateDirectoryLogic( work, &attr );
		
		dkcmNOT_ASSERT("directoryȂ" && FALSE==result);
		
		work[n++] = dkcdPATH_SEP;
	}
#else //no support sjis
	NULL_CHAR_ARRAY(work);
	
		//error check
	if(dkcdMAXPATH_LEN < len){
		dkcmNOT_ASSERT_MESSAGE("pathB",pPath);
		return edk_FAILED;
	}
	if(0==len ){
		return edk_ArgumentException;
	}

	while ( n < len )
	{
		 //tH_擾
		while ( n < len )
		{
			if ( ( dkcmIS_PATH_SEP(pPath[n]) ) && (n != '\0') )
			{
				if ( work[n-1] != ':' )//Linux̃hCũpX̓Rf̂ȁH
				{
					break;
				}
			}
			work[n] = pPath[n];
			n++;
		}
		work[n] = '\0';

		result = dkcCreateDirectoryLogic( work,NULL );

		dkcmNOT_ASSERT("directoryȂ" && FALSE==result);

		work[n++] = dkcdPATH_SEP;
	}

#endif

	return edk_SUCCEEDED;
}

BOOL WINAPI dkcFileCopy(const char *dest,const char *src){
	return dkcFileCopyEx(dest,src,1024 * 64,FALSE);
}

BOOL WINAPI dkcFileCopyEx(const char *dest,const char *src,
																		size_t inner_buffer_size,BOOL bThreadLock)
{
	void *buff;
	FILE *srcf,*destf;
	size_t filesize;//t@CTCY
	size_t readed;//ǂݍ񂾃f[^
	size_t count;//count
	size_t i;
	size_t rest;//c
	int result = FALSE;//߂l

	if(NULL==dest || NULL==src) return FALSE;
	if(inner_buffer_size <= 1024){
		inner_buffer_size = 1024;
	}

	//obt@̏
	buff = malloc(inner_buffer_size);
	if(NULL==buff){
		inner_buffer_size = 1024 * 256;
		buff = malloc(inner_buffer_size);
		if(NULL==buff)
			return FALSE;
	}
	//thread lock
	if(bThreadLock){
		dkcThreadLock_Lock();
	}
	//Ⴂꍇ
	filesize = dkcFileSize(src);
	for(;;)
	{//non loop 
		if(0 == filesize)
		{//t@CTCYȌꍇ
			dkcCreateEmptyFile(dest);
			break;
		}
		if(filesize < inner_buffer_size)
		{//t@CTCYobt@Ɏ܂Ă܂ꍇB
			if(DKUTIL_FAILED(dkcLoadBinary(buff,filesize,src,&readed)))
			{
				goto Error;
			}
#	ifdef DEBUG
			if(readed != filesize){
				ODS("readed != filesize why?\n");
			}
#	endif
			dkcSaveBinary(buff,filesize,dest);
			break;
		}
		//obt@gȂ΃Rs[łȂꍇB

		srcf = dkcFOpen(src,"rb");
		if(NULL==srcf) goto Error;
		destf = dkcFOpen(dest,"wb");
		if(NULL==destf) goto Error;

		//[v񐔂vZ
		count = filesize / inner_buffer_size;

		for(i=0;i<count;i++){
			dkcmNOT_ASSERT(1 != fread(buff,inner_buffer_size,1,srcf));
			dkcmNOT_ASSERT(1 != fwrite(buff,inner_buffer_size,1,destf));
		}

		rest = filesize - (count * inner_buffer_size);

		//co
		dkcmNOT_ASSERT(rest != fread(buff,1,rest,srcf));
		dkcmNOT_ASSERT(rest != fwrite(buff,1,rest,destf));

		//close
		dkcFClose(&srcf);
		dkcFClose(&destf);

		break;
	}//end of for


	result = TRUE;
Error:
	if(bThreadLock){
		dkcThreadLock_Unlock();
	}
	if(buff){
		free(buff);buff=NULL;
	}
	return result;
}

BOOL WINAPI dkcFileRemove(const char *filename)
{
#ifdef WIN32
	return (0 != DeleteFile(filename));
	//return (0==remove(filename));
#else
	return (0==remove(filename));
#endif
}

BOOL WINAPI dkcFileRename(const char *oldname,const char *newname){
#ifdef WIN32
	return (0==rename(oldname,newname));
#else
	return (0==rename(oldname,newname));
#endif
}


//**********************************************************


#if 0

DKC_FILE_FINDER * WINAPI dkcAllocFileFinder(
			const char *target,const char *dir,BOOL bSubDir
			){

	DKC_FILE_FINDER *p;
	p = dkcAllocate(sizeof(DKC_FILE_FINDER));
	if(NULL==p) return NULL;

	//fBNg
	p->mDir = dkcAllocPathString(dir);//allocate and copy 
	if(NULL==p->mDir){
		goto Error;
	}
	//ċApX^bN
	p->mStack = dkcAllocStack(10,sizeof(DKC_PATHSTRING *));
	if(NULL==p->mStack){
		goto Error;
	}
	//target
	p->mTarget = dkcAllocString(128);
	if(NULL==p->mTarget){
		goto Error;
	}
	//targetRs[
	dkcStringCopy(p->mTarget,target,strlen(target));

	p->mState = edkcFileFinderEmpty;//ĂȂB
	p->mbSubDir = bSubDir;//Tudirectory邩ǂ

	return p;
Error:
	if(p){
		dkcFreeString(&(p->mTarget));
		dkcFreeStack(&(p->mStack));
		dkcFreePathString(&(p->mDir));
	}
	dkcFree(&p);
	return NULL;
}


int WINAPI dkcFreeFileFinder(DKC_FILE_FINDER **p){
	if(NULL==p || NULL==(*p)){
		return edk_ArgumentException;
	}
	dkcFreeString(&(*p)->mTarget);
	dkcFreeStack(&(*p)->mStack);
	dkcFreePathString(&(*p)->mDir);
	return dkcFree(p);
}

static BOOL isDot(DKC_FILE_FINDER *ptr){

#ifdef WIN32
	return (
		strcmp(ptr->mFindData.cFileName,"..") == 0 || 
		strcmp(ptr->mFindData.cFileName,".") == 0
	);
#else
	

#endif

}
static BOOL isFolder(DKC_FILE_FINDER *ptr){
#ifdef WIN32
	return (
			ptr->mFindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY
			&& strcmp(ptr->mFindData.cFileName,"..")!=0 
			&& strcmp(ptr->mFindData.cFileName,".")!=0
			);
#else


#endif
}
static int FFPushStack(DKC_FILE_FINDER *p){
	DKC_PATHSTRING *tp;
	int r;
	char buff[dkcdMAXPATH_BUFFER];

#ifdef WIN32
	
	dkcCurrentDirectoryConcatenate(buff,sizeof(buff),p->mFindData.cFileName);
#else
	dkcCurrentDirectoryConcatenate(buff,sizeof(buff),ptr->mDirent.d_name);
#endif

	tp = dkcAllocPathString(buff);
	if(NULL==tp){
		return edk_FAILED;
	}
	r = dkcStackDynamicPush(p->mStack,tp);
	return r;
}

static BOOL FFIsStackEmpty(DKC_FILE_FINDER *p){
	return dkcStackIsEmpty(p->mStack);
}


static int FFPopStack(DKC_FILE_FINDER *p){
	int r;
	DKC_PATHSTRING *tp;
	r = dkcStackTop(p->mStack,&tp);
	if(DKUTIL_FAILED(r)){return r;}

	dkcFreePathString( &(p->mDir));
	dkcStackPop(p->mStack);
	
	p->mDir = tp;
	return r;
}

static void FFReSearch(DKC_FILE_FINDER *p){
	dkcFindClose(p);
	FFPopStack(p);
	p->mState = edkcFileFinderEmpty;
	DKUTIL_STRUCTURE_INIT(p->mFindData);
}
/*
static int FFEndSearch(DKC_FILE_FINDER *p){

}
*/

///http://www.ne.jp/asahi/oh/landd/prog_html/prog23.html
static int ReflexiveSearch(DKC_FILE_FINDER *p,DKC_PATHSTRING *path,BOOL *bCopySucceeded)
{

}
/*static int FFCheckingLogic(DKC_FILE_FINDER *p,DKC_PATHSTRING *path,BOOL *bCopySucceeded)
{*/
#define FFCHECKING(p,path,bCopySucceeded)\
	if(TRUE==isDot(p))\
	{/*Ȃ̂ᕶ͂ȂȂB*/\
		p->mState = edkcFileFinderSearching;\
		return WithFolderSearch(p,path,bCopySucceeded);\
	}\
	if(TRUE==isFolder(p))\
	{/*HtH_[B*/\
		dkcFileFinderReferenceFileName(p,path);\
		p->mState = edkcFileFinderSearching;\
		FFPushStack(p);/*folderX^bNɋl߂B*/\
		return WithFolderSearch(p,path,bCopySucceeded);\
	}
/*}*/

static int WithFolderSearch(DKC_FILE_FINDER *p,DKC_PATHSTRING *path,BOOL *bCopySucceeded)
{
	int r;
//	DKC_PATHSTRING *pps = NULL;
//	DKC_FILE_FINDER *

	r = 0;
	*bCopySucceeded = FALSE;

	if(edkcFileFinderEmpty == p->mState)
	{//ĂяočŏA
		r = dkcFindFirstFile(p);
		if(DKUTIL_FAILED(r)) return edk_FAILED;
#	ifdef WIN32 //windows̏ꍇ͓Ɋi[Ă饥B
		if(TRUE==isDot(p))
		{//Ȃ̂ᕶ͂ȂȂB
			p->mState = edkcFileFinderSearching;
			return WithFolderSearch(p,path,bCopySucceeded);
		}
		if(TRUE==isFolder(p))
		{//HtH_[B
			dkcFileFinderReferenceFileName(p,path);
			p->mState = edkcFileFinderSearching;
			FFPushStack(p);//folderX^bNɋl߂B
			return WithFolderSearch(p,path,bCopySucceeded);
		}
		//FFCHECKING(p,path,bCopySucceeded)

		r = dkcFileFinderReferenceFileName(p,path);
			
		if(DKUTIL_SUCCEEDED(r)){//Rs[
			*bCopySucceeded = TRUE;
		}
#	endif
		p->mState = edkcFileFinderSearching;
		return r;
	}else if(edkcFileFinderSearching == p->mState)
	{//B
		r = dkcFindNextFile(p);
		if(edk_SUCCEEDED == r)
		{//B
			if(TRUE==isDot(p))
			{//Ȃ̂ᕶ͂ȂȂB
				p->mState = edkcFileFinderSearching;
				return WithFolderSearch(p,path,bCopySucceeded);
			}
			if(TRUE==isFolder(p))
			{//HtH_[B
				dkcFileFinderReferenceFileName(p,path);
				p->mState = edkcFileFinderSearching;
				FFPushStack(p);//folderX^bNɋl߂B
				return WithFolderSearch(p,path,bCopySucceeded);
			}

			r = dkcFileFinderReferenceFileName(p,path);
			
			if(DKUTIL_SUCCEEDED(r)){//Rs[
				*bCopySucceeded = TRUE;
			}/*else{//Rs[sIHH
				*bCopySucceeded = FALSE;
			}*/
		}else if(edk_EndProcess == r)
		{//IB
			if(FALSE==FFIsStackEmpty(p))
			{//ł͂ȂB
				FFReSearch(p);
				return WithFolderSearch(p,path,bCopySucceeded);
			}else{
				dkcFindClose(p);//IiBip->mState = edkcFileFinderFinish;ĂB
			}
		}else{
			dkcmNOT_ASSERT("Ȃ΂ȁ`");
		}
		return r;
	}else if(edkcFileFinderFinish == p->mState)
	{
		return edk_EndProcess;
	}
	dkcmNOT_ASSERT("dkcFileFinderNext̃vOB`[gĂ邩IH");
	return edk_FAILED;

}


static int NormalSearch(DKC_FILE_FINDER *p,DKC_PATHSTRING *path,BOOL *bCopySucceeded)
{
	int r;
	r = 0;
	*bCopySucceeded = FALSE;

	if(edkcFileFinderEmpty == p->mState)
	{//ĂяočŏA
		r = dkcFindFirstFile(p);
		if(DKUTIL_FAILED(r)) return edk_FAILED;
#	ifdef WIN32 //windows̏ꍇ͓Ɋi[Ă饥B
		if(TRUE==isDot(p) || TRUE==isFolder(p))
		{//Ȃ̂ᕶ͂ȂȂB
			p->mState = edkcFileFinderSearching;
			return NormalSearch(p,path,bCopySucceeded);
		}
		r = dkcFileFinderReferenceFileName(p,path);
			
		if(DKUTIL_SUCCEEDED(r)){//Rs[
			*bCopySucceeded = TRUE;
		}
#	endif
		p->mState = edkcFileFinderSearching;
		return r;
	}else if(edkcFileFinderSearching == p->mState)
	{//B
		r = dkcFindNextFile(p);
		if(edk_SUCCEEDED == r)
		{//B
			if(TRUE==isDot(p) || TRUE==isFolder(p))
			{//Ȃ̂ᕶ͂ȂȂB



				//p->mState = edkcFileFinderSearching;
				return NormalSearch(p,path,bCopySucceeded);
			}
			r = dkcFileFinderReferenceFileName(p,path);
			
			if(DKUTIL_SUCCEEDED(r)){//Rs[
				*bCopySucceeded = TRUE;
			}/*else{//Rs[sIHH
				*bCopySucceeded = FALSE;
			}*/
		}else if(edk_EndProcess == r)
		{//IB
			dkcFindClose(p);//IiBip->mState = edkcFileFinderFinish;ĂB
		}else{
			dkcmNOT_ASSERT("Ȃ΂ȁ`");
		}
		return r;
	}else if(edkcFileFinderFinish == p->mState)
	{
		return edk_EndProcess;
	}/*else{
		return edk_FAILED;
	}*/
	dkcmNOT_ASSERT("dkcFileFinderNext̃vOB`[gĂ邩IH");
	return edk_FAILED;

}

/*!
@param ptr[in] dkcAllocFileFinder()Ŏ擾|C^
@return edk_SUCCEEDEDȂdkcFileFinderGetResult()ĂяoėǂB
ȊOȂdkcFreeFileFinder()ŏIȂ΂ȂȂB
*/
int WINAPI dkcFileFinderNext(DKC_FILE_FINDER *p,DKC_PATHSTRING *path,BOOL *bCopySucceeded)
{
	if(FALSE==p->mbSubDir){
		return NormalSearch(p,path,bCopySucceeded);
	}else{//sub directory
		return WithFolderSearch(p,path,bCopySucceeded);
	}
	//return ReflexiveSearch(p,path,bCopySucceeded);
}
#endif

DKC_FINDFILE *WINAPI dkcAllocFindFile()
{
	DKC_FINDFILE *p;
	p = dkcAllocate(sizeof(DKC_FINDFILE));
	return p;
}
int WINAPI dkcFreeFindFile(DKC_FINDFILE **ptr){
	if(NULL==ptr /*|| *ptr==NULL*/){
		return edk_FAILED;
	}
	return dkcFree(ptr);
}


int WINAPI dkcFindFirstFile(DKC_FINDFILE *ptr,const char *target){
#ifdef WIN32
	ptr->mHandle = 
		FindFirstFileA( target, &(ptr->mFindData) );
	if(ptr->mHandle == INVALID_HANDLE_VALUE){
		return edk_FAILED;
	}
#else
	ptr->mHandle = opendir( target );
	if(NULL==ptr->mHandle){
		return edk_FAILED;
	}

#endif
	return edk_SUCCEEDED;
}

int WINAPI dkcFindNextFile(DKC_FINDFILE *ptr){
#	ifdef WIN32
	if ( 0 == FindNextFileA( ptr->mHandle, &(ptr->mFindData) ))
	{
		if ( GetLastError() == ERROR_NO_MORE_FILES )
		{//Ȃ񂾁AB
			return edk_EndProcess;
		}
		else//ň̃p^[
		{
			return edk_FAILED;
		}
	}
#	else
  errno = 0;
	ptr->mDirent = readdir( ptr->mHandle );
  if ( ptr->mDirent == 0 )
  {
    if ( errno == 0 )
    {//OOG
			return edk_EndProcess;
    }
		else//ň̃p^[
		{
			return edk_FAILED;
		}
  }
#	endif
	return edk_SUCCEEDED;
}

int WINAPI dkcFindClose(DKC_FINDFILE *ptr)
{
#ifdef WIN32
	if(INVALID_HANDLE_VALUE == ptr->mHandle){
		return edk_FAILED;
	}
	FindClose(ptr->mHandle);
	ptr->mHandle = INVALID_HANDLE_VALUE;//胊Zbg
#else
	if(0 == ptr->mHandle){
		return edk_FAILED;
	}
	closedir(ptr->mHandle);
	ptr->mHandle = 0;//胊Zbg
	ptr->mDirent = NULL;
#endif

	return edk_SUCCEEDED;

}

int WINAPI dkcFindFileGetFileName(DKC_FINDFILE *ptr,char *buff,size_t buffsize)
{
	int r;
	size_t len;
#ifdef WIN32
	len = strlen(ptr->mFindData.cFileName);
	if(0 == len) return edk_FAILED;
	r = dkc_strcpy(buff,buffsize,ptr->mFindData.cFileName,len);
#else
	if(NULL==ptr->mDirent)
	{//ĂяoԈĂOOG
		return edk_LogicError;
	}
	len = strlen(ptr->mDirent.d_name);
	if(0 == len) return edk_FAILED;
	r = dkc_strcpy(buff,buffsize,ptr->mDirent.d_name,len);
#endif
	return r;
}

BOOL WINAPI dkcFindFileIsFolder(DKC_FINDFILE *ptr){


#ifdef WIN32
	return (
			ptr->mFindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY
			&& strcmp(ptr->mFindData.cFileName,"..")!=0 
			&& strcmp(ptr->mFindData.cFileName,".")!=0
			);
#else


#endif
}


BOOL WINAPI dkcFindFileIsDot(DKC_FINDFILE *ptr){
#ifdef WIN32
	return (
		strcmp(ptr->mFindData.cFileName,"..") == 0 || 
		strcmp(ptr->mFindData.cFileName,".") == 0
	);
#else
	

#endif
}

BOOL WINAPI dkcFindFileIsNormalFile(DKC_FINDFILE *ptr)
{
#ifdef WIN32
	return (ptr->mFindData.dwFileAttributes & FILE_ATTRIBUTE_NORMAL);
#else

#endif
}

BOOL WINAPI dkcFindFileIsReadOnly(DKC_FINDFILE *ptr){
#ifdef WIN32
	return (ptr->mFindData.dwFileAttributes & FILE_ATTRIBUTE_READONLY);
#else

#endif
}
void WINAPI dkcFindFileSize(DKC_FINDFILE *ptr,ULONG *High,ULONG *Low){
#ifdef WIN32
	*High = ptr->mFindData.nFileSizeHigh;
	*Low = ptr->mFindData.nFileSizeLow;
#else

#endif

}
/*
int WINAPI dkcFindFirstFile(DKC_FILE_FINDER *ptr){

#ifdef WIN32
	ptr->mHandle = 
		FindFirstFileA( dkcPathStringPointer(ptr->mDir), &(ptr->mFindData) );
	if(ptr->mHandle == INVALID_HANDLE_VALUE){
		return edk_FAILED;
	}
#else
	ptr->mHandle = opendir( dkcPathStringPointer(ptr->mDir) );
	if(NULL==ptr->mHandle){
		return edk_FAILED;
	}

#endif
	return edk_SUCCEEDED;
}

int WINAPI dkcFindNextFile(DKC_FILE_FINDER *ptr)
{
	if(edkcFileFinderFinish == ptr->mState){
		return edk_LogicError;//ĂяoԈĂiI
	}
#	ifdef WIN32
	if ( 0 == FindNextFileA( ptr->mHandle, &(ptr->mFindData) ))
	{
		if ( GetLastError() == ERROR_NO_MORE_FILES )
		{//Ȃ񂾁AB
			return edk_EndProcess;
		}
		else//ň̃p^[
		{
			return edk_FAILED;
		}
	}
#	else
  errno = 0;
	ptr->mDirent = readdir( ptr->mHandle );
  if ( ptr->mDirent == 0 )
  {
    if ( errno == 0 )
    {//OOG
			return edk_EndProcess;
    }
		else//ň̃p^[
		{
			return edk_FAILED;
		}
  }
#	endif
	return edk_SUCCEEDED;
}

int WINAPI dkcFindClose(DKC_FILE_FINDER *ptr){
#ifdef WIN32
	if(INVALID_HANDLE_VALUE == ptr->mHandle){
		return edk_FAILED;
	}
	FindClose(ptr->mHandle);
	ptr->mHandle = INVALID_HANDLE_VALUE;//胊Zbg
#else
	if(0 == ptr->mHandle){
		return edk_FAILED;
	}
	closedir(ptr->mHandle);
	ptr->mHandle = 0;//胊Zbg
	ptr->mDirent = NULL;
#endif
	//III
	ptr->mState = edkcFileFinderFinish;

	return edk_SUCCEEDED;
}


int WINAPI dkcFileFinderReferenceFileName(DKC_FILE_FINDER *ptr,DKC_PATHSTRING *path)
{
	int r;
	size_t len;
#ifdef WIN32
	len = strlen(ptr->mFindData.cFileName);
	if(0 == len) return edk_FAILED;
	r = dkcPathStringCopy(path,ptr->mFindData.cFileName,len);
#else
	if(NULL==ptr->mDirent)
	{//ĂяoԈĂOOG
		return edk_LogicError;
	}
	len = strlen(ptr->mDirent.d_name);
	if(0 == len) return edk_FAILED;
	r = dkcPathStringCopy(path,ptr->mDirent.d_name,len);
#endif
	return r;
}
*/