/*!
@auther d
@note
licence:BSD Licence
*/

#include <limits.h>
#include "dkcMemoryStream.h"

#include "dkcStdio.h"





DKC_MEMORYSTREAM * WINAPI dkcAllocMemoryStream(size_t size){
	DKC_MEMORYSTREAM *p;
	if(0==size) return NULL;

	p = dkcAllocate(sizeof(DKC_MEMORYSTREAM));

	if(NULL==p) return NULL;
	p->mBuffer = dkcAllocate(size);
	if(NULL==p->mBuffer) goto Error;

	p->mSize = size;
	p->mNowOffset = 0;
	return p;
Error:
	dkcFree(&p);
	return NULL;

}


int WINAPI dkcFreeMemoryStream(DKC_MEMORYSTREAM **ptr){
	if(NULL==ptr || NULL==*ptr) return edk_ArgumentException;
	if(NULL==(*ptr)->mBuffer) return edk_FAILED;

	dkcFree(&((*ptr)->mBuffer));
	return dkcFree(ptr);
}




static int WINAPI dkcMemoryStreamSeekLogic(DKC_MEMORYSTREAM *ptr,int offset,int point,int origin){
	/*
	ԑ@ہF
	offset + succeeded
	offset - succeeded
	offset + length error
	offset - length error
	*/
	size_t change = (size_t)(point + offset);


	//if(!(ptr->mSize > change)){
	if(!(ptr->mSize >= change)){
		return edk_FAILED;
	}

	//common...

	ptr->mNowOffset = change;
		

	return edk_SUCCEEDED;
}

int WINAPI dkcMemoryStreamSeek(DKC_MEMORYSTREAM *ptr,int offset,int origin){
	int result = edk_FAILED;
	if(NULL==ptr) return edk_ArgumentException;
	switch(origin)
	{
	case edkcMemoryStreamSeekCurrent://̈ʒuV[N
		result = dkcMemoryStreamSeekLogic(ptr,offset,ptr->mNowOffset,origin);
		break;
	case edkcMemoryStreamSeekEnd://Ō̈ʒuV[N
		result = dkcMemoryStreamSeekLogic(ptr,offset,0,origin);
		break;
	case edkcMemoryStreamSeekSet://ŏ̈ʒuV[N
		result = dkcMemoryStreamSeekLogic(ptr,offset,ptr->mSize /*- 1*/,origin);
		break;
	default:
		//ςȈȁI
		return edk_ArgumentException;
	}
	return result;
}

size_t WINAPI dkcMemoryStreamGetSeekPoint(DKC_MEMORYSTREAM *ptr)
{
	return ptr->mNowOffset;
}

int WINAPI dkcMemoryStreamRead(DKC_MEMORYSTREAM *ptr,void *buffer,size_t size,size_t *readsize){

	
	size_t f_read = 0;
	//error check

	if(NULL==ptr || NULL==readsize) return edk_ArgumentException;

	//Read = (int)(ptr->mNowOffset + size); 
	//Read = (int)(ptr->mSize - Read); 
	//if(Read < 0) return edk_BufferOverFlow;
	
	//process...

	f_read = ptr->mNowOffset + size;

	if(ptr->mSize <= f_read){
		f_read = ptr->mSize - ptr->mNowOffset;
		if(0==f_read) return edk_BufferOverFlow;
	}else{
		f_read = size;
	}



	dkcmNOT_ASSERT(edk_FAILED==dkc_memcpy(buffer,size,
		ptr->mBuffer + ptr->mNowOffset,f_read
	));
	

	//update...
	ptr->mNowOffset += f_read;
	*readsize = f_read;
	
	return edk_SUCCEEDED;
}


int WINAPI dkcMemoryStreamResize(DKC_MEMORYSTREAM *ptr,size_t want_size)
{
	int ra_r = 0;
	void *NewPtr = NULL;
	void *OldPtr = NULL;
	
	//error check
	if(NULL==ptr) return edk_ArgumentException;


	//process
	OldPtr = ptr->mBuffer;

	ra_r = dkcReallocate(&NewPtr,want_size,&OldPtr);
	if(DKUTIL_FAILED(ra_r)){
		return edk_FAILED;
	}

	//update...
	ptr->mBuffer = NewPtr;
	ptr->mSize = want_size;


	return edk_SUCCEEDED;
}

/*!
@param ptr[in] Mς݂DKC_MEMORYSTREAMւ̃|C^
@param expand_size[in] ]gTCY
*/
static int WINAPI dkcMemoryStreamAutoExpandResize(DKC_MEMORYSTREAM *ptr,size_t expand_size){
	int ra_r = 0;
	void *NewPtr = NULL;
	void *OldPtr = NULL;
	size_t ReallocatedSize = 0;
	size_t want_size;
	//size_t want_size = ptr->mSize + expand_size + 1;//ȂƂȂ{P
	
	if(NULL==ptr) return edk_ArgumentException;

	OldPtr = ptr->mBuffer;
	/*
	ra_r = dkcReallocateAutoExpand(realloc,&NewPtr,&OldPtr,ptr->mSize,&ReallocatedSize);
	if(DKUTIL_FAILED(ra_r)){
		return edk_FAILED;
	}
	if(want_size > ReallocatedSize){
		OldPtr = NewPtr;
		ra_r = dkcReallocate(&NewPtr,want_size,&OldPtr);
		if(DKUTIL_FAILED(ra_r)){
			return edk_FAILED;
		}
		ReallocatedSize = want_size;
	}
	*/
	want_size = dkcReallocateSizeFunction(
		ptr->mSize + ptr->mNowOffset,
		(expand_size <= 256) ? 256 : expand_size
	);
	ra_r = dkcReallocate(&NewPtr,want_size,&OldPtr);
	if(DKUTIL_FAILED(ra_r)){
		return edk_FAILED;
	}
	ReallocatedSize = want_size;



	ptr->mBuffer = NewPtr;
	ptr->mSize = ReallocatedSize;


	return edk_SUCCEEDED;

}

int WINAPI dkcMemoryStreamWrite(DKC_MEMORYSTREAM *ptr,const void *buffer,size_t size){
	size_t rest;

	if(NULL==ptr) return edk_ArgumentException;
	

	if(ptr->mSize < ptr->mNowOffset + size){return edk_FAILED;}
	rest = ptr->mSize - ptr->mNowOffset;
	
	dkcmNOT_ASSERT(DKUTIL_FAILED(dkc_memcpy(
		(void *)((BYTE *)ptr->mBuffer + ptr->mNowOffset),
		rest,
		buffer,size)
	));
	
	ptr->mNowOffset += size;
	
	return edk_SUCCEEDED;
}


int WINAPI dkcMemoryStreamDynamicWrite(DKC_MEMORYSTREAM *ptr,const void *buffer,size_t size){
	int result;
	size_t want_size;

	if(NULL==ptr) return edk_ArgumentException;

	want_size =  ptr->mNowOffset + size;

	if(ptr->mSize < want_size)
	{
		result = dkcMemoryStreamAutoExpandResize(ptr,size);
		//result = dkcMemoryStreamResize(ptr,want_size);
		if(DKUTIL_FAILED(result)) return edk_FAILED;
	}

	return dkcMemoryStreamWrite(ptr,buffer,size);
}









int WINAPI dkcMemoryStreamClear(DKC_MEMORYSTREAM *ptr){
	dkcmNOT_ASSERT(NULL==ptr);
	//if(NULL==ptr) return edk_ArgumentException;
	memset(ptr->mBuffer,0,ptr->mSize);
	ptr->mNowOffset = 0;
	return edk_SUCCEEDED;
}


DKC_MEMORYSTREAM * WINAPI dkcAllocMemoryStreamCopy(const DKC_MEMORYSTREAM *ptr)
{
	DKC_MEMORYSTREAM *tp = NULL;

	dkcmNOT_ASSERT(NULL==ptr);

	tp = dkcAllocMemoryStream(ptr->mSize);
	if(NULL==tp) return NULL;

	dkcMemoryStreamWrite(tp,ptr->mBuffer,ptr->mSize);

	//ItZbgύX									/* 擪 */
	dkcMemoryStreamSeek(tp,ptr->mNowOffset,edkcMemoryStreamSeekSet);
	return tp;
}



//DKC_SERIALIZEVMemoryStreamB
DKC_MEMORYSTREAM * WINAPI dkcAllocMemoryStreamDeserialize(DKC_DESERIALIZE *se)
{
	DKC_MEMORYSTREAM *p;
	DKC_MEMORYSTREAM t;
	size_t read;
	//dkcmNOT_ASSERT(NULL==se);
	

	dkcDeserializeRead(se,&t,sizeof(t),&read);
	
	p = dkcAllocMemoryStream(t.mSize);
	if(NULL==p) return NULL;

	/* VACYf[^ƓɂȂƁOOG */

	dkcDeserializeRead(se,p->mBuffer,t.mSize,&read);
	
	dkcmNOT_ASSERT(read != t.mSize);

	
	p->mNowOffset = t.mNowOffset;
	
	return p;
}


///DKC_SERIALIZEɃVACYf[^Ԃ
void dkcMemoryStreamSerialize(const DKC_MEMORYSTREAM *ptr,DKC_SERIALIZE *se)
{
	dkcmNOT_ASSERT(NULL==ptr);

	dkcSerializeWrite(se,ptr,sizeof(*ptr));
	dkcSerializeWrite(se,ptr->mBuffer,ptr->mSize);

}
