#ifndef _dkutil_SusieManager__h__
#define _dkutil_SusieManager__h__


#ifdef USE_DKINGYO_INCLUDE_SETTING_LIKE_BOOST
#include <dkutil/dkutilDLLmanager.h>
#else
#include "../dkutilDLLManager.h"
#endif

namespace dkutil{
	

class SusieManager{
public:
	///摜
	struct PictureInfo
	{
		long left,top;			/* 摜WJʒu */
		long width;				/* 摜̕(pixel) */
		long height;			/* 摜̍(pixel) */
		WORD x_density;			/* f̐x */
		WORD y_density;			/* f̐x */
		short colorDepth;		/* fbit */
		HLOCAL hInfo;			/* 摜̃eLXg[Ăяo] */
	};
	///t@C
	struct fileInfo
	{
		unsigned char method[8];	/* k@̎ */
		unsigned long position;		/* t@Cł̈ʒu */
		unsigned long compsize;		/* kꂽTCY */
		unsigned long filesize;		/* ̃t@CTCY */
		time_t timestamp;			/* t@C̍XV */
		char path[200];				/* ΃pX */
		char filename[200];			/* t@Cl[ */
		unsigned long crc;			/* CRC */
	} ;

	///Plug-in̐ݒ_CAOp
	enum SusieConfigDialogParam{
		SUSIE_CONFIGDLG_ABOUT= 0,
		SUSIE_CONFIGDLG_SETTING,
		SUSIE_CONFIGDLG_RESERVED
	};

	// Common
	typedef int (PASCAL *GetPluginInfoType)(int, LPSTR ,int );
	typedef int (PASCAL *IsSupportedType) (LPSTR,DWORD);


	// '00IN'̊֐ 
	typedef int (PASCAL *GetPictureInfoType) (LPSTR ,long ,unsigned int , PictureInfo *);
	typedef int (PASCAL *GetPictureType) (LPSTR ,long ,unsigned int , HANDLE *,HANDLE *,
									FARPROC ,long );
	typedef int (PASCAL *GetPreviewType) (LPSTR ,long ,unsigned int , HANDLE *,HANDLE *,
									FARPROC ,long );

	// '00AM'̊֐ 
	typedef int  (PASCAL *GetArchiveInfoType) (LPSTR buf, long len, unsigned int flag, HLOCAL *lphInf);
	typedef int  (PASCAL *GetFileInfoType) (LPSTR buf,long len, LPSTR filename, unsigned int flag, fileInfo *lpInfo);
	typedef int  (PASCAL *GetFileType) (LPSTR src,long len, LPSTR dest,unsigned int flag, FARPROC prgressCallback,long lData);

	typedef int  (PASCAL *ConfigurationDlgType)(HWND parent,int fnc);

	///@return Import Filter  true
	bool isImportFilter(){
		check_instance();
		return (mPluginInfo[2] == 'I' || mPluginInfo[2] == 'i');
	}
	///@return Export Filter  true
	bool isExportFilter(){
		check_instance();
		return (mPluginInfo[2] == 'X' || mPluginInfo[2] == 'x');
	}
	///@return Archive Extractor  true
	bool isArchiveExtractor(){
		check_instance();
		return (mPluginInfo[2] == 'A' || mPluginInfo[2] == 'a');
	}
	///@return tB^[Ȃ true
	bool isUnknownFilter(){
		return (!isImportFilter() && !isExportFilter() && !isArchiveExtractor());
	}
	bool isNormal(){
		check_instance();
		return (mPluginInfo[3] == 'N' || mPluginInfo[3] == 'n');
	}
	bool isMultiPicture(){
		check_instance();
		return (mPluginInfo[3] == 'M' || mPluginInfo[3] == 'm');
	}
	///@return 00IN^Cv true
	bool isIN(){	return (isNormal() && isImportFilter());}
	///@return 00AM^Cv true
	bool isAM(){	return (isMultiPicture() && isArchiveExtractor());}
	///@return char[2]𖳗shortɕϊ̂ԂB
	short GetVersionForceShort(){
		check_instance();
		short *tmp = (short *)&mPluginInfo[0];
		return (*tmp);
	}
	///@return char[2]atoi()̂ԂB
	short GetVersion(){
		check_instance();
		char buff[3]="";
		strncpy(buff,mPluginInfo,2);
		return atoi(buff);
	}
	/*!
	@param buff[out] obt@ւ̃|C^
	@param size[in] obt@̃TCY
	@return trueȂ琬
	*/
	bool GetVersionStr(char *buff,size_t size){
		check_instance();
		if(size < 2) return false;
		buff[0] = mPluginInfo[0];
		buff[1] = mPluginInfo[1];
		return true;
	}

protected:
#	define DKUTIL_CAST_SUSIE(v,f) v exe = (v)mDLL.find(f);\
	if(exe==NULL)return -1

	// Common Function 
	int  GetPluginInfo (int infono, LPSTR buf,int buflen){
		check_instance();
		DKUTIL_CAST_SUSIE(GetPluginInfoType,"GetPluginInfo");
		return exe(infono,buf,buflen);
	}

	int  IsSupported (LPSTR filename,DWORD dw){
		check_instance();
		DKUTIL_CAST_SUSIE(IsSupportedType,"IsSupported");
		return exe(filename,dw);
	}


	//'00IN'̊֐ 
	int  GetPictureInfo (LPSTR buf,long len,unsigned int flag, PictureInfo *lpInfo){
		check_instance();
		DKUTIL_CAST_SUSIE(GetPictureInfoType,"GetPictureInfo");
		return exe(buf,len,flag,lpInfo);
	}
	/*
	ʓ|͊eŎIi
	int  GetPicture (LPSTR buf,long len,unsigned int flag, HANDLE *pHBInfo,HANDLE *pHBm,
									FARPROC lpPrgressCallback,long lData);
	int  GetPreview (LPSTR buf,long len,unsigned int flag, HANDLE *pHBInfo,HANDLE *pHBm,
									FARPROC lpPrgressCallback,long lData);

	// '00AM'̊֐ 
	int  GetArchiveInfo (LPSTR buf, long len, unsigned int flag, HLOCAL *lphInf);
	int  GetFileInfo (LPSTR buf,long len, LPSTR filename, unsigned int flag, fileInfo *lpInfo);
	int  GetFile (LPSTR src,long len, LPSTR dest,unsigned int flag, FARPROC prgressCallback,long lData);

	int  ConfigurationDlg(HWND parent,int fnc);
	*/

protected:


private:
	static int	PASCAL	DummyCallback__( int , int, long )
	{
		return( 0 );		// always continue
	}

	void check_instance(){
		DK_TRUE_ASSERT_OR_THROW(
			mDLL.empty(),
			std::logic_error("not loaded susie plugin")
		);
	}
	DLLManager mDLL;
	///]ȃobt@邪A͈Ŝ߁B
	char mPluginInfo[4 + 5];
	int LoadSusie(){
		//load common
		
		GetPluginInfoType Info =
			(GetPluginInfoType ) mDLL.find("GetPluginInfo");
		if(Info == NULL ) return edk_FAILED;
		NULL_CHAR_ARRAY(mPluginInfo);

		
		mDLL.load_function("IsSupported");
		mDLL.load_function("ConfigurationDlg");
		
		//ǂݍ݂܂B((._.) yR
		mDLL.load_function("GetPictureInfo");
		mDLL.load_function("GetPicture");
		mDLL.load_function("GetPreview");
		mDLL.load_function("GetArchiveInfo");
		mDLL.load_function("GetFileInfo");
		mDLL.load_function("GetFile");

		//Plug-in APIo[W Qbg
		Info(0,mPluginInfo,5);
		//unknown filter
		if(isUnknownFilter()) return edk_FAILED;
		/*
		//ւ̃[h@JiB
		if(isImportFilter())
		{
			mDLL.load("GetPictureInfo");
			mDLL.load("GetPicture");
			mDLL.load("GetPreview");
		}else if(isExportFilter()){
			mDLL.load("GetPictureInfo");
			mDLL.load("GetPicture");
			mDLL.load("GetPreview");
		}else if(isArchiveExtractor()){
			mDLL.load("GetArchiveInfo");
			mDLL.load("GetFileInfo");
			mDLL.load("GetFile");
		}
		*/
		return edk_SUCCEEDED;
	}

/*
//֐  
GetPluginInfo Plug-inɊւ𓾂 
IsSupported WJ\(ΉĂ)t@C`ׂ 
GetPictureInfo 摜t@CɊւ𓾂 
GetPicture 摜WJ 
GetPreview vr[EJ^O\p摜kWJ[eB 
ConfigurationDlg Plug-inݒ_CAO\ 



00AM Plug-in ֐  
GetPluginInfo Plug-inɊւ𓾂 
IsSupported WJ\(ΉĂ)t@C`ׂ 
GetArchiveInfo A[JCûׂẴt@C̏擾 
GetFileInfo A[JCu̎w肵t@C̏擾 
GetFile A[JCũt@C擾 
ConfigurationDlg Plug-inݒ_CAO\ 

*/
	

public:
	SusieManager(const char *plugin_name=NULL){
		NULL_CHAR_ARRAY(mPluginInfo);
		if(plugin_name){
			reset(plugin_name);
		}
	}
	virtual ~SusieManager(){}

	bool reset(const char *plugin_name){
		if(!plugin_name) return false;
		//ɂ邩Ȃ炱łII
		//if(false==FileExist(plugin_name)) return false;
		mDLL.reset(plugin_name);
		return DKUTIL_SUCCEEDED(LoadSusie());
	}
	bool empty(){return mDLL.empty();}

};





}//end of dkutil namespace




#endif