#ifndef _dkutilMathEx__
#define _dkutilMathEx__

namespace dkutil{
#ifdef USE_DKINGYO_SINTABLESIZE_256
#	define DKINGYO_SINTABLESIZE 256
#else
#	define DKINGYO_SINTABLESIZE 360
#endif
#define DKINGYO_SINTABLEMASK		255//(DKINGYO_SINTABLESIZE - 1)
/// Multiplier for degrees to radians
#define DKINGYO_DTOR    0.0174532925199432957692369077
/// Multiplier for radians to degrees
#define DKINGYO_RTOD    57.295779513082320876798154814

//#define DKINGYO_DTOR_FLOAT 0.01745329f
//#define DKINGYO_RTOD_FLOAT 57.2957795f

/*!
dgȐwWbNW߂́B
̕ϐstaticȂ̂ł錾Ă͈ȂƎvB<br>
<br>
<b>ŋߒm@̗ԈĂ邩Ȃ@wp</b>
<br>
degreeFł[Fʂ0360x̊px̒PʁH@wZŋĂ<br>
radianF炶Fɂ͂܂킩ȂpxP degreeȊpx *  / 180 ŎZo<br>
<br>
āAbł͂ςhWAh΂g^^;w̎͒˘fI<br>
̃NX͎₷悤Degreêɔɓs悭łĂ肷^^;<br>
*/



class TrigonometricFunction{
protected:
	static float    sintable[DKINGYO_SINTABLESIZE];

public:
	TrigonometricFunction(){
		static bool re=triginit();
	}
	virtual ~TrigonometricFunction()
	{}
#ifdef USE_DKINGYO_SINTABLESIZE_256
	bool triginit(void)
	{
			double  theta;
			for (int i = 0; i < DKINGYO_SINTABLESIZE; ++i)
			{
					theta = (double)i/((float)DKINGYO_SINTABLESIZE / (2.0f * getPAI()));
					sintable[i] = (float)sin(theta);
			}
			return true;
	}
	///@param theta[in] WAPʂ̊px
	inline float    fsin(float theta)
	{
		int angle = get360to256(RadianToDegree(theta));
		return sintable[angle & DKINGYO_SINTABLEMASK];
	
	}
	///@param theta[in] WAPʂ̊px
	inline float    fcos(float theta)
	{
		int angle = get360to256(RadianToDegree(theta));
		return sintable[(angle+(DKINGYO_SINTABLESIZE>>2)) & DKINGYO_SINTABLEMASK];
	}
	/*!
	@param angle[in] degreeȊpx
	@return sinl
	*/
	inline float AngleToCos( int angle ){
		//angle = get360to256(angle);
		//int a=(angle+(SINTABLESIZE>>2)) & SINTABLEMASK;
		//if(a>254) MB("ERROR");
		return sintable[(get360to256(angle)+(DKINGYO_SINTABLESIZE>>2)) & DKINGYO_SINTABLEMASK];
	}
	///@param angle[in] dgreeȊpx @return cosl
	inline float AngleToSin( int angle ){ return sintable[get360to256(angle)];}

#	else //360x^

	bool triginit(void)
	{
			for (int i = 0; i < DKINGYO_SINTABLESIZE; ++i)
			{
				sintable[i] = (float)::sin(DKINGYO_DTOR * i);
			}
			return true;
	}
	///@param theta[in] WAPʂ̊px
	inline float    fsin(float theta)
	{
		unsigned int angle = DKINGYO_RTOD * theta;
		return sintable[angle];
	
	}
	///@param theta[in] WAPʂ̊px
	inline float    fcos(float theta)
	{
		unsigned int angle = DKINGYO_RTOD * theta;
		//360xPʂƁAfɂ邵Ȃ̂˥
		if(angle < 90){angle + DKINGYO_SINTABLESIZE;}
		return sintable[angle - 90];
		//return sintable[(angle + (DKINGYO_SINTABLESIZE>>2)) ];
	}
	/*!
	@param angle[in] degreeȊpx
	@return sinl
	*/
	inline float AngleToCos( int angle ){
		return sintable[(angle < 90) ? angle + DKINGYO_SINTABLESIZE : angle ];
	}
	///@param angle[in] dgreeȊpx @return cosl
	inline float AngleToSin( int angle ){ return sintable[angle];}

#endif


	///360xPʂ256xPʂɒĂ
	inline int get360to256( int angle )
	{
		return ((angle * 256 ) / 360);
	}



	///fBO[ȊpxHWAȊpxɂĂIH
	inline double DegreeToRadian(int angle){	return angle * DKINGYO_DTOR;}
	//inline float DegreeToRadian(int angle){	return angle * getPAI() / 180;}
	///WAȊpxHfBO[ȊpxɂĂIH
	inline int RadianToDegree(double radian){ return (int)(radian * DKINGYO_RTOD);}
	//inline int RadianToDegree(float radian){ return (int)(radian * 180 / getPAI());}

	///@return float^̃΂Qbg
	inline float getPAI(){return 3.14159265f;}
	///@return double^̃΂Qbg
	inline double getDoublePAI(){return 3.1415926535897932f;}	
	///AngleToCosAngleToSin𗼕ẮB
	inline void SinCos( long angle, float *pSin, float *pCos ){
		*pSin = AngleToSin(angle);
		*pCos = AngleToCos(angle);
	}

};








}//end of dkutil namespace


#endif