


#ifndef __dkutil_Math__ // include once
#define __dkutil_Math__

#include <dkutil/dKingyoMacro.h>

#define MINMAX_SWAP(type,min,max) if(min>max){type temp=min;min=max;max=temp;/*min^=max^=min^=max;*/}
#define MINMAX_ABS(min,max) if(min<0){min=abs(min);}if(max<0){max=abs(max);}
#define MINMAX_SAFETY(min,max) if(min == max){max++;}

#define MINMAX_SWAP_FLOAT(type,min,max) if(min>max){type t=min;min=max;max=t;}
#define MINMAX_ABS_FLOAT(type,min,max) if(min<0){min=(type)fabs(min);}if(max<0){max=(type)fabs(max);}

#ifndef PI
#define PI 3.14159265f
#define DKUTIL_PI_SETED
#endif

namespace dkutil{//begin dkutil namespace
	namespace oldmath{//begin math namespace
/*!
<br>
A Arithimetic Series<br>
@param array [out] = z̃|C^
@param num [in] = z̐
@param a [in] = 
@param d [in] = 
@return Ō̔z̒g
*/
extern int CreateArthimeticProgression(int *array,DWORD num,int a,int d);

/*!
䐔<br>
A Geometric Series<br>
Ăvcev[gɂΗǂ()<br>
a悤Ȃ̂폜BǂgȂB֘AĂVъ֐c<br>
@param array [out] = z̃|C^
@param num [in] = z̐
@param a [in] = 
@param r [in] = 
@return Ō̔z̒g
*/
extern int CreateGeometricProgression(int *array,DWORD num,int a,int r);
	
/*!

A Random Number Series<br>
ǂNgȂƎv쐬⏕<br>
̍minEmaxcĂmin<=x<=max܂łԂ֐̃|C^ԂށB<br>
@param  array [out] = z̃|C^
@param num [in] = z̐
@param min [in] = ̍ŏl
@param max [in] = ̍ől
@param rand_func_callback[in] = _ψԂ֐B
@return Ō̔z̒g
*/
extern int CreateRandomNumberProgression(
		int *array,
		DWORD num,
		int min,int max,
		int (*rand_func_callback)(int min_,int max_));

///̂QWpx߂B
///Ȃ݂256xƂUSHORT_MAXxƂ͎ZołȂƎv܂B
extern short GetAngle(int mx,int my,int sx,int sy);

#ifdef _MSC_VER
extern ULONGLONG __fastcall GetRDTSC();
#else
extern ULONGLONG GetRDTSC();
#endif

//#ifndef USE_DKINGYO_FOX_1_1
#if _MSC_VER >= 1000
#	pragma warning(disable:4244)
#	pragma warning(disable:4305)
#endif
/*!
@note
	oTF񔽓c F KittyGW

  sin - eC[WJߎɂTClԂ
  
  F
    float f pxiWAj
  
  ߂lF
    float TCl


@param angle of radian
@return sine number
@note
      eC[WJAsin
      sin(x)  x - (1 /    6) * x^3 + (1 /    120) * x^5
                  - (1 / 5040) * x^7 + (1 / 362880) * x^9
      
      ̋ߎ̗LȔ͈͂́A- <= r <= ΂ł邽߁A
      l̒s
*/
DINLINE float sin(float f)
{

    
    // ܂Af-΁`΂͈̔͂ɏC
    int i;
    if (f > PI)
		{
        i  = f / (2.0f * PI);
        f -= i * 2.0f * PI;
        if (f > PI) f -= 2.0f * PI;

    }else if (f < -PI)
		{
        i  = f / (2.0f * PI);
        f -= i * 2.0f * PI;
        if (f < -PI) f += 2.0f * PI;
    }
    
    float ftemp, f2 = f * f;
    float ret;
    
    ret    = f;
    ftemp  = f2 * f; // f^3
    ret   -= (1.0f /      6.0f) * ftemp;
    ftemp *= f2;     // f^5
    ret   += (1.0f /    120.0f) * ftemp;
    ftemp *= f2;     // f^7
    ret   -= (1.0f /   5040.0f) * ftemp;
    ftemp *= f2;     // f^9
    ret   += (1.0f / 362880.0f) * ftemp;
    
    return ret;
}

/*!
@note
	oTF񔽓c F KittyGW

  cos - eC[WJߎɂRTClԂ
  
  F
    float f pxiWAj
  
  ߂lF
    float RTCl

@param f angle of radian
@return cosine number
*/
DINLINE float cos(float f)
{
    /*
      eC[WJAcos
      cos(x)  1 - (1 /   2) * x^2 + (1 /    24) * x^4
                  - (1 / 720) * x^6 + (1 / 40320) * x^8
      
      ̋ߎ̗LȔ͈͂́A- <= r <= ΂ł邽߁A
      l̒s
    */
    
    // ܂Af-΁`΂͈̔͂ɏC
    if (f < 0.0f) f *= -1.0f;
    int i = f / (2.0f * PI);
    f -= i * 2.0f * PI;
    if (f > PI) f -= 2.0f * PI;
    
    float ftemp, f2 = f * f;
    float ret;
    
    ret    = 1.0f;
    ftemp  = f2; // f^2
    ret   -= (1.0f /     2.0f) * ftemp;
    ftemp *= f2; // f^4
    ret   += (1.0f /    24.0f) * ftemp;
    ftemp *= f2; // f^6
    ret   -= (1.0f /   720.0f) * ftemp;
    ftemp *= f2; // f^8
    ret   += (1.0f / 40320.0f) * ftemp;

    return ret;
}

/*!
@note
	oTF񔽓c F KittyGW

  asin - eC[WJߎɂA[NTClԂ
         덷傫̂ŁAgp߂łȂ
  
  F
    float f TCl
  
  ߂lF
    float pxiWAj
@param f sine number
@return angle of radian
@note
eC[WJAsin-1<br>
      sin-1(x)  x + (1 /   6) * x^3 + ( 3 /   40) * x^5<br>
                    + (5 / 112) * x^7 + (35 / 1152) * x^9<br>
*/
DINLINE float asin(float f)
{
    /*
     
    */
    //assert(!"called KM_Basic::asin!!");
    
    float ftemp, f2 = f * f;
    float ret;
    
    ret    = f;
    ftemp  = f2 * f; // f^3
    ret   += ( 1.0f /    6.0f) * ftemp;
    ftemp *= f2;     // f^5
    ret   -= ( 3.0f /   40.0f) * ftemp;
    ftemp *= f2;     // f^7
    ret   += ( 5.0f /  112.0f) * ftemp;
    ftemp *= f2;     // f^9
    ret   += (35.0f / 1152.0f) * ftemp;

    return ret;
}

/*!
@note
	oTF񔽓c F KittyGW

  acos - eC[WJߎɂA[NRTClԂ
         덷傫̂ŁAgp߂łȂ
  
  F
    float f RTCl
  
  ߂lF
    float pxiWAj
@param f cosine number
@return angle of radian
@note
eC[WJAcos-1<br>
      cos-1(x)  (1 / 2) -               x   - (1 /   6) * x^3<br>
                            - ( 3 /   40) * x^5 - (5 / 112) * x^7<br>
                            - (35 / 1152) * x^9<br>
*/
DINLINE float acos(float f)
{
    /*
      
    */
    //assert(!"called KM_Basic::acos!!");
    
    float ftemp, f2 = f * f;
    float ret;
    
    ret    = ( 1.0f /    2.0f) * PI - f;
    ftemp  = f2 * f; // f^3
    ret   -= ( 1.0f /    6.0f) * ftemp;
    ftemp *= f2;     // f^5
    ret   -= ( 3.0f /   40.0f) * ftemp;
    ftemp *= f2;     // f^7
    ret   -= ( 5.0f /  112.0f) * ftemp;
    ftemp *= f2;     // f^9
    ret   -= (35.0f / 1152.0f) * ftemp;
    
    return ret;
}

/*!
@note
	oTF񔽓c F KittyGW

  sqrtf - float^̕߂
          sqrtfloato[W
            {[hׂ̺߲ɂ́AȂ悤Ȃ̂Ŏō쐬

@F
@@float f ߂lA̒l̓_

@߂lF
@@float Afꍇ-1Ԃ
@param f ߂lA̒l͂mf
@return  fꍇ-1Ԃ
@note
<PRE>
̕s = x́Af(s) = s^2 - x = 0Newton@ŉ
ċ߂B

f(s)  = s^2 - x
f'(s) = 2s


xn+1  = xn - f(xn) / f'(xn)

ɑāA
xn+1  = (x / s + s) / 2

Newton@ɂāAڂ͐w̖{łǂłˁ
</PRE>
*/

//#ifndef _DKUTIL_MSVC6LINKER_POLICY_H_
DINLINE float sqrtf(float f){

    float s, last;
    
    if (f > 1e-10){
        if (f > 1.0f) s = f;
        else s = 1.0f;
        
        do{
            last = s;
            s    = (f / s + s) * 0.5;
        }while (s < last);
        
        return last;
    }
    
    if (f < 0.0f) return -1.0f;
    
    return 0.0f;
}
//#endif
#if _MSC_VER >= 1000
#	pragma warning(default:4244)
#	pragma warning(default:4305)
#endif







/*!
Ql
<ul>
<li>http://www.bio.nagoya-u.ac.jp:8001/~shionyu/CompJHP/ex/ex4-4prog.html
<li>http://www.bio.nagoya-u.ac.jp:8001/~shionyu/CompJHP/func.html
<li>http://www.d4.dion.ne.jp/~sekiya_z/na/na16mon1.html
<li>http://www.geocities.co.jp/HeartLand-Asagao/6686/statistic.html
<li>http://www.bb.wakwak.com/~bird/private/reseach/analysis.html
<li>http://www.wombat.zaq.ne.jp/nao/c/
<li>http://chiharu.cside4.jp/elearn/stat2002/INDEX.HTM
</ul>
	@Note
JC敪z̃p[Zg_߂B
2@=@ (ny|dyjQ^dy{(ng|dgjQ^dg.
2@=@ (ni|dijQ^di
댯Pɉɂ̓JC̒lU.URȏォ𒲂ׂ΂悢B

dHA
܂AiKȂ̂ŎgȂł```
*/
///JC挟炵
extern double kai2(double o1,double o2,double e1,double e2);
extern float kai2(float o1,float o2,float e1,float e2);


}//end of math namespace
}//end of dkutil namespace


#ifdef DKUTIL_PI_SETED
#undef PI
#endif

#endif//end of include once