

#ifndef _dKingyoRandom__
#define _dKingyoRandom__

//#include <dkutil/dkutilBuffer.h>
#include "dkutilMath.h"
#include "dKingyoRandom_MT_SSE2.h"
#include "dKingyoRandom_MT_MMXASM.h"



namespace dkutil{//begin dkutil namespace
	namespace oldmath{//begin math namespace

template<typename SEED>
inline int arg_rand(SEED *seed)
{
    (*seed) = (*seed) * 1103515245L + 12345;
    return (unsigned)((*seed) / 65536L) % 32768U;
}
inline int arg_random(ULONG *seed,ULONG Max){
	return arg_rand<ULONG>(seed) * Max / SHRT_MAX;
}


template<typename T>
class dKingyoRandom_ANSI : public dKingyoRandom_BasicMember<T>{
public:
	dKingyoRandom_ANSI(T seed=timeGetTime())
	{		
		m_Max = 32767;//(RAMD_MAX)
		if(seed<0){seed = -seed;}
		 m_ulSeed = m_Seed =seed;

	}
	virtual ~dKingyoRandom_ANSI(){
#ifdef _DEBUG
		//ODS("Ă΂ꂽ");
#endif
	}
	virtual T Rand(){
		//m_Seed = m_Seed * 1103515245L + 12345;
		//return (unsigned)(m_Seed / 65536L) % 32768U;
		return arg_rand(&m_ulSeed);
	}
	///domain܂ł͈̔͂Ԃ 0 <= x <= domain @param domain[in] _ɂ͈
	virtual T Random(T domain){
		return Rand() * (++domain) / m_Max;
	}
	/// min<= x <=max܂ŕԂ @param min[in] minl @param max[in] maxl
	virtual T RandomDomain(T min,T max){

		//return max += Random(max + min);
		//return max-=Random(max-min);
		//return (max-min)*Rand()+min;
		{//ȂB܂Ȃ炱őp
			//http://members.tripod.co.jp/cprogram/various1.html
			//min<= x <=max܂ŕԂ
			float fNum, fDenom;

			fNum   = (float)Rand() * ( (float)max - (float)min + 1.0f );
			fDenom = (float)RAND_MAX + 1.0f;

			return min + (int)( fNum / fDenom );
		}

	}
	///minlmaxlԈĂOKȂ
	virtual T RandomDomainSafety(T min,T max){
		MINMAX_SWAP(T,min,max);
		MINMAX_ABS(min,max);
		MINMAX_SAFETY(min,max);
		return RandomDomain(min,max);
	}
	
	
	
};
template<class T>
class dKingyoRandom_Float : public dKingyoRandom_BasicMember<T>{
public:
	dKingyoRandom_Float(T seed = timeGetTime()){
		m_Max=32767;
		seed = (float)fabs(seed);
		//if(seed<0){seed = -seed;}
		m_Seed = seed;
		m_ulSeed=(ULONG) m_Seed;
	}

	virtual T Rand(){
		return (float)arg_rand(&m_ulSeed) / ( (float)m_Max + 1.0f );
	}
	virtual T Random(T fMax){
		return ( (float)arg_rand(&m_ulSeed) * fMax ) / ( (float)RAND_MAX + 1.0f );
	}
	//min<= x <max܂ł̒lԂ
	virtual T RandomDomain(T min,T max){
		return (max-min)*Rand()+min;
	}
	virtual T RandomDomainSafety(T min,T max){
		MINMAX_SWAP_FLOAT(T,min,max);
		MINMAX_ABS_FLOAT(T,min,max);
		MINMAX_SAFETY(min,max);
		return RandomDomain(min,max);
	}
};




/* Period parameters */
#define N 624
#define M 397
#define MATRIX_A 0x9908b0df   /* constant vector a */
#define UPPER_MASK 0x80000000 /* most significant w-r bits */
#define LOWER_MASK 0x7fffffff /* least significant r bits */

/* Tempering parameters */
#define TEMPERING_MASK_B 0x9d2c5680
#define TEMPERING_MASK_C 0xefc60000
#define TEMPERING_SHIFT_U(y)  (y >> 11)
#define TEMPERING_SHIFT_S(y)  (y << 7)
#define TEMPERING_SHIFT_T(y)  (y << 15)
#define TEMPERING_SHIFT_L(y)  (y >> 18)

///CCĂ̂őMT@
template<class T>
class INL_dKingyoRandom_MT{
	UINT m_Max;
	unsigned long bInitialized ;
	// Static member 
	int mti;                   // index number 
	unsigned long mt[N + 1];   // the array for the state vector 
	unsigned long mtr[N];      // the array for the random number 
public:
	INL_dKingyoRandom_MT(T seed=timeGetTime()){
		m_Max=2^32-1;
		SetSeed(seed);
		bInitialized=0;
	}
	virtual ~INL_dKingyoRandom_MT(){}
	UINT GetMax(){return m_Max;}
	void SetSeed(T seed){
		int i;
		for(i = 0; i < N; i++){
			 mt[i] = seed & 0xffff0000;
			 seed = 69069 * seed + 1;
			 mt[i] |= (seed & 0xffff0000) >> 16;
			 seed = 69069 * seed + 1;
		}
		bInitialized = 1;
		generateMT();
	}
	T Rand(){
		if(mti >= N){
			if(!bInitialized) SetSeed(4357);
			generateMT();
		}
		return mtr[mti++]; 
	}
	T Random(T max){return Rand() * max / m_Max;}
	//min<= x <max܂ł̒lԂ
	T RandomDomain(T min,T max){
		return (max-min)*Rand()+min;
	}
	T RandomDomainSafety(T min,T max){
		MINMAX_SWAP(T,min,max);
		MINMAX_ABS(min,max);
		MINMAX_SAFETY(min,max);
		return RandomDomain(min,max);
	}
	void generateMT(void)
	{
		int kk;
		unsigned long y;
		static unsigned long mag01[2] = {0x0, MATRIX_A}; /* mag01[x] = x * MATRIX_A  for x=0,1 */
    
		for(kk = 0; kk < N - M; kk++){
			y = (mt[kk] & UPPER_MASK) | (mt[kk + 1] & LOWER_MASK);
			mt[kk] = mt[kk + M] ^ (y >> 1) ^ mag01[y & 0x1];
		}

		mt[N] = mt[0];

		for(; kk < N; kk++){
			y = (mt[kk] & UPPER_MASK) | (mt[kk + 1] & LOWER_MASK);
			mt[kk] = mt[kk + (M - N)] ^ (y >> 1) ^ mag01[y & 0x1];
		}

		for(kk = 0; kk < N; kk++){
			y = mt[kk];
			y ^= TEMPERING_SHIFT_U(y);
			y ^= TEMPERING_SHIFT_S(y) & TEMPERING_MASK_B;
			y ^= TEMPERING_SHIFT_T(y) & TEMPERING_MASK_C;
			y ^= TEMPERING_SHIFT_L(y);
			mtr[kk] = y;
		}
		mti = 0;
	}
};

template<class T>
class dKingyoRandom_MT : public dKingyoRandom_BasicMember<T>{//Please long or ULONG
	INL_dKingyoRandom_MT<T> m_mt;
public:
	dKingyoRandom_MT(T seed=timeGetTime()){
		m_Max = m_mt.GetMax();
		m_mt.SetSeed(seed);
	}
	virtual ~dKingyoRandom_MT(){}

	virtual void SetSeed(T seed){
		m_mt.SetSeed(seed);
	}
	virtual T Rand(){
		return m_mt.Rand();
	}
	virtual T Random(T max){return m_mt.Random(max);}
	//min<= x <max܂ł̒lԂ
	virtual T RandomDomain(T min,T max){
		return m_mt.RandomDomain(min,max);
	}
	virtual T RandomDomainSafety(T min,T max){
		return m_mt.RandomDomainSafety(min,max);
	}
};

///CrandƓ𔭐NX
class dKingyoRandom_ANSI_NO_SETUP : public dKingyoRandom_ANSI<int>{
public:	
	dKingyoRandom_ANSI_NO_SETUP(){}
};
///MT@ŗ𔭐NX
class dKingyoRandom_MT_NO_SETUP : public dKingyoRandom_MT<ULONG>{
public:
	dKingyoRandom_MT_NO_SETUP(){}
};
///_ifloat)ŗ𔭐NX
class dKingyoRandom_Float_NO_SETUP : public dKingyoRandom_Float<float>{
public:
	dKingyoRandom_Float_NO_SETUP(){}
};

#undef N
#undef M
#undef MATRIX_A
#undef UPPER_MASK
#undef LOWER_MASK

#undef TEMPERING_MASK_B
#undef TEMPERING_MASK_C
#undef TEMPERING_SHIFT_U 
#undef TEMPERING_SHIFT_S
#undef TEMPERING_SHIFT_T
#undef TEMPERING_SHIFT_L


}//end of math namespace
}//end of dkutil namespace


#endif


/* This main() outputs first 1000 generated numbers.  
int main(int argc, char *argv[])
{ 
    int i;

    srandMT(4357);
    for (i=0; i<1000; i++) {
        printf("%10lu ", randMT());
        if (i%5==4) printf("\n");
    }
    return EXIT_SUCCESS;
}
*/













/*
QlF
http://www2t.biglobe.ne.jp/~bono/c/memo1.htm
http://members.tripod.co.jp/cprogram/various1.html


̔


֐ɂ锭 
stdlib.hCN[hāCrand()p
EbCurand֐́COrand()̌Ăяoœꂽ̒lɓKȉZ{āC̗쐬悤ɂȂĂD
EԍŏrandĂяoƂCʂsrand֐ŗ̏lƂȂlw肷D𗐐̎ƂD
E̎K؂ɐݒ肵ȂƁC񓯂𔭐邱ƂɂȂD
ŁC݂̎^邱ƂŖႤɂȂ悤ɐݒ肷

srand((unsigned)time(NULL)); //̏


`@ɂl 
KȏlX0n

Xn = ( A*Xn-1 + C ) mod M
ƂpāCXɂO`l͈̔͂̒l𔭐D
ÁCWŊė]肪T̐
ĆC
ḾC2^n@ƂŁCO`l|P@܂ł̐lłP񂸂D 


̔ 
`@gāCO`P̎𔭐֐̗
double rnd(void)
{
    unsigned rndnum=13;

    rndnum=(rndnum*109+1021)%32768;
    return rndnum/32767.1;
} 

1`M܂ł̗𔭐 
r=(int)(M*rand()/32767.1+1);


Ki{bNXE~[@j 
m,W΍Ђ̐KzN(m,)ɏ]̔

void boxrnd(double m,double sig,double *x,double *y)
{
    double r1,r2;
    r1=rand()/32767.1;
    r2=rand()/32767.1;
    *x=sig*sqrt(-2*log(r1))*cos(2*3.14159*r2)+m;
    *y=sig*sqrt(-2*log(r1))*sin(2*3.14159*r2)+m;
}
stdlib.hmath.h̃CN[hYȂ悤ɁI  


*/
