#include "compiled.h"
#include "tested.h"
#include <dkutil/include/dkutilAllInclude.h>
#ifndef __GNUG__
#include <dkutil/math/oldmath/math_allinclude.h>
#endif

namespace dkutil{

using namespace dkutil;

void change_extension(std::string &e,const char *p){
	std::string::reverse_iterator rit=e.rbegin();
	for(int c=0;rit != e.rend();rit++,c++)
	{
		if(*rit=='.'){
			e.erase(e.size() - c,c);
			break;
		}
	}
	e += p;
}


void TestZlibCompress(){
	//zlib wrapper test
	try{
		std::string target;
		std::string compress;
		std::string decompress;
		{
			char buff[MAX_PATH * 2]="";
			bool r=FileOpenDialog(buff,sizeof(buff),
				"select compress target file","(*.*)*.*" ,"all files");
			if(false==r) return;
			target = buff;
		}
		//t@CƂ
		compress = target;
		change_extension(compress,"zlibbin");
		decompress = target;
		change_extension(decompress,"unzlib");
	
		//ŏtarget̃t@CǂݍŌŔr̂ɂƂĂ
		file_operator tmp_op(target.c_str());
		tmp_op.open();
		scoped_buffer reserve(GetFileSizeMini(target.c_str()) + 1); 
		tmp_op.read(reserve.get(),reserve.size());
		
		{
			file_operator read_operate(target.c_str(),policy::f_readonly);
			file_operator write_operate(compress.c_str(),policy::f_write);
			policy::zlib_encoder e;
			zlib_general_purpose_process( 1024,1024,e,read_operate,write_operate,Z_BEST_COMPRESSION);
		}

		{
			policy::zlib_decoder d;
			file_operator read_operate(compress.c_str(),policy::f_readonly);
			file_operator write_operate(decompress.c_str(),policy::f_write);
			zlib_general_purpose_process( 1024,1024,d,read_operate,write_operate);
		}

		scoped_buffer check(GetFileSizeMini(decompress.c_str()) + 1);
		tmp_op.reset(decompress.c_str(),policy::f_readonly,policy::f_binary);
		tmp_op.open();
		tmp_op.read(check.get(),check.size());

		if(reserve.size() != check.size()){
			MB("size error");
		}
		bool result=DKUTIL_SUCCEEDED(dkmemcmp(reserve.get(),reserve.size(),check.get(),check.size()));
		if(result == false){
			MB("compare error");
		}
	}
	catch(std::runtime_error err){

		MB(err.what());
	}
	//zlib speed test

}




int TestCommandLineParser(HINSTANCE hInstance,HINSTANCE hPrevInstance,
									 LPSTR lpCmdLine,int nShowCmd
									)
{
	//CommandLineParser Test
	typedef private_::CommandLineParser PAR;
	PAR par(lpCmdLine,nShowCmd);
	PAR::const_iterator it;
	for(it=par.begin();it != par.end();it++)
	{
		dMB("your command line",(*it).str.c_str());
	}
	par.reset(" command ok hohoho -f\" sugsig\" -a\"ddrddr\" ahoaho\"\" ",0);
	for(it=par.begin();it != par.end();it++)
	{
		dODS("sig[%s] str[%s]",(*it).sig.c_str(),(*it).str.c_str());
	}
	return 0;
}

#ifndef __GNUG__

void TestProcessTimer()
{
	{
		//ProcessTimer<ProgressClockTiemr<> > p;
		ProcessTimer<ProgressRealCPUClockTiemr<> > p;
		oldmath::dKingyoRandom_MT_NO_SETUP mt;
		int a=0;
		p.begin();
		for(int i=0;i<100;i++){
			mt.Rand();
		}
		p.end();
	}
}

void TestINIManager(){
	{
		typedef INIManager INIM;
		INIM m;
		if(false==m.reset("test02.ini")){
			MB("PARSING ERROR");
		}
		if(m.empty()){
			MB("ERROR");
		}
		for(INIM::const_section_iterator it=m.begin();it!=m.end();it++)
		{
			dODS("[%s]",(*it).first.c_str());
			for(INIM::const_key_iterator kit=(*it).second.begin();
			kit!=(*it).second.end();kit++)
			{
				dODSNoNewLine("%s = ",(*kit).first.c_str());
				(*kit).second.Data.print();
			}
		}
	}
}
#else
void TestINIManager(){
	ODS("Can't Test Mingw");
}
void TestProcessTimer(){
	TestINIManager();
	}
#endif



void TestVersionInfo(){
		//const char *sig[]={
		const char *sig[13]={
		     "Comments"   ,      // Rg
	      "CompanyName"   ,   // Ж
	      "FileDescription",  // 
	      "FileVersion"   ,   // t@Co[W
		    "InternalName" ,    // 
	      "LegalCopyright",   // 쌠
	      "LegalTrademarks",  // W
	      "OriginalFilename", // t@C
	      "PrivateBuild" ,   // vCx[grh
	      "ProductName"  ,    // i
	      "ProductVersion",   // io[W
	      "SpecialBuild",     // XyVrh
				NULL
	};
	GetVersionInfo v;
	char buff[1024]="";
	size_t len = 12;
	for(size_t i = 0;i<len;i++){
		if(false==v.GetInfo("comctl32.dll",buff,sizeof(buff),sig[i]))
		{}else{
			dODS("%s = %s",sig[i],buff);
		}
	}
}


}//end of dkutil namespace
