

/*!
@file dkutilStdio.h
@brief		buffer over flowȂ@֐^^;
@author		d
@since		2003/8/19
@note
I<br>
http://www-6.ibm.com/jp/developerworks/security/000616/j-buffer-defend.html
<br?
ŁAv񥥥<br>
<PRE>
gets ł댯 fgets(buf, size, stdin) gpĂB͏ɑ傫Ȗł! 
strcpy Ɋ댯 strncpy pĂB 
strcat Ɋ댯 strncat pĂB 
sprintf Ɋ댯 snprintf p邩AxwqgpĂB 
scanf Ɋ댯 xwqgp邩AƎ̉͂sĂB 
sscanf Ɋ댯 xwqgp邩AƎ̉͂sĂB 
fscanf Ɋ댯 xwqgp邩AƎ̉͂sĂB 
vfscanf Ɋ댯 xwqgp邩AƎ̉͂sĂB 
vsprintf Ɋ댯 vsnprintf p邩AxwqgpĂB 
vscanf Ɋ댯 xwqgp邩AƎ̉͂sĂB 
vsscanf Ɋ댯 xwqgp邩AƎ̉͂sĂB 
streadd Ɋ댯 ̃TCYƂă\[XEp[^[ 4 {̃TCYUĂB 
strecpy Ɋ댯 ̃TCYƂă\[XEp[^[ 4 {̃TCYUĂB 
strtrns 댯 悪ȂƂ\[XEXgOƓTCYł邱ƂƂŊmFĂB 
realpath Ɋ댯 (Cve[VɂĂ͊댯x͒ႭȂ܂) obt@[ MAXPATHLEN ̃TCYɂȂ悤ɊUĂB܂A͈ MAXPATHLEN 蒷ȂƂƂŊmFĂB 
syslog Ɋ댯 (Cve[VɂĂ͊댯x͒ႭȂ܂) ̊֐ɓnOɁAׂẴXgO͂K؂ȃTCYɐ؂̂ĂĂB 
getopt Ɋ댯 (Cve[VɂĂ͊댯x͒ႭȂ܂) ̊֐ɓnOɁAׂẴXgO͂K؂ȃTCYɐ؂̂ĂĂB 
getopt_long Ɋ댯 (Cve[VɂĂ͊댯x͒ႭȂ܂) ̊֐ɓnOɁAׂẴXgO͂K؂ȃTCYɐ؂̂ĂĂB 
getpass Ɋ댯 (Cve[VɂĂ͊댯x͒ႭȂ܂) ̊֐ɓnOɁAׂẴXgO͂K؂ȃTCYɐ؂̂ĂĂB 
getchar 댯 ̊֐[vŎgpĂꍇ́Aobt@[E`FbNĂB 
fgetc 댯 ̊֐[vŎgpĂꍇ́Aobt@[E`FbNĂB 
getc 댯 ̊֐[vŎgpĂꍇ́Aobt@[E`FbNĂB 
read 댯 ̊֐[vŎgpĂꍇ́Aobt@[E`FbNĂB 
bcopy 댯x͒Ⴂ obt@[ETCYvĂƂ̑傫ł邩mFĂB 
fgets 댯x͒Ⴂ obt@[ETCYvĂƂ̑傫ł邩mFĂB 
memcpy 댯x͒Ⴂ obt@[ETCYvĂƂ̑傫ł邩mFĂB 
snprintf 댯x͒Ⴂ obt@[ETCYvĂƂ̑傫ł邩mFĂB 
strccpy 댯x͒Ⴂ obt@[ETCYvĂƂ̑傫ł邩mFĂB 
strcadd 댯x͒Ⴂ obt@[ETCYvĂƂ̑傫ł邩mFĂB 
strncpy 댯x͒Ⴂ obt@[ETCYvĂƂ̑傫ł邩mFĂB 
vsnprintf 댯x͒Ⴂ obt@[ETCYvĂƂ̑傫ł邩mFĂB 
</PRE>
```IȂɊȂ֐͎gĂ̂II<br>

*/

#ifndef _dkutilStdio__
#define _dkutilStdio__

#include "dkutilDefined.h"

namespace dkutil{
	
	/*!
	@param dest[out] Rs[
	@param size1[in] dest̃TCY
	@param src[in] Rs[
	@param size2[in] src̃TCY
	@return size1 < size2 edk_FAILEDԂB
	*/
	///memcpÿSŁH
	inline int dkmemcpy(void *dest,size_t size1,const void *src,size_t size2){
		if(size1 < size2) return edk_FAILED;
		::memcpy(dest,src,size2);
		return edk_SUCCEEDED;
	}
	inline int dksprintf(char *buff,size_t bufsize,char *format,...){
		SET_VA_LIST(buff,bufsize,format);		
		return edk_SUCCEEDED;
	}
	/*!
	@note
	<b>strncpẙ댯</b><br>
	string2 ̍ŏ count  string1 ɃRs[Ă string1 Ԃ܂B
	count string2 ̒ȉ̏ꍇ́A
	<font color=red>Rs[ɎI NULL  (\0) t܂B</font><br>
	<br>
	Ȃ̂ŁAsrcleñTCYsize1傫ꍇedk_FAILEDԂ܂B
	@param dest[out] Rs[
	@param size1[in] dest̃TCY
	@oaram src[in] Rs[
	@param srclen[in] srcRs[镶
	*/
	inline int dkstrcpy(char *dest,size_t size1,const char *src,size_t srclen){
		if(size1 < srclen) return edk_FAILED;
		::strncpy(dest,src,srclen);
		//if(dest[srclen] != '\0') return edk_FAILED;
		dest[srclen] = '\0';
		return edk_SUCCEEDED;
	}
	///dkstrcpyƈႢAobt@ɓ邾Rs[B@note amap = as much as possible.
	inline int dkstrcpy_amap(char *dest,size_t size1,const char *src,size_t srclen){
		if(size1 < srclen){//<=IH
			::strncpy(dest,src,size1);
			dest[size1 - 1] = '\0';
			return edk_Not_Satisfactory;
		}else{
			::strncpy(dest,src,srclen);
			dest[srclen] = '\0';
			return edk_SUCCEEDED;
		}
	}
	inline int dkstrcpy_amap2(char *dest,size_t size1,const char *src){
		return dkstrcpy_amap(dest,size1,src,strlen(src));
	}
	/*!
	@param dest[out] Rs[
	@param destsize[in] dest̃TCY(byte)
	@param destlen[in] destɓĂ镶̒ *1
	@param src[in] Rs[
	@param srclen[in] Rs[ɓĂ镶̒ *1
	@note
	<b>*1:</b> NULL܂܂ȂB<br>
	<b>strncat̊댯H</b><br>
	ǂȂĂ邩͕ȂA
	dest̃TCY`FbNĂSƎvB<br>
	*/
	inline int dkstrcat(char *dest,size_t destsize,size_t destlen,
		const char *src,size_t srclen)
	{
		//destlen + srclen + NULL
		if(destsize < destlen + srclen + 1)	return edk_FAILED;
		::strncat(dest,src,srclen);
		return edk_SUCCEEDED;
	}
	///dkstrcat()Helper ֐
	inline int dkstrcat2(char *dest,size_t destsize,const char *src){
		return dkstrcat(dest,destsize,strlen(dest),src,strlen(src));
	}
	///dkstrcat()̏o邾Rs[ 
	inline int dkstrcat_amap(char *dest,size_t destsize,size_t destlen,
		const char *src,size_t srclen)
	{
		//destlen + srclen + NULL
		int result = edk_SUCCEEDED;
		size_t lsize = destlen + srclen + 1;
		if(destsize < lsize)
		{//I[o[Ă祥
			srclen = lsize - destsize - 1;
			result = edk_Not_Satisfactory;
		}
		::strncat(dest,src,srclen);
		//dest[destlen + srclen - 1] = '\0';
		return result;
	}
	///dkstrcat3Helper
	inline int dkstrcat_amap2(char *dest,size_t destsize,const char *src){
		return dkstrcat_amap(dest,destsize,strlen(dest),src,strlen(src));
	}

	/*!
	@param buf1[in] robt@̂P
	@param buf1PermitSize[in] buf1̃TCY
	@param buf2[in] robt@̂Q
	@param count[in] oCgr邩ǂ̃TCY
	*/	
	inline int dkmemcmp( const void *buf1,size_t buf1PermitSize, const void *buf2, size_t count )
	{
		if(buf1PermitSize < count)return edk_FAILED;
		if(0 !=::memcmp(buf1,buf2,count))return edk_FAILED;
		return edk_SUCCEEDED;
	}
		





#if 0

	class datatable{
		enum{
			enuDigitNum=10,
			enuDigit16Num=6,
			enuCTOI_CHECK=48,
			enuCTOI16_LOWER=97,
			enuCTOI16_WUPPER=65,
		};
		static char digit[enuDigitNum];
		static char digit16[enuDigit16Num];
		datatable(){
			{for(int i=0;i<enuDigitNum;i++){
				digit[i]=i;
			}}
			{for(int i=0;i<enuDigit16Num;i++){
				digit16[i]=10+i;
			}}
		}
		int ctoi(char c){
#		ifdef _DEBUG
			char *str="ւȈȁI";
			if(c < enuCTOI_CHECK){
				throw std::invalid_argument(str);
			}else if(c > enuCTOI_CHECK + 10){
				throw std::invalid_argument(str);
			}
#		endif
			return digit[c-48];
		}
		int ctoi16(char c){
			if(isAlpha(c)){
				if(islower(c)){
					return digit16[c - enuCTOI16_LOWER];
				}else
				{
#		ifdef _DEBUG
					if(iswupper(c)){
						return digit16[c - enuCTOI16_WUPPER];
					}else{
						throw std::invalid_argument("ԈĂ܂");
					}
#		else
					return digit16[c - enuCTOI16_WUPPER];
#		endif
				}
			}else{
				return ctoi(c);
			}
		}
	};
	datatable &GetDataTable(){
		static datatable tbl;
		return tbl;
	}
#	endif

		
			


#if 0
	inline int textcmp(char *
#endif
}//end of dkutil namespace

#endif //end of include once